/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.onyx.android.sdk.data.BookFilter;
import com.onyx.android.sdk.data.LibraryDataModel;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.QueryPagination;
import com.onyx.android.sdk.data.QueryResult;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.data.ViewType;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.Metadata_Table;
import com.onyx.android.sdk.data.utils.QueryBuilder;
import com.onyx.android.sdk.device.EnvironmentUtil;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LibraryViewInfo
implements Serializable {
    private int a;
    private QueryArgs b;
    private QueryPagination c;
    private LibraryDataModel d;
    private List<Library> e;
    private ViewType f;

    public LibraryViewInfo() {
        QueryArgs queryArgs;
        QueryArgs queryArgs2;
        LibraryViewInfo libraryViewInfo = this;
        libraryViewInfo.a = 9;
        libraryViewInfo.c = QueryPagination.create(3, 3);
        libraryViewInfo.d = new LibraryDataModel();
        libraryViewInfo.e = new ArrayList<Library>();
        libraryViewInfo.f = ViewType.Thumbnail;
        QueryArgs queryArgs3 = queryArgs2 = queryArgs;
        queryArgs3();
        this.b = queryArgs3;
        queryArgs.limit = this.a;
        libraryViewInfo.c.setCurrentPage(0);
    }

    /*
     * WARNING - void declaration
     */
    public static LibraryViewInfo create(int rows, int cols) {
        void var1_1;
        int n2;
        SortBy sortBy = SortBy.Name;
        SortOrder sortOrder = SortOrder.Asc;
        return new LibraryViewInfo(n2, (int)var1_1, sortBy, sortOrder);
    }

    /*
     * WARNING - void declaration
     */
    public LibraryViewInfo(int row, int col, SortBy sortBy, SortOrder sortOrder) {
        void var4_5;
        void var3_4;
        void var2_3;
        void var1_2;
        LibraryViewInfo libraryViewInfo = this;
        libraryViewInfo();
        void var0_1 = var1_2 * var2_3;
        this.a = var0_1;
        libraryViewInfo.b.limit = var0_1;
        libraryViewInfo.c.resize((int)var1_2, (int)var2_3, 0);
        libraryViewInfo.c.setCurrentPage(0);
        this.updateSortBy((SortBy)var3_4, (SortOrder)var4_5);
    }

    private OperatorGroup a() {
        LibraryViewInfo libraryViewInfo = this_;
        LibraryViewInfo this_ = OperatorGroup.clause().or((SQLOperator)Metadata_Table.storageId.isNull());
        String string2 = libraryViewInfo.getSdcardCid();
        if (StringUtils.isNotBlank((String)string2)) {
            this_.or((SQLOperator)Metadata_Table.storageId.is((Object)string2));
        }
        return this_;
    }

    /*
     * WARNING - void declaration
     */
    public static LibraryDataModel buildLibraryDataModel(QueryResult<Metadata> result, Map<String, CloseableReference<Bitmap>> map) {
        void var1_1;
        QueryResult<Metadata> queryResult;
        LibraryDataModel libraryDataModel;
        LibraryDataModel libraryDataModel2 = libraryDataModel;
        libraryDataModel = new LibraryDataModel();
        if (result == null) {
            return libraryDataModel2;
        }
        libraryDataModel2.visibleLibraryList = new ArrayList<Library>();
        libraryDataModel2.visibleBookList = queryResult.list;
        libraryDataModel2.bookCount = (int)queryResult.count;
        libraryDataModel2.thumbnailMap = var1_1;
        libraryDataModel2.libraryCount = 0;
        return libraryDataModel2;
    }

    /*
     * WARNING - void declaration
     */
    public int getOffset(int currentPage) {
        int n2;
        LibraryViewInfo libraryViewInfo = serializable;
        Serializable serializable = libraryViewInfo.getLibraryDataModel();
        int n3 = libraryViewInfo.c.itemsPerPage();
        int n4 = currentPage * n3 - (n2 = ((LibraryDataModel)serializable).libraryCount);
        if (n4 < 0) {
            void var1_2;
            n4 = var1_2 <= n2 / n3 ? 0 : n3 + n4;
        }
        return n4;
    }

    public int getOffset() {
        LibraryViewInfo libraryViewInfo = this;
        return libraryViewInfo.getOffset(libraryViewInfo.c.getCurrentPage());
    }

    public QueryArgs nextPage() {
        this.b.offset = this.getOffset();
        return this.b;
    }

    public QueryArgs prevPage() {
        this.b.offset = this.getOffset();
        return this.b;
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs pageQueryArgs(int page) {
        void var1_1;
        this.b.copyPart().offset = this.getOffset((int)var1_1);
        return this.b.copyPart();
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs gotoPage(int page) {
        void var1_1;
        LibraryViewInfo libraryViewInfo = this;
        libraryViewInfo.c.setCurrentPage((int)var1_1);
        libraryViewInfo.b.offset = this.getOffset((int)var1_1);
        return libraryViewInfo.b;
    }

    public QueryArgs firstPage() {
        return this.gotoPage(0);
    }

    public QueryArgs lastPage() {
        LibraryViewInfo libraryViewInfo = this;
        return libraryViewInfo.gotoPage(libraryViewInfo.c.lastPage());
    }

    public String getSdcardCid() {
        return EnvironmentUtil.getRemovableSDCardCid();
    }

    public QueryArgs generateMetadataInQueryArgs(QueryArgs queryArgs) {
        return QueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public QueryArgs generateQueryArgs(QueryArgs queryArgs) {
        return QueryBuilder.generateQueryArgs(queryArgs);
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs libraryQuery(int limit, int offset) {
        void var2_2;
        void var1_1;
        LibraryViewInfo libraryViewInfo = this;
        libraryViewInfo.libraryQuery(libraryViewInfo.getLibraryIdString()).limit = var1_1;
        libraryViewInfo.libraryQuery(libraryViewInfo.getLibraryIdString()).offset = var2_2;
        return libraryViewInfo.libraryQuery(libraryViewInfo.getLibraryIdString());
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs libraryQuery(String libraryId) {
        void var1_1;
        QueryArgs queryArgs = this.buildLibraryQuery((String)var1_1);
        this.updateQueryArgs(queryArgs);
        return queryArgs;
    }

    /*
     * WARNING - void declaration
     */
    public QueryArgs buildLibraryQuery(String libraryId) {
        void var1_1;
        LibraryViewInfo libraryViewInfo = this;
        QueryArgs queryArgs = this.b;
        Object object = queryArgs.sortBy;
        Object object2 = object = new QueryArgs((SortBy)object, queryArgs.order).appendFilter(this.b.filter);
        object2.limit = this.a;
        object2.offset = 0;
        object.libraryUniqueId = var1_1;
        libraryViewInfo.generateQueryArgs((QueryArgs)object);
        Object object3 = object;
        QueryBuilder.andWith(object3.conditionGroup, this.a());
        return libraryViewInfo.generateMetadataInQueryArgs((QueryArgs)object3);
    }

    public QueryArgs libraryQuery() {
        LibraryViewInfo libraryViewInfo = this;
        return libraryViewInfo.libraryQuery(libraryViewInfo.b.limit, 0);
    }

    public QueryArgs getCurrentQueryArgs() {
        return this.b;
    }

    /*
     * WARNING - void declaration
     */
    public void updateQueryArgs(QueryArgs args) {
        void var1_1;
        this.b = var1_1;
    }

    public LibraryDataModel getLibraryDataModel() {
        return this.d;
    }

    /*
     * WARNING - void declaration
     */
    public void setLibraryDataModel(LibraryDataModel libraryDataModel) {
        void var1_1;
        LibraryViewInfo libraryViewInfo = this;
        libraryViewInfo.clearThumbnailMap(libraryViewInfo.getLibraryDataModel());
        this.d = var1_1;
    }

    public LibraryDataModel getPageLibraryDataModel(LibraryDataModel dataModel) {
        LibraryDataModel libraryDataModel;
        LibraryDataModel libraryDataModel2;
        LibraryViewInfo libraryViewInfo = this_;
        libraryViewInfo.setLibraryDataModel(libraryDataModel2);
        libraryDataModel2 = libraryDataModel;
        libraryDataModel = new LibraryDataModel();
        int n2 = libraryViewInfo.c.getCurrentPage();
        LibraryViewInfo libraryViewInfo2 = this_;
        int n3 = libraryViewInfo2.c.itemsPerPage();
        if (n2 > libraryViewInfo2.d.libraryCount / n3) {
            libraryDataModel2.visibleLibraryList = new ArrayList<Library>();
            libraryDataModel2.visibleBookList = this_.d.visibleBookList;
        } else {
            int n4 = n2 * n3;
            while (true) {
                LibraryDataModel libraryDataModel3 = this_.d;
                if (n4 >= libraryDataModel3.libraryCount || n4 >= (n2 + 1) * n3) break;
                libraryDataModel2.visibleLibraryList.add(libraryDataModel3.visibleLibraryList.get(n4));
                ++n4;
            }
            n2 = n3 - CollectionUtils.getSize(libraryDataModel2.visibleLibraryList);
            for (n3 = 0; n3 < n2 && n3 < CollectionUtils.getSize(this_.d.visibleBookList); ++n3) {
                libraryDataModel2.visibleBookList.add(this_.d.visibleBookList.get(n3));
            }
        }
        Serializable this_ = this_.d;
        libraryDataModel2.bookCount = ((LibraryDataModel)this_).bookCount;
        libraryDataModel2.libraryCount = ((LibraryDataModel)this_).libraryCount;
        libraryDataModel2.thumbnailMap = ((LibraryDataModel)this_).thumbnailMap;
        libraryDataModel2.notificationMap = ((LibraryDataModel)this_).notificationMap;
        return libraryDataModel2;
    }

    public QueryPagination getQueryPagination() {
        return this.c;
    }

    /*
     * WARNING - void declaration
     */
    public void setQueryPagination(QueryPagination queryPagination) {
        void var1_1;
        this.c = var1_1;
    }

    public String getLibraryIdString() {
        if (CollectionUtils.isNullOrEmpty(this.e)) {
            return null;
        }
        List<Library> list = this.e;
        return list.get(list.size() - 1).getIdString();
    }

    public List<Library> getLibraryPathList() {
        return this.e;
    }

    /*
     * WARNING - void declaration
     */
    public void setLibraryPathList(List<Library> newPathList) {
        void var1_1;
        this.e = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setCurrentSortOrder(SortOrder sortOrder) {
        void var1_1;
        this.b.order = var1_1;
    }

    public SortOrder getCurrentSortOrder() {
        return this.b.order;
    }

    public SortBy getCurrentSortBy() {
        return this.b.sortBy;
    }

    /*
     * WARNING - void declaration
     */
    public void updateSortBy(SortBy sortBy, SortOrder sortOrder) {
        void var2_2;
        void var1_1;
        QueryArgs queryArgs = this.b;
        queryArgs.sortBy = var1_1;
        queryArgs.order = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void updateSortBy(SortBy sortBy, SortOrder sortOrder, int page) {
        void var3_3;
        void var2_2;
        void var1_1;
        LibraryViewInfo libraryViewInfo = this;
        libraryViewInfo.updateSortBy((SortBy)var1_1, (SortOrder)var2_2);
        libraryViewInfo.getQueryPagination().setCurrentPage((int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void updateFilterBy(BookFilter filter, SortOrder sortOrder) {
        void var2_2;
        void var1_1;
        QueryArgs queryArgs = this.b;
        queryArgs.filter = var1_1;
        queryArgs.order = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void setQueryLimit(int limit) {
        void var1_1;
        this.a = var1_1;
        this.b.limit = var1_1;
    }

    public int getQueryLimit() {
        return this.a;
    }

    /*
     * WARNING - void declaration
     */
    public void resizePagination(int row, int col, int count) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.getQueryPagination().resize((int)var1_1, (int)var2_2, (int)var3_3);
    }

    public void toggleViewType() {
        ViewType viewType = ViewType.Thumbnail;
        if (this.f == viewType) {
            viewType = ViewType.Details;
        }
        this.f = viewType;
    }

    public ViewType getCurrentViewType() {
        return this.f;
    }

    /*
     * WARNING - void declaration
     */
    public void setCurrentViewType(ViewType viewType) {
        void var1_1;
        this.f = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void clearThumbnailMap(LibraryDataModel dataModel) {
        void var1_1;
        if (dataModel != null && !CollectionUtils.isNullOrEmpty(var1_1.thumbnailMap)) {
            Iterator<CloseableReference<Bitmap>> iterator = var1_1.thumbnailMap.values().iterator();
            while (iterator.hasNext()) {
                ((CloseableReference)iterator.next()).close();
            }
            return;
        }
    }
}

