/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.QueryResult;
import com.onyx.android.sdk.data.cache.BitmapReferenceLruCache;
import com.onyx.android.sdk.data.compatability.OnyxThumbnail;
import com.onyx.android.sdk.data.db.ContentDatabase;
import com.onyx.android.sdk.data.manager.CacheManager;
import com.onyx.android.sdk.data.model.BaseData;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.MetadataCollection;
import com.onyx.android.sdk.data.model.Metadata_Table;
import com.onyx.android.sdk.data.model.Thumbnail;
import com.onyx.android.sdk.data.model.common.FetchPolicy;
import com.onyx.android.sdk.data.model.v2.CloudMetadataCollection;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.provider.DataProviderManager;
import com.onyx.android.sdk.data.utils.ThumbnailUtils;
import com.onyx.android.sdk.device.EnvironmentUtil;
import com.onyx.android.sdk.utils.BitmapUtils;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.NetworkUtil;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.language.property.Property;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DataManagerHelper {
    private static DataProviderBase a() {
        return DataProviderManager.getLocalDataProvider();
    }

    /*
     * WARNING - void declaration
     */
    public static List<Library> loadLibraryList(DataManager dataManager, List<Library> list, String parentId) {
        void var1_1;
        void var2_2;
        QueryArgs queryArgs;
        QueryArgs queryArgs2 = queryArgs;
        queryArgs2();
        queryArgs.libraryUniqueId = var2_2;
        return DataManagerHelper.loadLibraryList(dataManager.getRemoteContentProvider(), (List<Library>)var1_1, queryArgs2);
    }

    /*
     * WARNING - void declaration
     */
    public static List<Library> loadLibraryList(DataProviderBase dataProvider, List<Library> list, QueryArgs args) {
        void var2_2;
        List<Library> list2 = dataProvider.loadAllLibrary(var2_2.libraryUniqueId, (QueryArgs)var2_2);
        if (!CollectionUtils.isNullOrEmpty(list2)) {
            void var1_1;
            var1_1.addAll(list2);
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    public static void loadLibraryRecursive(DataProviderBase dataProvider, List<Library> list, QueryArgs args) {
        void var2_2;
        void var1_1;
        List<Library> list2 = DataManagerHelper.loadLibraryList(dataProvider, (List<Library>)var1_1, (QueryArgs)var2_2);
        if (CollectionUtils.isNullOrEmpty(list2)) {
            return;
        }
        for (Library library : list2) {
            DataProviderBase dataProviderBase;
            QueryArgs queryArgs;
            QueryArgs queryArgs2 = queryArgs;
            queryArgs2();
            queryArgs2.libraryUniqueId = library.getIdString();
            queryArgs.fetchPolicy = var2_2.fetchPolicy;
            DataManagerHelper.loadLibraryRecursive(dataProviderBase, (List<Library>)var1_1, queryArgs2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void loadLibraryRecursive(DataManager dataManager, List<Library> list, String targetId) {
        void var1_1;
        void var2_2;
        QueryArgs queryArgs;
        QueryArgs queryArgs2 = queryArgs;
        queryArgs2();
        queryArgs.libraryUniqueId = var2_2;
        queryArgs.fetchPolicy = 1;
        DataManagerHelper.loadLibraryRecursive(dataManager.getRemoteContentProvider(), (List<Library>)var1_1, queryArgs2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static Library addLibraryByPath(Context context, DataProviderBase dataProvider, String path, boolean setParentId) {
        void var1_1;
        void var2_2;
        Library library;
        Library library2 = library;
        library2();
        library2.setName(FileUtils.getFileName((String)var2_2));
        library.setIdString((String)var2_2);
        if (setParentId) {
            library2.setParentUniqueId(FileUtils.getParent((String)var2_2));
        }
        if (EnvironmentUtil.isFileOnRemovableSDCard((File)new File((String)var2_2))) {
            library2.setStorageId(EnvironmentUtil.getRemovableSDCardCid());
        }
        var1_1.addLibrary(library2);
        return library2;
    }

    /*
     * WARNING - void declaration
     */
    public static Thumbnail loadThumbnail(Context context, String path, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        void var3_3;
        Context context2;
        String string2;
        if (StringUtils.isNullOrEmpty((String)associationId)) {
            try {
                void var1_1;
                string2 = FileUtils.computeMD5((File)new File((String)var1_1));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return DataManagerHelper.a().getThumbnailEntry(context2, string2, (OnyxThumbnail.ThumbnailKind)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap loadThumbnailBitmap(Context context, Thumbnail thumbnail) {
        void var1_1;
        Context context2;
        return DataManagerHelper.a().getThumbnailBitmap(context2, var1_1.getIdString(), OnyxThumbnail.ThumbnailKind.Original);
    }

    /*
     * WARNING - void declaration
     */
    public static Metadata getMetadataByCloudReference(Context context, String cloudReference) {
        void var1_1;
        return (Metadata)((Object)new Select(new IProperty[0]).from(Metadata.class).where(new SQLOperator[]{Metadata_Table.cloudId.eq((Object)var1_1)}).querySingle());
    }

    /*
     * WARNING - void declaration
     */
    public static Metadata getMetadataByHashTag(Context context, String hashTag) {
        void var1_1;
        return (Metadata)((Object)new Select(new IProperty[0]).from(Metadata.class).where(new SQLOperator[]{Metadata_Table.hashTag.eq((Object)var1_1)}).querySingle());
    }

    /*
     * WARNING - void declaration
     */
    public static void deleteAllLibrary(Context context, DataManager dataManager, String parentUniqueId, List<Library> libraryList) {
        void var3_3;
        void var2_2;
        void var1_1;
        DataManagerHelper.deleteAllLibrary(context, var1_1.getRemoteContentProvider(), (String)var2_2, (List<Library>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static void deleteAllLibrary(Context context, DataProviderBase providerBase, String parentUniqueId, List<Library> libraryList) {
        void var3_4;
        void var1_2;
        void var2_3;
        boolean bl = StringUtils.isNullOrEmpty((String)var2_3);
        DataManagerHelper.deleteAllLibrary(context, (DataProviderBase)var1_2, (String)var2_3, (List<Library>)var3_4, bl);
    }

    /*
     * WARNING - void declaration
     */
    public static void deleteAllLibrary(Context context, DataProviderBase providerBase, String parentUniqueId, List<Library> libraryList, boolean isDeleteMetaCollection) {
        for (Library library : libraryList) {
            Context context2;
            void var1_1;
            void var4_4;
            if (var4_4 != false) {
                var1_1.deleteMetadataCollection(context2, library.getIdString());
            } else {
                for (MetadataCollection metadataCollection : var1_1.loadMetadataCollection(context2, library.getIdString())) {
                    void var2_2;
                    metadataCollection.setLibraryUniqueId((String)var2_2);
                    var1_1.updateMetadataCollection(metadataCollection);
                }
            }
            var1_1.deleteLibrary(library);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void deleteMetadataCollection(Context context, DataManager dataManager, String libraryIdString) {
        void var2_2;
        Context context2;
        dataManager.getRemoteContentProvider().deleteMetadataCollection(context2, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static MetadataCollection loadMetadataCollection(Context context, DataManager dataManager, String libraryIdString, String metaIdString) {
        void var3_3;
        void var2_2;
        Context context2;
        return dataManager.getRemoteContentProvider().loadMetadataCollection(context2, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static List<MetadataCollection> loadMetadataCollection(Context context, DataManager dataManager, String libraryIdString) {
        void var2_2;
        Context context2;
        return dataManager.getRemoteContentProvider().loadMetadataCollection(context2, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static List<Metadata> loadMetadataListWithCache(Context context, DataManager dataManager, QueryArgs queryArgs, boolean loadFromCache) {
        Context context2;
        void var1_1;
        void var2_2;
        String string2 = CacheManager.generateQueryListKey((QueryArgs)var2_2);
        List<Metadata> list = null;
        if (loadFromCache) {
            list = var1_1.getCacheManager().getMetadataLruCache(string2);
        }
        if (list == null && !CollectionUtils.isNullOrEmpty(list = var1_1.getRemoteContentProvider().findMetadataByQueryArgs(context2, (QueryArgs)var2_2))) {
            var1_1.getCacheManager().addToMetadataCache(string2, list);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Library> loadLibraryListWithCache(Context context, DataManager dataManager, String libraryUniqueId, boolean loadFromCache) {
        void var1_1;
        void var2_2;
        Object object = String.valueOf(var2_2);
        ArrayList<Library> arrayList = null;
        if (loadFromCache) {
            arrayList = var1_1.getCacheManager().getLibraryLruCache((String)object);
        }
        if (arrayList == null) {
            ArrayList<Library> arrayList2;
            arrayList = arrayList2;
            DataManagerHelper.loadLibraryList((DataManager)var1_1, new ArrayList<Library>(), (String)var2_2);
            if (!CollectionUtils.isNullOrEmpty(arrayList)) {
                var1_1.getCacheManager().addToLibraryCache((String)object, arrayList);
            }
        }
        return arrayList;
    }

    public static OnyxThumbnail.ThumbnailKind getDefaultThumbnailKind() {
        return ThumbnailUtils.DEFAULT_THUMBNAIL_KIND;
    }

    /*
     * WARNING - void declaration
     */
    public static Thumbnail getThumbnailEntry(Context context, DataProviderBase dataProvider, String associationId) {
        void var2_2;
        void var1_1;
        return ThumbnailUtils.getThumbnailEntry(context, (DataProviderBase)var1_1, (String)var2_2, DataManagerHelper.getDefaultThumbnailKind());
    }

    /*
     * WARNING - void declaration
     */
    public static String getThumbnailPath(Context context, DataProviderBase dataProvider, String associationId) {
        void var2_2;
        void var1_1;
        Object object = DataManagerHelper.getThumbnailEntry(context, (DataProviderBase)var1_1, (String)var2_2);
        if (object == null) {
            return null;
        }
        if (!FileUtils.fileExist((String)object.getImageDataPath())) {
            return null;
        }
        return object.getImageDataPath();
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, CloseableReference<Bitmap>> loadThumbnailBitmapsWithCache(Context context, DataManager dataManager, List<Metadata> metadataList) {
        HashMap<String, CloseableReference<Bitmap>> hashMap;
        HashMap<String, CloseableReference<Bitmap>> hashMap2 = hashMap;
        hashMap = new HashMap<String, CloseableReference<Bitmap>>();
        for (Metadata metadata : metadataList) {
            void var1_1;
            Context context2;
            CloseableReference<Bitmap> closeableReference = DataManagerHelper.loadThumbnailBitmapWithCache(context2, (DataManager)var1_1, metadata);
            if (closeableReference == null) continue;
            hashMap2.put(metadata.getAssociationId(), closeableReference);
        }
        return hashMap2;
    }

    public static CloseableReference<Bitmap> loadThumbnailBitmapWithCache(Context context, DataManager dataManager, Metadata metadata) {
        String string2;
        BitmapReferenceLruCache bitmapReferenceLruCache;
        void v0 = bitmapReferenceLruCache;
        Object object = v0.getRemoteContentProvider();
        bitmapReferenceLruCache = v0.getCacheManager().getBitmapLruCache();
        string2 = ((Metadata)((Object)string2)).getAssociationId();
        return DataManagerHelper.loadThumbnailBitmapWithCache(context, (DataProviderBase)object, bitmapReferenceLruCache, string2);
    }

    /*
     * WARNING - void declaration
     */
    public static CloseableReference<Bitmap> loadThumbnailBitmapWithCache(BitmapReferenceLruCache bitmapLruCache, String path) {
        void var1_1;
        BitmapReferenceLruCache bitmapReferenceLruCache;
        if (StringUtils.isNullOrEmpty((String)path)) {
            return null;
        }
        Bitmap bitmap = DataManagerHelper.a(bitmapReferenceLruCache, (String)var1_1);
        if (ThumbnailUtils.isBitmapValid(bitmap)) {
            return bitmap.clone();
        }
        int n2 = ThumbnailUtils.DEFAULT_THUMBNAIL_KIND.size();
        bitmap = BitmapUtils.decodeBitmap((String)var1_1, (int)n2, (int)((int)((float)n2 / 0.71f)));
        if (!BitmapUtils.isValid((Bitmap)bitmap)) {
            return null;
        }
        BitmapReferenceLruCache bitmapReferenceLruCache2 = bitmapReferenceLruCache;
        bitmapReferenceLruCache = CloseableReference.of((Object)bitmap, (ResourceReleaser)new ResourceReleaser<Bitmap>(){

            public void a(Bitmap value) {
            }
        });
        DataManagerHelper.a(bitmapReferenceLruCache2, (String)var1_1, (CloseableReference<Bitmap>)bitmapReferenceLruCache);
        return bitmapReferenceLruCache.clone();
    }

    /*
     * WARNING - void declaration
     */
    public static CloseableReference<Bitmap> loadThumbnailBitmapWithCache(Context context, DataProviderBase dataProvider, BitmapReferenceLruCache bitmapLruCache, String associationId) {
        void var1_1;
        Context context2;
        void var3_3;
        void var2_2;
        if (StringUtils.isNullOrEmpty((String)associationId)) {
            return null;
        }
        CloseableReference<Bitmap> closeableReference = DataManagerHelper.a((BitmapReferenceLruCache)var2_2, (String)var3_3);
        if (ThumbnailUtils.isBitmapValid(closeableReference)) {
            return closeableReference.clone();
        }
        if (FileUtils.isImageFile((String)var3_3)) {
            return DataManagerHelper.loadThumbnailBitmapWithCache((BitmapReferenceLruCache)var2_2, (String)var3_3);
        }
        return DataManagerHelper.a(context2, (DataProviderBase)var1_1, (BitmapReferenceLruCache)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static CloseableReference<Bitmap> decodeFileAndCache(File file, BitmapReferenceLruCache bitmapLruCache, String associationId) {
        CloseableReference<Bitmap> closeableReference;
        block4: {
            closeableReference = null;
            closeableReference = ThumbnailUtils.decodeFile(file);
            if (closeableReference == null) break block4;
            if (!closeableReference.isValid()) break block4;
            try {
                void var2_2;
                void var1_1;
                DataManagerHelper.a((BitmapReferenceLruCache)var1_1, (String)var2_2, closeableReference);
                return closeableReference.clone();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return closeableReference;
    }

    /*
     * WARNING - void declaration
     */
    private static CloseableReference<Bitmap> a(Context context, DataProviderBase dataProvider, BitmapReferenceLruCache bitmapLruCache, String associationId) {
        void var3_3;
        String string2;
        CloseableReference<Bitmap> closeableReference = null;
        if (StringUtils.isNotBlank((String)(string2 = DataManagerHelper.getThumbnailPath(context, (DataProviderBase)((Object)string2), (String)var3_3)))) {
            void var2_2;
            closeableReference = DataManagerHelper.decodeFileAndCache(new File(string2), (BitmapReferenceLruCache)var2_2, (String)var3_3);
        }
        return closeableReference;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Library> loadParentLibraryList(Context context, DataManager dataManager, Library library) {
        Object object;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        if (library != null && !StringUtils.isNullOrEmpty((String)((Library)((Object)object)).getParentUniqueId())) {
            void var1_1;
            object = ((Library)((Object)object)).getParentUniqueId();
            while (StringUtils.isNotBlank((String)object) && (object = var1_1.getRemoteContentProvider().loadLibrary((String)object)) != null) {
                arrayList2.add(object);
                object = ((Library)((Object)object)).getParentUniqueId();
            }
            ArrayList arrayList3 = arrayList2;
            Collections.reverse(arrayList3);
            return arrayList3;
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    public static void updateCloudCacheList(List<Metadata> cacheList, QueryResult<Metadata> result, QueryArgs queryArgs) {
        void var1_1;
        if (result != null && !CollectionUtils.isNullOrEmpty(var1_1.list)) {
            List<Metadata> list;
            void var2_2;
            int n2 = var2_2.offset + CollectionUtils.getSize(var1_1.list);
            for (int i2 = (v70845).offset; i2 < n2 && i2 < CollectionUtils.getSize(list); ++i2) {
                list.set(i2, (Metadata)((Object)var1_1.list.get(i2 - var2_2.offset)));
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static QueryResult<Metadata> cloudMetadataFromDataProvider(Context context, DataProviderBase dataProvider, QueryArgs queryArgs) {
        Context context2;
        void var2_3;
        void v0 = var2_3;
        int n2 = v0.limit;
        v0.limit = v0.getCloudFetchLimit();
        var2_3.limit = n2;
        return dataProvider.findMetadataResultByQueryArgs(context2, (QueryArgs)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean cloudMetadataFromCache(QueryResult<Metadata> result, QueryArgs queryArgs, List<Metadata> cacheList) {
        void var1_1;
        void var2_2;
        QueryResult<Metadata> queryResult;
        QueryResult<Metadata> queryResult2 = queryResult;
        queryResult2.count = CollectionUtils.getSize((Collection)var2_2);
        queryResult2.list = new ArrayList();
        boolean bl = true;
        for (int i2 = queryArgs.offset; i2 < var1_1.limit + var1_1.offset && i2 < CollectionUtils.getSize((Collection)var2_2); ++i2) {
            Metadata metadata = (Metadata)((Object)var2_2.get(i2));
            if (metadata == null) {
                bl = false;
                break;
            }
            queryResult.list.add(metadata);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, String> a(Metadata metadata, boolean useThumbnailKind) {
        Object object = metadata.getBookCovers();
        if (CollectionUtils.isNullOrEmpty(object)) {
            void var1_1;
            HashMap hashMap;
            object = hashMap;
            hashMap = new HashMap();
            if (var1_1 != false) {
                OnyxThumbnail.ThumbnailKind[] thumbnailKindArray = OnyxThumbnail.ThumbnailKind.values();
                int n2 = thumbnailKindArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    object.put(thumbnailKindArray[i2].toString().toLowerCase(), null);
                }
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, CloseableReference<Bitmap>> loadCloudThumbnailBitmapsWithCache(Context context, CloudManager cloudManager, List<Metadata> metadataList) {
        HashMap<String, CloseableReference<Bitmap>> hashMap;
        HashMap<String, CloseableReference<Bitmap>> hashMap2 = hashMap;
        hashMap = new HashMap<String, CloseableReference<Bitmap>>();
        for (Metadata metadata : metadataList) {
            Map<String, String> map = DataManagerHelper.a(metadata, true);
            for (String string2 : map.keySet()) {
                void var1_1;
                Context context2;
                string2 = CacheManager.generateCloudThumbnailKey(metadata.getAssociationId(), map.get(string2), string2);
                CloseableReference<Bitmap> closeableReference = DataManagerHelper.loadCloudThumbnailBitmapWithCache(context2, (CloudManager)var1_1, string2);
                if (closeableReference == null) continue;
                hashMap2.put(string2, closeableReference);
            }
        }
        return hashMap2;
    }

    /*
     * WARNING - void declaration
     */
    public static CloseableReference<Bitmap> loadCloudThumbnailBitmapWithCache(Context context, CloudManager cloudManager, String key) {
        void var2_2;
        void var1_1;
        Object object = var1_1.getCacheManager().getBitmapLruCache();
        if (StringUtils.isNullOrEmpty((String)key)) {
            return null;
        }
        if ((object = (CloseableReference)object.get((Object)var2_2)) != null) {
            return object.clone();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static void saveCloudCollection(Context context, DataProviderBase dataProvider, String libraryId, String associationId) {
        void var1_1;
        void var2_2;
        void var3_3;
        CloudMetadataCollection cloudMetadataCollection;
        Object object = cloudMetadataCollection;
        new CloudMetadataCollection().setDocumentUniqueId((String)var3_3);
        object.setLibraryUniqueId((String)var2_2);
        DataManagerHelper.saveCollection(context, (DataProviderBase)var1_1, (MetadataCollection)((Object)object));
    }

    public static void saveCollection(Context context, DataProviderBase dataProvider, MetadataCollection collection) {
        String string2;
        Context context2;
        String string3;
        void v0 = string3;
        String string4 = v0.getLibraryUniqueId();
        if (dataProvider.loadMetadataCollection(context2, string4, v0.getDocumentUniqueId()) == null) {
            if (StringUtils.isNullOrEmpty((String)((MetadataCollection)((Object)string3)).getLibraryUniqueId())) {
                return;
            }
            string2.addMetadataCollection(context2, (MetadataCollection)((Object)string3));
        } else if (StringUtils.isNullOrEmpty((String)((MetadataCollection)((Object)string3)).getLibraryUniqueId())) {
            void v1 = string2;
            void v2 = string3;
            string2 = v2.getLibraryUniqueId();
            string3 = v2.getDocumentUniqueId();
            v1.deleteMetadataCollection(context2, string2, string3);
        } else {
            void v3 = string3;
            v3.setLibraryUniqueId(v3.getLibraryUniqueId());
            string2.updateMetadataCollection((MetadataCollection)v3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void saveCloudMetadataAndCollection(Context context, DataProviderBase dataProvider, QueryArgs queryArgs, QueryResult<Metadata> queryResult) {
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"ContentDatabase").getWritableDatabase();
        databaseWrapper.beginTransaction();
        for (Metadata metadata : queryResult.list) {
            void var2_2;
            Context context2;
            void var1_1;
            Object object = metadata;
            var1_1.saveMetadata(context2, (Metadata)((Object)object));
            object = var2_2.libraryUniqueId;
            DataManagerHelper.saveCloudCollection(context2, (DataProviderBase)var1_1, (String)object, metadata.getAssociationId());
        }
        DatabaseWrapper databaseWrapper2 = databaseWrapper;
        databaseWrapper2.setTransactionSuccessful();
        databaseWrapper2.endTransaction();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveMetadataCollection(Context context, DataProviderBase dataProvider, String libraryId, Collection<Metadata> list) {
        DatabaseWrapper databaseWrapper;
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        void v0 = databaseWrapper;
        databaseWrapper = FlowManager.getDatabase(ContentDatabase.class).getWritableDatabase();
        databaseWrapper.beginTransaction();
        try {
            Iterator iterator = v0.iterator();
            while (true) {
                void var2_2;
                void var1_1;
                Context context2;
                if (!iterator.hasNext()) {
                    DatabaseWrapper databaseWrapper2 = databaseWrapper;
                    databaseWrapper2.setTransactionSuccessful();
                    databaseWrapper2.endTransaction();
                    return;
                }
                DataManagerHelper.saveCollection(context2, (DataProviderBase)var1_1, MetadataCollection.create(((Metadata)((Object)iterator.next())).getIdString(), (String)var2_2));
            }
        }
        catch (Throwable throwable) {
            databaseWrapper.endTransaction();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveMetadata(Context context, DataProviderBase dataProvider, Collection<Metadata> list) {
        DatabaseWrapper databaseWrapper;
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        void v0 = databaseWrapper;
        databaseWrapper = FlowManager.getDatabase(ContentDatabase.class).getWritableDatabase();
        databaseWrapper.beginTransaction();
        try {
            Iterator iterator = v0.iterator();
            while (true) {
                Context context2;
                void var1_1;
                if (!iterator.hasNext()) {
                    DatabaseWrapper databaseWrapper2 = databaseWrapper;
                    databaseWrapper2.setTransactionSuccessful();
                    databaseWrapper2.endTransaction();
                    return;
                }
                var1_1.saveMetadata(context2, (Metadata)((Object)iterator.next()));
            }
        }
        catch (Throwable throwable) {
            databaseWrapper.endTransaction();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<Library> fetchLibraryLibraryList(Context context, DataProviderBase dataProvider, QueryArgs queryArgs) {
        Context context2;
        List<Library> list;
        void var1_1;
        list = var1_1.loadAllLibrary(((QueryArgs)((Object)list)).libraryUniqueId, (QueryArgs)((Object)list));
        if (!FetchPolicy.isDataFromMemDb(queryArgs.fetchPolicy, NetworkUtil.isWiFiConnected((Context)context2))) {
            DataManagerHelper.saveLibraryListToLocal((DataProviderBase)var1_1, list);
        }
        return list;
    }

    public static void saveLibraryListToLocal(DataProviderBase dataProvider, List<Library> libraryList) {
        DatabaseWrapper databaseWrapper;
        if (CollectionUtils.isNullOrEmpty(libraryList)) {
            return;
        }
        void v0 = databaseWrapper;
        databaseWrapper = FlowManager.getDatabase((String)"ContentDatabase").getWritableDatabase();
        databaseWrapper.beginTransaction();
        Iterator iterator = v0.iterator();
        while (iterator.hasNext()) {
            DataProviderBase dataProviderBase;
            dataProviderBase.addLibrary((Library)((Object)iterator.next()));
        }
        DatabaseWrapper databaseWrapper2 = databaseWrapper;
        databaseWrapper2.setTransactionSuccessful();
        databaseWrapper2.endTransaction();
    }

    public static void deleteLibraryWithRecursive(DataProviderBase dataProviderBase, QueryArgs queryArgs, boolean recursive) {
        Iterator iterator;
        DataProviderBase dataProviderBase2;
        ArrayList<Library> arrayList;
        ArrayList<Library> arrayList2 = arrayList;
        arrayList = new ArrayList<Library>();
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"ContentDatabase").getWritableDatabase();
        databaseWrapper.beginTransaction();
        if (recursive) {
            DataManagerHelper.loadLibraryRecursive(dataProviderBase2, arrayList2, (QueryArgs)((Object)iterator));
        } else {
            DataManagerHelper.loadLibraryList(dataProviderBase2, arrayList2, (QueryArgs)((Object)iterator));
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            dataProviderBase2.deleteLibrary((Library)((Object)iterator.next()));
        }
        DatabaseWrapper databaseWrapper2 = databaseWrapper;
        databaseWrapper2.setTransactionSuccessful();
        databaseWrapper2.endTransaction();
    }

    public static void clearLibrary(DataProviderBase dataProvider) {
        dataProvider.clearLibrary();
    }

    /*
     * WARNING - void declaration
     */
    public static OperatorGroup getPropertyOrCondition(List<String> valueList, Property<String> property) {
        OperatorGroup operatorGroup;
        if (CollectionUtils.isNullOrEmpty(valueList)) {
            return null;
        }
        OperatorGroup operatorGroup2 = operatorGroup;
        operatorGroup = OperatorGroup.clause();
        Iterator iterator = operatorGroup2.iterator();
        while (iterator.hasNext()) {
            void var1_1;
            operatorGroup.or((SQLOperator)var1_1.eq((Object)((String)iterator.next())));
        }
        return operatorGroup;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void insertMetadataList(Context context, DataProviderBase dataProvider, Collection<Metadata> list) {
        DatabaseWrapper databaseWrapper;
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        void v0 = databaseWrapper;
        databaseWrapper = FlowManager.getDatabase(ContentDatabase.class).getWritableDatabase();
        databaseWrapper.beginTransaction();
        try {
            Iterator iterator = v0.iterator();
            while (true) {
                void var1_1;
                Context context2;
                if (!iterator.hasNext()) {
                    DatabaseWrapper databaseWrapper2 = databaseWrapper;
                    databaseWrapper2.setTransactionSuccessful();
                    databaseWrapper2.endTransaction();
                    return;
                }
                DataManagerHelper.insertMetadata(context2, (DataProviderBase)var1_1, (Metadata)((Object)iterator.next()));
            }
        }
        catch (Throwable throwable) {
            databaseWrapper.endTransaction();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void insertMetadata(Context context, DataProviderBase dataProvider, Metadata metadata) {
        void var2_2;
        Context context2;
        void var1_1;
        if (metadata == null) {
            return;
        }
        var1_1.insertMetadata(context2, (Metadata)var2_2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateMetadataList(Context context, DataProviderBase dataProvider, Collection<Metadata> list) {
        DatabaseWrapper databaseWrapper;
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        void v0 = databaseWrapper;
        databaseWrapper = FlowManager.getDatabase(ContentDatabase.class).getWritableDatabase();
        databaseWrapper.beginTransaction();
        try {
            Iterator iterator = v0.iterator();
            while (true) {
                void var1_1;
                Context context2;
                if (!iterator.hasNext()) {
                    DatabaseWrapper databaseWrapper2 = databaseWrapper;
                    databaseWrapper2.setTransactionSuccessful();
                    databaseWrapper2.endTransaction();
                    return;
                }
                DataManagerHelper.updateMetadata(context2, (DataProviderBase)var1_1, (Metadata)((Object)iterator.next()));
            }
        }
        catch (Throwable throwable) {
            databaseWrapper.endTransaction();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void updateMetadata(Context context, DataProviderBase dataProvider, Metadata metadata) {
        void var2_2;
        Context context2;
        void var1_1;
        if (metadata == null) {
            return;
        }
        var1_1.updateMetadata(context2, (Metadata)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void updateMetadata(Context context, DataProviderBase dataProvider, ContentValues values, String where, String[] selectionArgs) {
        void var2_2;
        if (values != null && var2_2.size() > 0) {
            void var4_4;
            void var3_3;
            Context context2;
            void var1_1;
            var1_1.updateMetadata(context2, (ContentValues)var2_2, (String)var3_3, (String[])var4_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Metadata getMetadataByPath(Context context, DataProviderBase dataProvider, String path) {
        void var1_1;
        if (!StringUtils.isNullOrEmpty((String)path) && var1_1 != null) {
            void var2_2;
            Context context2;
            return var1_1.findMetadataByPath(context2, (String)var2_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static void deleteThumbnailEntry(DataManager dataManager, DataProviderBase dataProvider, Thumbnail thumbnail) {
        void var1_1;
        DataManager dataManager2;
        void var2_2;
        if (!BaseData.isValid(thumbnail)) {
            return;
        }
        org.apache.commons.io.FileUtils.deleteQuietly((File)new File(StringUtils.safelyGetStr((String)var2_2.getImageDataPath())));
        dataManager2.getCacheManager().removeBitmapRefCache(var2_2.getIdString());
        var1_1.deleteThumbnailEntry((Thumbnail)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void deleteLibrariesThumbnailEntry(Context context, DataManager dataManager, DataProviderBase dataProvider, Collection<String> libraryIdSet) {
        Iterator<String> iterator = libraryIdSet.iterator();
        while (iterator.hasNext()) {
            Context context2;
            void var2_2;
            void var1_1;
            DataManagerHelper.deleteThumbnailEntry((DataManager)var1_1, (DataProviderBase)var2_2, ThumbnailUtils.getDefaultKindThumbnailEntry(context2, (DataProviderBase)var2_2, iterator.next()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void a(BitmapReferenceLruCache cache, String associationId, CloseableReference<Bitmap> bitmapRef) {
        void var2_2;
        void var1_1;
        cache.put(DataManagerHelper.a((String)var1_1), var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static CloseableReference<Bitmap> a(BitmapReferenceLruCache cache, String associationId) {
        BitmapReferenceLruCache bitmapReferenceLruCache;
        void var1_1;
        String string2 = DataManagerHelper.a((String)var1_1);
        return cache.get(string2) == null ? (CloseableReference)bitmapReferenceLruCache.get(var1_1) : (CloseableReference)bitmapReferenceLruCache.get(string2);
    }

    private static String a(String associationId) {
        String string2;
        File file;
        File file2 = file;
        if (new File(string2).exists()) {
            string2 = string2 + "-" + file2.lastModified();
        }
        return string2;
    }
}

