/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.v1;

import com.onyx.android.sdk.data.model.Captcha;
import com.onyx.android.sdk.data.model.Device;
import com.onyx.android.sdk.data.model.EmailLoginBody;
import com.onyx.android.sdk.data.model.OAuthAccountData;
import com.onyx.android.sdk.data.model.OnyxAccount;
import com.onyx.android.sdk.data.model.WeChatOauthResp;
import com.onyx.android.sdk.data.model.WeChatUserInfo;
import java.util.List;
import java.util.Map;
import okhttp3.MultipartBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface OnyxAccountService {
    @GET(value="oauth/token")
    public Call<OnyxAccount> getOAuthAccount(@Query(value="code") String var1);

    @POST(value="auth/local")
    public Call<OnyxAccount> loginWithEmail(@Body EmailLoginBody var1);

    @GET(value="users/me")
    public Call<OnyxAccount> userInfo(@Header(value="X-ONYX-SESSION-TOKEN") String var1);

    @POST(value="account/signup")
    public Call<OnyxAccount> signup(@Body OnyxAccount var1);

    @PUT(value="account/signin")
    public Call<OnyxAccount> signin(@Body OnyxAccount var1);

    @PUT(value="account/signout")
    public Call<OnyxAccount> signout(@Header(value="X-ONYX-SESSION-TOKEN") String var1);

    @GET(value="account")
    public Call<OnyxAccount> getAccountInfo(@Header(value="X-ONYX-SESSION-TOKEN") String var1);

    @PUT(value="account")
    public Call<OnyxAccount> updateAccountInfo(@Body OnyxAccount var1, @Header(value="X-ONYX-SESSION-TOKEN") String var2);

    @POST(value="account/activation")
    public Call applyActivateAccount(@Header(value="X-ONYX-SESSION-TOKEN") String var1);

    @GET(value="account/activation")
    public Call postActivateAccount(@Query(value="token") String var1);

    @POST(value="account/password/forgot")
    public Call forgotAccountPwd(@Body OnyxAccount var1);

    @PUT(value="account/password/reset")
    public Call resetAccountPwd(@Body Map<String, String> var1);

    @POST(value="account/device")
    public Call<Device> addDevice(@Body Device var1, @Header(value="X-ONYX-SESSION-TOKEN") String var2);

    @GET(value="account/device")
    public Call<List<Device>> getBoundDeviceList(@Header(value="X-ONYX-SESSION-TOKEN") String var1);

    @GET(value="account/device/{deviceId}")
    public Call<Device> getBoundDevice(@Path(value="deviceId") String var1, @Header(value="X-ONYX-SESSION-TOKEN") String var2);

    @DELETE(value="account/device/{deviceId}")
    public Call<ResponseBody> removeBoundDevice(@Path(value="deviceId") String var1, @Header(value="X-ONYX-SESSION-TOKEN") String var2);

    @POST(value="captcha")
    public Call<Captcha> generateCaptcha();

    @Multipart
    @POST(value="account/avatar")
    public Call<OnyxAccount> uploadAvatar(@Part MultipartBody.Part var1, @Header(value="X-ONYX-SESSION-TOKEN") String var2);

    @GET(value="https://api.weixin.qq.com/sns/oauth2/access_token")
    public Call<WeChatOauthResp> requestWeChatToken(@Query(value="appid") String var1, @Query(value="secret") String var2, @Query(value="code") String var3, @Query(value="grant_type") String var4);

    @GET(value="https://api.weixin.qq.com/sns/userinfo")
    public Call<WeChatUserInfo> requestWeChatUserInfo(@Query(value="access_token") String var1, @Query(value="openid") String var2);

    @POST(value="oauth/sso/{type}")
    public Call<ResponseBody> requestOnyxOauthCode(@Path(value="type") String var1, @Body OAuthAccountData var2);
}

