/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.onyx.android.sdk.data.model.Book;
import com.onyx.android.sdk.data.model.OnyxStatisticsModel;
import com.onyx.android.sdk.data.model.OnyxStatisticsModel_Table;
import com.onyx.android.sdk.data.utils.StatisticsUtils;
import com.onyx.android.sdk.utils.DateTimeUtil;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.Method;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ReaderStatistiscUtils {
    private static final String a = "ReaderStatistiscUtils";

    public static long getLocalDayReadSeconds(String accountID) {
        Iterator iterator;
        long l2 = 0L;
        iterator = ((List)StatisticsUtils.loadStatisticsList(DateTimeUtil.getDayBegin(), DateTimeUtil.getDayEnd(), 1, (String)((Object)iterator))).iterator();
        while (iterator.hasNext()) {
            l2 += ((OnyxStatisticsModel)iterator.next()).getDurationTime().longValue();
        }
        return l2;
    }

    public static long getLocalTotalReadSeconds(String accountID) {
        Iterator iterator;
        long l2 = 0L;
        iterator = ((List)StatisticsUtils.loadStatisticsList(1, (String)((Object)iterator))).iterator();
        while (iterator.hasNext()) {
            l2 += ((OnyxStatisticsModel)iterator.next()).getDurationTime().longValue();
        }
        return l2;
    }

    public static int getLocalReadCount(String accountID) {
        Iterator iterator;
        HashSet<String> hashSet;
        HashSet<String> hashSet2 = hashSet;
        hashSet = new HashSet<String>();
        iterator = ((List)StatisticsUtils.loadStatisticsList(0, (String)((Object)iterator))).iterator();
        while (iterator.hasNext()) {
            hashSet2.add(((OnyxStatisticsModel)iterator.next()).getMd5());
        }
        return hashSet2.size();
    }

    public static int getLocalFinishCount(String accountID) {
        Iterator iterator;
        HashSet<String> hashSet;
        HashSet<String> hashSet2 = hashSet;
        hashSet = new HashSet<String>();
        iterator = ((List)StatisticsUtils.loadStatisticsList(6, (String)((Object)iterator))).iterator();
        while (iterator.hasNext()) {
            hashSet2.add(((OnyxStatisticsModel)iterator.next()).getMd5());
        }
        return hashSet2.size();
    }

    public static int getLocalLookupDicCount() {
        return ((List)StatisticsUtils.loadStatisticsList(3)).size();
    }

    public static long getLocalAnnotationCount(String accountID) {
        return StatisticsUtils.getAnnotationCount(accountID);
    }

    public static int getLocalSelectTextCount() {
        return ((List)StatisticsUtils.loadStatisticsList(4)).size();
    }

    public static List<Integer> getLocalSelfReadTimeDis() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        return StatisticsUtils.getEventHourlyAgg((List)StatisticsUtils.loadStatisticsList(calendar.getTime()), 24);
    }

    public static long getLocalReadTimeEveryDay() {
        HashSet<String> hashSet;
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        Date date = calendar.getTime();
        HashSet<String> hashSet2 = hashSet;
        hashSet = new HashSet<String>();
        long l2 = 0L;
        List list = (List)StatisticsUtils.loadStatisticsList(date, 1);
        for (OnyxStatisticsModel onyxStatisticsModel : list) {
            hashSet2.add(DateTimeUtil.formatDate((Date)onyxStatisticsModel.getEventTime(), (SimpleDateFormat)DateTimeUtil.DATE_FORMAT_YYYYMMDD));
            l2 += onyxStatisticsModel.getDurationTime().longValue();
        }
        if (hashSet2.size() == 0) {
            return 0L;
        }
        long l3 = l2 / (long)hashSet2.size();
        if (l3 > 36000000L) {
            Log.d((String)a, (String)("statisticsModels:" + JSON.toJSONString((Object)list)));
            Log.d((String)a, (String)("days: " + JSON.toJSONString(hashSet2) + "-------readTimes: " + l2 + "------date: " + date));
        }
        return l3;
    }

    public static Book getLocalLongestBook() {
        Book book = StatisticsUtils.getLongestBook((List)StatisticsUtils.loadStatisticsList(1));
        if (book == null) {
            return null;
        }
        Object object = book.getMd5();
        List list = (List)StatisticsUtils.loadStatisticsListOrderByTime((String)object, 0, true);
        if (list != null && list.size() > 0) {
            book.setBegin(((OnyxStatisticsModel)list.get(0)).getEventTime());
        }
        if ((list = (List)StatisticsUtils.loadStatisticsListOrderByTime((String)object, true)) != null && list.size() > 0) {
            List list2 = list;
            book.setEnd(((OnyxStatisticsModel)list2.get(list2.size() - 1)).getEventTime());
        }
        if ((object = (List)StatisticsUtils.loadStatisticsListByMd5((String)object)).size() > 0) {
            book.setName(((OnyxStatisticsModel)object.get(0)).getName());
        }
        return book;
    }

    public static Book getLocalMostCarefullyBook() {
        List list = (List)StatisticsUtils.loadStatisticsList(3);
        list.addAll(StatisticsUtils.loadStatisticsList(2));
        list.addAll(StatisticsUtils.loadStatisticsList(4));
        Book book = StatisticsUtils.getMostCarefullyBook(list);
        if (book == null) {
            return null;
        }
        Book book2 = book;
        Object object = book2.getMd5();
        book.setLookupDic(((List)StatisticsUtils.loadStatisticsList((String)object, 3)).size());
        book.setAnnotation(((List)StatisticsUtils.loadStatisticsList((String)object, 2)).size());
        book2.setTextSelect(((List)StatisticsUtils.loadStatisticsList((String)object, 4)).size());
        object = (List)StatisticsUtils.loadStatisticsListByMd5((String)object);
        if (object.size() > 0) {
            book.setName(((OnyxStatisticsModel)object.get(0)).getName());
        }
        return book;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Book> getLocalRecentFinshBooks(String accountID, int recentFinishCount) {
        void var1_1;
        List<Book> list;
        list = StatisticsUtils.converToBooks((List)StatisticsUtils.loadVisibleStatisticsListOrderByTime(6, false, (String)((Object)list)), (int)var1_1);
        Iterator<Book> iterator = list.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            boolean bl2;
            Book book = iterator.next();
            Object object = book.getMd5();
            Object object2 = (List)StatisticsUtils.loadStatisticsListByMd5((String)object);
            if (object2.size() > 0) {
                book.setName(((OnyxStatisticsModel)object2.get(0)).getName());
            }
            object2 = null;
            Date date = null;
            List list2 = (List)StatisticsUtils.loadStatisticsListOrderByTime((String)object, 0, false);
            if (list2 != null && list2.size() > 0) {
                object2 = ((OnyxStatisticsModel)list2.get(0)).getEventTime();
                book.setBegin((Date)object2);
            }
            if ((list2 = (List)StatisticsUtils.loadStatisticsListOrderByTime((String)object, false)) != null && list2.size() > 0) {
                date = ((OnyxStatisticsModel)list2.get(0)).getEventTime();
                book.setEnd(date);
            }
            long l2 = 0L;
            if (object2 != null) {
                object = ((List)StatisticsUtils.loadStatisticsList((String)object, 1, (Date)object2)).iterator();
                while (object.hasNext()) {
                    l2 += ((OnyxStatisticsModel)object.next()).getDurationTime().longValue();
                }
            }
            if (l2 <= 0L && (bl2 = object2 != null) & (bl = date != null)) {
                l2 = date.getTime() - ((Date)object2).getTime();
            }
            book.setReadingTime(Math.max(l2, 0L));
        }
        return list;
    }

    public static List<Integer> getLocalReadDistribute(String accountIdStr) {
        String string2;
        return StatisticsUtils.getReadDistribute(StatisticsUtils.loadStatisticsList(1, string2));
    }

    public static long getLocalUnPushCount() {
        return new Select(new IProperty[]{Method.count((IProperty[])new IProperty[0])}).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OperatorGroup.clause().and((SQLOperator)OnyxStatisticsModel_Table.status.eq((Object)0))}).count();
    }

    public static void hideLocalRecentFinishBooks(List<String> md5List) {
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"OnyxStatisticsModel").getWritableDatabase();
        databaseWrapper.beginTransaction();
        for (String string2 : md5List) {
            List list = new Select(new IProperty[0]).from(OnyxStatisticsModel.class).where(new SQLOperator[]{OnyxStatisticsModel_Table.md5.eq((Object)string2)}).queryList();
            if (list.isEmpty()) continue;
            for (OnyxStatisticsModel onyxStatisticsModel : list) {
                onyxStatisticsModel.setHideRecord(true);
                onyxStatisticsModel.update();
            }
        }
        DatabaseWrapper databaseWrapper2 = databaseWrapper;
        databaseWrapper2.setTransactionSuccessful();
        databaseWrapper2.endTransaction();
    }
}

