/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.model;

import android.content.Context;
import com.alibaba.fastjson.JSON;
import com.onyx.android.sdk.data.model.BaseData;
import com.onyx.android.sdk.data.model.SecurePreferences;
import com.onyx.android.sdk.utils.StringUtils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class OnyxAccount
extends BaseData {
    private static final String CLOUD_TYPE = "onyxCloud";
    private static final String ACCOUNT_INFO_TAG = "accountInfo";
    private static final String JSON_TAG = "json";
    private static AccountInfo accountInfo = new AccountInfo();
    public String nickName;
    public String firstName;
    public String lastName;
    public String fullName;
    public String password;
    public String email;
    public String mobile;
    public String sessionToken;
    public String captchaId;
    public String captchaValue;
    public boolean isInstallationId = false;
    public String deviceClient = "boox";
    public String type;
    public String avatarUrl;
    public int status;

    public OnyxAccount() {
    }

    /*
     * WARNING - void declaration
     */
    public OnyxAccount(String fullName, String password, String email) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.fullName = var1_1;
        this.password = var2_2;
        this.email = var3_3;
    }

    public static OnyxAccount getCurrentAccount() {
        return accountInfo.getCurrentAccount();
    }

    public static OnyxAccount defaultAccount() {
        return new OnyxAccount("john2", "123456", "john2@onyx-international.com");
    }

    public static void generateDefaultAccount(Context context) {
        Context context2 = context;
        OnyxAccount.clear(context2);
        OnyxAccount.saveAccount(context2, OnyxAccount.defaultAccount());
    }

    public static AccountInfo getAccountInfo() {
        return accountInfo;
    }

    /*
     * WARNING - void declaration
     */
    private static void saveToSecurePreferences(Context context, AccountInfo accountInfo) {
        void var1_1;
        Context context2;
        new SecurePreferences(context2, CLOUD_TYPE, ACCOUNT_INFO_TAG, true).put(JSON_TAG, JSON.toJSONString((Object)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static void saveAccount(Context context, OnyxAccount onyxAccount) {
        void var1_1;
        accountInfo.addAccount((OnyxAccount)var1_1);
        OnyxAccount.saveToSecurePreferences(context, accountInfo);
    }

    /*
     * WARNING - void declaration
     */
    public static void saveAccount(Context context, String saveKey, OnyxAccount onyxAccount) {
        void var2_2;
        void var1_1;
        accountInfo.addAccount((String)var1_1, (OnyxAccount)var2_2);
        OnyxAccount.saveToSecurePreferences(context, accountInfo);
    }

    /*
     * WARNING - void declaration
     */
    public static void deleteAccount(Context context, String key) {
        void var1_1;
        accountInfo.removeAccount((String)var1_1);
        OnyxAccount.saveToSecurePreferences(context, accountInfo);
    }

    public static OnyxAccount loadAccount(Context context) {
        Object object;
        if (StringUtils.isNullOrEmpty((String)(object = new SecurePreferences((Context)object, CLOUD_TYPE, ACCOUNT_INFO_TAG, true).getString(JSON_TAG)))) {
            accountInfo = new AccountInfo();
            return null;
        }
        accountInfo = (AccountInfo)JSON.parseObject((String)object, AccountInfo.class);
        return accountInfo.getCurrentAccount();
    }

    public static String loadAccountSessionToken(Context context) {
        Object object;
        if (accountInfo.getCurrentAccount() != null) {
            return OnyxAccount.accountInfo.getCurrentAccount().sessionToken;
        }
        return (object = OnyxAccount.loadAccount(object)) == null ? null : object.sessionToken;
    }

    public static void clear(Context context) {
        Context context2;
        new SecurePreferences(context2, CLOUD_TYPE, ACCOUNT_INFO_TAG, true).clear();
        accountInfo.clear();
    }

    public static class AccountInfo {
        public LinkedHashMap<String, OnyxAccount> accountMap;
        public OnyxAccount currentAccount;

        public AccountInfo() {
            LinkedHashMap linkedHashMap;
            LinkedHashMap this_ = linkedHashMap;
            linkedHashMap = new LinkedHashMap(16, 0.75f, true);
            v1.accountMap = this_;
        }

        public OnyxAccount getCurrentAccount() {
            if (this.currentAccount == null && this.accountMap.size() > 0) {
                Iterator<Map.Entry<String, OnyxAccount>> iterator = this.accountMap.entrySet().iterator();
                for (int i2 = 0; i2 < this.accountMap.size() - 1; ++i2) {
                    iterator.next();
                }
                this.currentAccount = iterator.next().getValue();
            }
            return this.currentAccount;
        }

        /*
         * WARNING - void declaration
         */
        public void addAccount(OnyxAccount account) {
            void var1_1;
            this.accountMap.put(var1_1.sessionToken, (OnyxAccount)var1_1);
            this.currentAccount = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void addAccount(String saveKey, OnyxAccount account) {
            void var2_2;
            void var1_1;
            this.accountMap.put((String)var1_1, (OnyxAccount)var2_2);
            this.currentAccount = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public void removeAccount(String saveKey) {
            void var1_1;
            this.accountMap.remove(var1_1);
            this.currentAccount = null;
        }

        public void clear() {
            this.accountMap.clear();
            this.currentAccount = null;
        }
    }
}

