/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.model;

import android.databinding.BaseObservable;
import android.databinding.ObservableBoolean;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.text.Html;
import android.text.Spanned;
import com.facebook.common.references.CloseableReference;
import com.onyx.android.sdk.data.model.ExtensionMap;
import com.onyx.android.sdk.dataprovider.R;
import com.onyx.android.sdk.utils.DateTimeUtil;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.LocaleUtils;
import com.onyx.android.sdk.utils.MimeTypeUtils;
import com.onyx.android.sdk.utils.ResManager;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.File;
import java.util.Date;

public class FileModel
extends BaseObservable {
    public static final int TYPE_DIRECTORY = 0;
    public static final int TYPE_FILE = 1;
    public static final int TYPE_GO_UP = 2;
    public static final int TYPE_SHORTCUT = 3;
    public static final int TYPE_NON_READER_FILE = 4;
    public static final int TYPE_UNKNOWN = 5;
    private File file;
    private String name;
    private String shortcutPath;
    private int type;
    private Drawable thumbnail;
    private int thumbnailResId;
    private CloseableReference<Bitmap> coverBitmap;
    private boolean canPadding = false;
    private boolean isFromLibrary = false;
    private ObservableBoolean encrypted;
    private int childFolderCount;
    private int childFileCount;
    private int selectChildCount;

    public FileModel() {
        ObservableBoolean observableBoolean;
        FileModel this_ = observableBoolean;
        observableBoolean = new ObservableBoolean(false);
        v1.encrypted = this_;
    }

    /*
     * WARNING - void declaration
     */
    public static FileModel create(File file, Drawable thumbnail) {
        void var1_1;
        File file2;
        FileModel fileModel = new FileModel();
        fileModel.file = file2;
        fileModel.thumbnail = var1_1;
        fileModel.initFileType();
        return fileModel;
    }

    private void initFileType() {
        int n2 = this.file.isDirectory() ? 0 : 5;
        this.type = n2;
        String string2 = FileUtils.getFileExtension((String)this.file.getName());
        if (MimeTypeUtils.readerSupportFormatExtension.contains(string2)) {
            this.type = 1;
        } else if (MimeTypeUtils.nonReaderSupportFormatExtension.contains(string2)) {
            this.type = 4;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static FileModel createGoUpModel(File file, String name) {
        void var1_1;
        File file2;
        new FileModel().file = file2;
        new FileModel().type = 2;
        new FileModel().name = var1_1;
        return new FileModel();
    }

    public static FileModel createShortcutModel(File file) {
        FileModel.create(file, null).type = 3;
        return FileModel.create(file, null);
    }

    private void resetToFileType() {
        this.type = 1;
    }

    private String getFileName() {
        File this_ = ((FileModel)((Object)this_)).file;
        if (this_ == null) {
            return null;
        }
        return this_.getName();
    }

    private String getFileExtension() {
        if (this.isDirectoryType()) {
            return ResManager.getString((int)R.string.folder);
        }
        if (this.isShortcutType()) {
            return ResManager.getString((int)R.string.short_cut);
        }
        return FileUtils.getFileExtension((String)this.getName());
    }

    public String getFileLastModifiedTime() {
        return DateTimeUtil.DATE_FORMAT_YYYYMMDD_HHMMSS.format(new Date(this.file.lastModified()));
    }

    public String getShortcutPath() {
        return this.shortcutPath;
    }

    /*
     * WARNING - void declaration
     */
    public void setShortcutPath(String shortcutPath) {
        void var1_1;
        this.shortcutPath = var1_1;
    }

    public File getFile() {
        if (this.isShortcutType()) {
            return new File(this.shortcutPath);
        }
        return this.file;
    }

    public File getFileByType() {
        FileModel fileModel = this;
        File file = fileModel.getFile();
        if (fileModel.isGoUpType()) {
            file = this.getFile().getParentFile();
        } else if (this.isShortcutType()) {
            File file2;
            file = file2;
            file2 = new File(this.getShortcutPath());
        }
        return file;
    }

    /*
     * WARNING - void declaration
     */
    public void setFile(File file) {
        void var1_1;
        this.file = var1_1;
    }

    public Drawable getThumbnail() {
        return this.thumbnail;
    }

    /*
     * WARNING - void declaration
     */
    public void setThumbnail(Drawable thumbnail) {
        void var1_1;
        this.thumbnail = var1_1;
    }

    public int getType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    public void setType(int type) {
        void var1_1;
        this.type = var1_1;
    }

    public int getChildFolderCount() {
        return this.childFolderCount;
    }

    /*
     * WARNING - void declaration
     */
    public void setChildFolderCount(int childFolderCount) {
        void var1_1;
        this.childFolderCount = var1_1;
    }

    public int getChildFileCount() {
        return this.childFileCount;
    }

    /*
     * WARNING - void declaration
     */
    public void setChildFileCount(int childFileCount) {
        void var1_1;
        this.childFileCount = var1_1;
    }

    public int getSelectChildCount() {
        return this.selectChildCount;
    }

    /*
     * WARNING - void declaration
     */
    public void setSelectChildCount(int selectChildCount) {
        void var1_1;
        this.selectChildCount = var1_1;
    }

    public void showExtensionOnCover() {
        this.resetToFileType();
    }

    public Spanned getDisplayName() {
        StringBuilder stringBuilder = new StringBuilder().append(((FileModel)((Object)this_)).getName());
        String this_ = StringUtils.isNotBlank((String)((FileModel)((Object)this_)).getAliasName()) && LocaleUtils.isChinese() ? ResManager.getString((int)R.string.file_alias_format, (Object[])new Object[]{((FileModel)((Object)this_)).getAliasName()}) : "";
        return Html.fromHtml((String)stringBuilder.append(this_).toString());
    }

    public String getName() {
        String string2 = this.name;
        if (string2 == null) {
            return this.getFileName();
        }
        return string2;
    }

    public String getAliasName() {
        return ExtensionMap.getDefaultDirectoryAliasName(this.getFile());
    }

    public String getExtension() {
        return ExtensionMap.getExtension(this.getFileExtension().toUpperCase());
    }

    public String lastModified() {
        if (this.file != null && !this.isShortcutType()) {
            long l2 = this.file.lastModified();
            if (l2 == 0L) {
                FileModel fileModel = this;
                fileModel.file.setLastModified(System.currentTimeMillis());
                l2 = fileModel.file.lastModified();
            }
            return DateTimeUtil.DATE_FORMAT_YYYYMMDD_HHMM.format(l2);
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public void setName(String name) {
        void var1_1;
        this.name = var1_1;
    }

    public boolean isGoUpType() {
        return this.getType() == 2;
    }

    public boolean isFileType() {
        return this.getType() == 1;
    }

    public boolean isDirectoryType() {
        return this.getType() == 0;
    }

    public boolean isShortcutType() {
        return this.getType() == 3;
    }

    public boolean isNonReaderFileType() {
        return this.getType() == 4;
    }

    public boolean isUnknownType() {
        return this.getType() == 5;
    }

    public int getThumbnailResId() {
        return this.thumbnailResId;
    }

    /*
     * WARNING - void declaration
     */
    public void setThumbnailResId(int thumbnailResId) {
        void var1_1;
        this.thumbnailResId = var1_1;
    }

    public Bitmap getCoverBitmap() {
        return this.isCoverBitmapValid() ? (Bitmap)this.coverBitmap.get() : null;
    }

    public CloseableReference<Bitmap> getRefCoverBitmap() {
        return this.coverBitmap;
    }

    /*
     * WARNING - void declaration
     */
    public void setRefCoverBitmap(CloseableReference<Bitmap> bitmap) {
        void var1_1;
        this.coverBitmap = var1_1;
        this.notifyChange();
    }

    public boolean isCoverBitmapValid() {
        CloseableReference<Bitmap> closeableReference = this.coverBitmap;
        return closeableReference != null && closeableReference.isValid() && this.coverBitmap.get() != null;
    }

    public boolean isCanPadding() {
        return this.canPadding;
    }

    /*
     * WARNING - void declaration
     */
    public void setCanPadding(boolean canPadding) {
        void var1_1;
        this.canPadding = var1_1;
    }

    public boolean isFromLibrary() {
        return this.isFromLibrary;
    }

    /*
     * WARNING - void declaration
     */
    public void setFromLibrary(boolean fromLibrary) {
        void var1_1;
        this.isFromLibrary = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setEncrypted(boolean encrypted) {
        void var1_1;
        this.encrypted.set((boolean)var1_1);
    }

    public ObservableBoolean isEncrypted() {
        return this.encrypted;
    }

    public String getCountFormat() {
        return String.format(ResManager.getString((int)R.string.title_with_count), this.getChildFolderCount(), this.getChildFileCount());
    }

    public long getFileSize() {
        int n2 = ((FileModel)((Object)this_)).getType();
        if (n2 != 1 && n2 != 4 && n2 != 5) {
            return 0L;
        }
        File this_ = ((FileModel)((Object)this_)).file;
        return this_ == null ? 0L : this_.length();
    }
}

