/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.v1;

import android.support.annotation.NonNull;
import com.onyx.android.sdk.data.v1.FastJsonConverterFactory;
import com.onyx.android.sdk.data.v1.OnyxAccountService;
import com.onyx.android.sdk.data.v1.OnyxBackupService;
import com.onyx.android.sdk.data.v1.OnyxBookStoreService;
import com.onyx.android.sdk.data.v1.OnyxConsumerService;
import com.onyx.android.sdk.data.v1.OnyxDictionaryService;
import com.onyx.android.sdk.data.v1.OnyxFileDownloadService;
import com.onyx.android.sdk.data.v1.OnyxGroupService;
import com.onyx.android.sdk.data.v1.OnyxHWRResourceService;
import com.onyx.android.sdk.data.v1.OnyxHardwareService;
import com.onyx.android.sdk.data.v1.OnyxHomeworkService;
import com.onyx.android.sdk.data.v1.OnyxLogService;
import com.onyx.android.sdk.data.v1.OnyxOTAService;
import com.onyx.android.sdk.data.v1.OnyxPushService;
import com.onyx.android.sdk.data.v1.OnyxShareService;
import com.onyx.android.sdk.data.v1.OnyxStatisticsService;
import com.onyx.android.sdk.data.v1.OnyxSyncService;
import com.onyx.android.sdk.data.v1.OnyxTemplateService;
import com.onyx.android.sdk.data.v2.ContentService;
import com.onyx.android.sdk.data.v2.TokenHeaderInterceptor;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.Debug;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class ServiceFactory {
    private static ConcurrentHashMap<String, Retrofit> a = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, OkHttpClient> b = new ConcurrentHashMap();

    private static Retrofit a(String string2) {
        if (!a.containsKey(string2)) {
            Retrofit retrofit = ServiceFactory.getBaseRetrofitBuilder(string2).build();
            a.put(string2, retrofit);
        }
        return a.get(string2);
    }

    public static Retrofit.Builder getBaseRetrofitBuilder(String baseUrl) {
        return new Retrofit.Builder().baseUrl(baseUrl).client(ServiceFactory.getBaseOkClientBuilder(baseUrl)).addConverterFactory((Converter.Factory)FastJsonConverterFactory.create());
    }

    public static OkHttpClient getBaseOkClientBuilder(String baseUrl) {
        if (b.containsKey(baseUrl)) {
            return b.get(baseUrl);
        }
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder();
        if (Debug.getDebug()) {
            builder.addInterceptor((Interceptor)new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY));
        }
        OkHttpClient okHttpClient = builder.build();
        b.put(baseUrl, okHttpClient);
        return okHttpClient;
    }

    public static final OnyxAccountService getAccountService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxAccountService.class, baseUrl);
    }

    public static final OnyxBookStoreService getBookStoreService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxBookStoreService.class, baseUrl);
    }

    public static final OnyxDictionaryService getDictionaryService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxDictionaryService.class, baseUrl);
    }

    public static final OnyxHardwareService getHardwareService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxHardwareService.class, baseUrl);
    }

    public static final OnyxOTAService getOTAService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxOTAService.class, baseUrl);
    }

    public static final OnyxFileDownloadService getFileDownloadService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxFileDownloadService.class, baseUrl);
    }

    public static final OnyxConsumerService getConsumerService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxConsumerService.class, baseUrl);
    }

    public static final OnyxGroupService getGroupService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxGroupService.class, baseUrl);
    }

    public static final OnyxPushService getPushService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxPushService.class, baseUrl);
    }

    public static final OnyxStatisticsService getStatisticsService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxStatisticsService.class, baseUrl);
    }

    public static final OnyxLogService getLogService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxLogService.class, baseUrl);
    }

    public static final ContentService getContentService(String baseUrl) {
        return ServiceFactory.getSpecifyService(ContentService.class, baseUrl);
    }

    public static final OnyxSyncService getSyncService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxSyncService.class, baseUrl);
    }

    public static final OnyxBackupService getBackupService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxBackupService.class, baseUrl);
    }

    public static final OnyxShareService getShareService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxShareService.class, baseUrl);
    }

    public static final OnyxTemplateService getTemplateService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxTemplateService.class, baseUrl);
    }

    public static final OnyxHomeworkService getHomeworkService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxHomeworkService.class, baseUrl);
    }

    public static final OnyxHWRResourceService getHWRResourceService(String baseUrl) {
        return ServiceFactory.getSpecifyService(OnyxHWRResourceService.class, baseUrl);
    }

    public static final <T> T getSpecifyService(Class<T> service, String baseUrl) {
        return (T)ServiceFactory.a(baseUrl).create(service);
    }

    private static void a(OkHttpClient.Builder builder, List<Interceptor> list) {
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        for (Interceptor interceptor : list) {
            builder.addInterceptor(interceptor);
        }
    }

    private static void b(OkHttpClient.Builder builder, List<Interceptor> list) {
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        for (Interceptor interceptor : list) {
            builder.addNetworkInterceptor(interceptor);
        }
    }

    private static void a(OkHttpClient.Builder builder, Class[] classArray) {
        if (!CollectionUtils.isNullOrEmpty((Collection)builder.interceptors())) {
            Iterator iterator = builder.interceptors().iterator();
            block0: while (iterator.hasNext()) {
                Interceptor interceptor = (Interceptor)iterator.next();
                for (Class clazz : classArray) {
                    if (!clazz.isInstance(interceptor)) continue;
                    iterator.remove();
                    continue block0;
                }
            }
        }
    }

    private static void a(OkHttpClient okHttpClient, OkHttpClient.Builder builder) {
        if (okHttpClient == null || builder == null) {
            return;
        }
        ServiceFactory.a(builder, okHttpClient.interceptors());
        ServiceFactory.b(builder, okHttpClient.networkInterceptors());
        builder.authenticator(okHttpClient.authenticator());
    }

    public static Retrofit addRetrofitInterceptor(String baseUrl, @NonNull Interceptor interceptor) {
        return ServiceFactory.addRetrofitInterceptor(baseUrl, new Interceptor[]{interceptor});
    }

    public static Retrofit addRetrofitTokenHeader(String baseUrl, String tokenKey, String token) {
        return ServiceFactory.addRetrofitInterceptor(baseUrl, new TokenHeaderInterceptor(tokenKey, token));
    }

    public static Retrofit addRetrofitInterceptor(String baseUrl, @NonNull Interceptor[] interceptors) {
        Retrofit retrofit;
        OkHttpClient okHttpClient = b.get(baseUrl);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (okHttpClient != null) {
            ServiceFactory.a(okHttpClient, builder);
            retrofit = new Class[interceptors.length];
            for (int i = 0; i < ((Interceptor[])retrofit).length; ++i) {
                retrofit[i] = interceptors[i].getClass();
            }
            ServiceFactory.a(builder, (Class[])retrofit);
        }
        for (Interceptor interceptor : interceptors) {
            builder.addInterceptor(interceptor);
        }
        okHttpClient = builder.build();
        retrofit = ServiceFactory.getBaseRetrofitBuilder(baseUrl).client(okHttpClient).build();
        a.put(baseUrl, retrofit);
        b.put(baseUrl, okHttpClient);
        return retrofit;
    }

    public static void addAuthenticator(String baseUrl, Authenticator auth) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        ServiceFactory.a(b.get(baseUrl), builder);
        builder.authenticator(auth);
        b.put(baseUrl, builder.build());
    }

    public static synchronized void removeClient(String baseUrl) {
        b.remove(baseUrl);
        a.remove(baseUrl);
    }
}

