/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.support.annotation.Nullable;
import android.util.Log;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.references.CloseableReference;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.PoolConfig;
import com.facebook.imagepipeline.memory.PoolFactory;
import com.onyx.android.sdk.data.compatability.OnyxThumbnail;
import com.onyx.android.sdk.data.model.Thumbnail;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.device.EnvironmentUtil;
import com.onyx.android.sdk.utils.BitmapUtils;
import com.onyx.android.sdk.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class ThumbnailUtils {
    public static final String thumbnail_folder = ".thumbnails";
    public static final String preferred_extension = "png";
    public static OnyxThumbnail.ThumbnailKind DEFAULT_THUMBNAIL_KIND = OnyxThumbnail.ThumbnailKind.Middle;
    public static final float radio = 0.71f;
    private static Map<String, Integer> b = new HashMap<String, Integer>();

    public static Map<String, Integer> defaultThumbnailMapping() {
        return b;
    }

    public static Map<String, Integer> initDefaultThumbnailMap(Map<String, Integer> resMap) {
        b.putAll(resMap);
        return b;
    }

    public static Bitmap loadThumbnail(Context context, int resId) {
        BitmapDrawable bitmapDrawable = (BitmapDrawable)context.getResources().getDrawable(resId);
        return bitmapDrawable == null ? null : bitmapDrawable.getBitmap();
    }

    public static String getThumbnailFile(Context context, String sourceMD5, String thumbnailKind) {
        return ThumbnailUtils.getThumbnailFile(context, sourceMD5, thumbnailKind, preferred_extension);
    }

    public static String getThumbnailFile(Context context, String sourceMD5, String thumbnailKind, String extension) {
        return ThumbnailUtils.getThumbnailFolder(context) + File.separator + sourceMD5 + "." + thumbnailKind + "." + extension;
    }

    public static String getThumbnailFolder(Context context) {
        return EnvironmentUtil.getExternalStorageAppCacheDirectory((String)context.getPackageName()) + File.separator + thumbnail_folder;
    }

    private static Bitmap a(Bitmap bitmap, OnyxThumbnail.ThumbnailKind thumbnailKind) {
        Bitmap bitmap2 = bitmap;
        switch (thumbnailKind) {
            case Original: {
                bitmap2 = OnyxThumbnail.createLargeThumbnail(bitmap);
                break;
            }
            case Large: {
                bitmap2 = OnyxThumbnail.createLargeThumbnail(bitmap);
                break;
            }
            case Middle: {
                bitmap2 = OnyxThumbnail.createMiddleThumbnail(bitmap);
                break;
            }
            case Small: {
                bitmap2 = OnyxThumbnail.createSmallThumbnail(bitmap);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return bitmap2;
    }

    public static boolean insertDefaultKindThumbnail(Context context, DataProviderBase provider, String filePath, String associationId, Bitmap bitmap) {
        return ThumbnailUtils.insertThumbnail(context, provider, filePath, associationId, DEFAULT_THUMBNAIL_KIND, bitmap);
    }

    public static boolean insertThumbnail(Context context, DataProviderBase dataProvider, String filePath, String associationId, OnyxThumbnail.ThumbnailKind kind, Bitmap bitmap) {
        String string2 = ThumbnailUtils.getThumbnailFile(context, associationId, kind.toString());
        return ThumbnailUtils.insertThumbnail(context, dataProvider, filePath, string2, associationId, kind, bitmap);
    }

    public static boolean insertThumbnail(Context context, DataProviderBase dataProvider, String bookFilePath, String thumbnailFilePath, String associationId, OnyxThumbnail.ThumbnailKind kind, Bitmap bitmap) {
        Thumbnail thumbnail = ThumbnailUtils.insertThumbnail(context, dataProvider, bookFilePath, thumbnailFilePath, associationId, kind);
        return thumbnail != null && ThumbnailUtils.generateThumbnailBitmap(thumbnail, bitmap);
    }

    @Nullable
    public static Thumbnail insertThumbnail(Context context, DataProviderBase dataProvider, String bookFilePath, String thumbnailFilePath, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        Thumbnail thumbnail = new Thumbnail();
        thumbnail.setThumbnailKind(kind);
        thumbnail.setOriginContentPath(bookFilePath);
        thumbnail.setIdString(associationId);
        thumbnail.setImageDataPath(thumbnailFilePath);
        boolean bl = dataProvider.saveThumbnailEntry(context, thumbnail);
        return bl ? thumbnail : null;
    }

    public static boolean insertThumbnail(Context context, DataProviderBase dataProvider, String filePath, String associationId, Bitmap bitmap) {
        for (OnyxThumbnail.ThumbnailKind thumbnailKind : OnyxThumbnail.ThumbnailKind.values()) {
            boolean bl = ThumbnailUtils.insertThumbnail(context, dataProvider, filePath, associationId, thumbnailKind, bitmap);
            if (!thumbnailKind.equals((Object)DEFAULT_THUMBNAIL_KIND) || bl) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean writeBitmapToThumbnailFile(File file, Bitmap transBitmap) {
        boolean bl;
        FileOutputStream fileOutputStream;
        block8: {
            fileOutputStream = null;
            fileOutputStream = new FileOutputStream(file);
            if (transBitmap != null && !transBitmap.isRecycled()) break block8;
            boolean bl2 = false;
            FileUtils.closeQuietly((Closeable)fileOutputStream);
            return bl2;
        }
        try {
            Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.PNG;
            if (FileUtils.isPngExtension((File)file)) {
                compressFormat = Bitmap.CompressFormat.PNG;
            } else if (FileUtils.isJpgExtension((File)file)) {
                compressFormat = Bitmap.CompressFormat.JPEG;
            }
            bl = transBitmap.compress(compressFormat, 100, (OutputStream)fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                Log.w((String)"writeBitmapToThumbnail", (Throwable)fileNotFoundException);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
            FileUtils.closeQuietly((Closeable)fileOutputStream);
            return false;
        }
        FileUtils.closeQuietly((Closeable)fileOutputStream);
        return bl;
    }

    public static boolean generateThumbnailBitmap(Thumbnail thumbnail, Bitmap bmp) {
        Bitmap bitmap = ThumbnailUtils.a(bmp, thumbnail.getThumbnailKind());
        FileUtils.ensureFileExists((String)thumbnail.getImageDataPath());
        File file = new File(thumbnail.getImageDataPath());
        return ThumbnailUtils.writeBitmapToThumbnailFile(file, bitmap);
    }

    public static Bitmap createLargeThumbnail(Bitmap bmp) {
        return ThumbnailUtils.a(bmp, 512);
    }

    public static Bitmap createMiddleThumbnail(Bitmap bmp) {
        return ThumbnailUtils.a(bmp, 256);
    }

    public static Bitmap createSmallThumbnail(Bitmap bmp) {
        return ThumbnailUtils.a(bmp, 128);
    }

    private static Bitmap a(Bitmap bitmap, int n) {
        if (bitmap.getWidth() <= n && bitmap.getHeight() <= n) {
            return bitmap;
        }
        int n2 = n;
        int n3 = n;
        if (bitmap.getWidth() >= bitmap.getHeight()) {
            double d = (double)n / (double)bitmap.getWidth();
            n3 = (int)(d * (double)bitmap.getHeight());
        } else {
            double d = (double)n / (double)bitmap.getHeight();
            n2 = (int)(d * (double)bitmap.getWidth());
        }
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n2, (int)n3, (boolean)true);
    }

    public static CloseableReference<Bitmap> decodeFile(File file) throws IOException {
        return ThumbnailUtils.decodeStream(new FileInputStream(file), Bitmap.Config.ARGB_8888);
    }

    public static CloseableReference<Bitmap> decodeFile(File file, Bitmap.Config config) throws IOException {
        return ThumbnailUtils.decodeStream(new FileInputStream(file), config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableReference<Bitmap> decodeStream(InputStream inputStream, Bitmap.Config config) throws IOException {
        CloseableReference closeableReference;
        PoolFactory poolFactory = new PoolFactory(PoolConfig.newBuilder().build());
        PooledByteBuffer pooledByteBuffer = null;
        EncodedImage encodedImage = null;
        try {
            pooledByteBuffer = poolFactory.getPooledByteBufferFactory().newByteBuffer(inputStream);
            encodedImage = new EncodedImage(CloseableReference.of((Closeable)pooledByteBuffer));
            closeableReference = Fresco.getImagePipelineFactory().getPlatformDecoder().decodeFromEncodedImage(encodedImage, config, null);
        }
        catch (Throwable throwable) {
            FileUtils.closeQuietly((Closeable)inputStream);
            FileUtils.closeQuietly(encodedImage);
            FileUtils.closeQuietly((Closeable)pooledByteBuffer);
            throw throwable;
        }
        FileUtils.closeQuietly((Closeable)inputStream);
        FileUtils.closeQuietly((Closeable)encodedImage);
        FileUtils.closeQuietly((Closeable)pooledByteBuffer);
        return closeableReference;
    }

    public static boolean hasThumbnail(Context context, DataProviderBase dataProvider, String associationId) {
        Thumbnail thumbnail = ThumbnailUtils.getThumbnailEntry(context, dataProvider, associationId, DEFAULT_THUMBNAIL_KIND);
        return thumbnail != null && thumbnail.hasValidId();
    }

    public static boolean hasThumbnailFile(Context context, DataProviderBase dataProvider, String associationId) {
        Thumbnail thumbnail = ThumbnailUtils.getDefaultKindThumbnailEntry(context, dataProvider, associationId);
        return thumbnail != null && thumbnail.hasValidId() && FileUtils.fileExist((String)thumbnail.getImageDataPath());
    }

    public static Thumbnail getThumbnailEntry(Context context, DataProviderBase dataProvider, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        return dataProvider.getThumbnailEntry(context, associationId, kind);
    }

    public static Thumbnail getDefaultKindThumbnailEntry(Context context, DataProviderBase dataProvider, String associationId) {
        return ThumbnailUtils.getThumbnailEntry(context, dataProvider, associationId, DEFAULT_THUMBNAIL_KIND);
    }

    public static boolean updateThumbnailEntrySet(Context context, DataProviderBase dataProvider, String associationId, Bitmap originBitmap) {
        boolean bl = true;
        for (OnyxThumbnail.ThumbnailKind thumbnailKind : OnyxThumbnail.ThumbnailKind.values()) {
            bl &= ThumbnailUtils.updateThumbnailEntry(context, dataProvider, associationId, thumbnailKind, originBitmap);
        }
        return bl;
    }

    public static boolean updateThumbnailEntry(Context context, DataProviderBase dataProvider, String associationId, OnyxThumbnail.ThumbnailKind kind, Bitmap originBitmap) {
        Thumbnail thumbnail = ThumbnailUtils.getThumbnailEntry(context, dataProvider, associationId, kind);
        if (thumbnail == null) {
            Log.w((String)"update thumbnail", (String)"detect null");
            return false;
        }
        thumbnail.setImageDataPath(ThumbnailUtils.getThumbnailFile(context, thumbnail.getIdString(), thumbnail.getThumbnailKind().toString()));
        boolean bl = dataProvider.saveThumbnailEntry(context, thumbnail);
        return bl && ThumbnailUtils.generateThumbnailBitmap(thumbnail, originBitmap);
    }

    public static void updateThumbnail(Context context, DataProviderBase dataProvider, Thumbnail thumbnail) {
        dataProvider.updateThumbnailEntry(context, thumbnail);
    }

    public static boolean isBitmapValid(CloseableReference<Bitmap> refBitmap) {
        return refBitmap != null && refBitmap.isValid() && BitmapUtils.isValid((Bitmap)((Bitmap)refBitmap.get()));
    }
}

