/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import com.onyx.android.sdk.data.db.table.OnyxAnnotationProvider;
import com.onyx.android.sdk.data.db.table.OnyxBookmarkProvider;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.provider.DataProviderManager;
import com.onyx.android.sdk.utils.Debug;

public class ReaderDBUtils {
    public static final String READER_AUTHORITY = "content://com.onyx.kreader.note.provider";
    public static final Uri READER_NOTE_DOCUMENT_URI = Uri.parse((String)"content://com.onyx.kreader.note.provider/ReaderNoteDocumentModel");
    public static final Uri READER_NOTE_SHAPE_URI = Uri.parse((String)"content://com.onyx.kreader.note.provider/ReaderNoteShapeModel");
    public static final String COLUMN_DOCUMENT_UNIQUE_ID = "uniqueId";
    public static final String COLUMN_SHAPE_DOCUMENT_UNIQUE_ID = "documentUniqueId";
    public static final String COLUMN_ID_STRING = "idString";

    public static void deleteBookData(Context context, String bookPath) {
        DataProviderBase dataProviderBase = DataProviderManager.getRemoteDataProvider();
        Metadata metadata = dataProviderBase.findMetadataByPath(context, bookPath);
        if (metadata == null) {
            return;
        }
        String string2 = metadata.getHashTag();
        ReaderDBUtils.a(context, string2);
        ReaderDBUtils.b(context, string2);
        ReaderDBUtils.c(context, string2);
        ReaderDBUtils.d(context, string2);
        dataProviderBase.removeMetadata(context, metadata);
    }

    private static int a(Context context, String string2) {
        ContentResolver contentResolver = context.getApplicationContext().getContentResolver();
        String string3 = "uniqueId= ?";
        String[] stringArray = new String[]{string2};
        int n = contentResolver.delete(READER_NOTE_DOCUMENT_URI, string3, stringArray);
        if (n == 0) {
            Debug.d((String)"delete NoteDocument failure or nothing to delete");
        }
        return n;
    }

    private static int b(Context context, String string2) {
        ContentResolver contentResolver = context.getApplicationContext().getContentResolver();
        String string3 = "documentUniqueId= ?";
        String[] stringArray = new String[]{string2};
        int n = contentResolver.delete(READER_NOTE_SHAPE_URI, string3, stringArray);
        if (n == 0) {
            Debug.d((String)"delete NoteShape failure or nothing to delete");
        }
        return n;
    }

    private static int c(Context context, String string2) {
        ContentResolver contentResolver = context.getApplicationContext().getContentResolver();
        String string3 = "idString= ?";
        String[] stringArray = new String[]{string2};
        int n = contentResolver.delete(OnyxAnnotationProvider.CONTENT_URI, string3, stringArray);
        if (n == 0) {
            Debug.d((String)"delete annotations failure or nothing to delete");
        }
        return n;
    }

    private static int d(Context context, String string2) {
        ContentResolver contentResolver = context.getApplicationContext().getContentResolver();
        String string3 = "idString= ?";
        String[] stringArray = new String[]{string2};
        int n = contentResolver.delete(OnyxBookmarkProvider.CONTENT_URI, string3, stringArray);
        if (n == 0) {
            Debug.d((String)"delete bookmarks failure or nothing to delete");
        }
        return n;
    }
}

