/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.content.Intent;
import com.alibaba.fastjson.parser.Feature;
import com.onyx.android.sdk.data.BookFilter;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.data.model.ExtensionMap;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.utils.JSONObjectParseUtils;
import com.onyx.android.sdk.dataprovider.R;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.ResManager;
import com.onyx.android.sdk.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MetadataUtils {
    public static final String INTENT_EXTRA_DATA_METADATA = "intent_extra_data_metadata";

    public static int compareStringAsc(String a2, String b2) {
        if (a2 == null && b2 == null) {
            return 0;
        }
        if (a2 == null) {
            return -1;
        }
        if (b2 == null) {
            return 1;
        }
        return a2.compareTo(b2);
    }

    public static int compareCreatedAtDateAsc(Metadata a2, Metadata b2) {
        if (a2.getCreatedAt() == null && b2.getCreatedAt() == null) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        if (a2.getCreatedAt() == null) {
            return -1;
        }
        if (b2.getCreatedAt() == null) {
            return 1;
        }
        int n = a2.getCreatedAt().compareTo(b2.getCreatedAt());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        return n;
    }

    public static int compareCreatedAtDateDesc(Metadata a2, Metadata b2) {
        if (a2.getCreatedAt() == null && b2.getCreatedAt() == null) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        if (a2.getCreatedAt() == null) {
            return 1;
        }
        if (b2.getCreatedAt() == null) {
            return -1;
        }
        int n = a2.getCreatedAt().compareTo(b2.getCreatedAt());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        return -n;
    }

    public static int compareLastModifiedDateAsc(Metadata a2, Metadata b2) {
        if (a2.getLastModified() == null && b2.getLastModified() == null) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        if (a2.getLastModified() == null) {
            return -1;
        }
        if (b2.getLastModified() == null) {
            return 1;
        }
        int n = a2.getLastModified().compareTo(b2.getLastModified());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        return n;
    }

    public static int compareLastModifiedDateDesc(Metadata a2, Metadata b2) {
        if (a2.getLastModified() == null && b2.getLastModified() == null) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        if (a2.getLastModified() == null) {
            return 1;
        }
        if (b2.getLastModified() == null) {
            return -1;
        }
        int n = a2.getLastModified().compareTo(b2.getLastModified());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        return -n;
    }

    public static int compareLastAccessedDateAsc(Metadata a2, Metadata b2) {
        if (a2.getLastAccess() == null && b2.getLastAccess() == null) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        if (a2.getLastAccess() == null) {
            return -1;
        }
        if (b2.getLastAccess() == null) {
            return 1;
        }
        int n = a2.getLastAccess().compareTo(b2.getLastAccess());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        return n;
    }

    public static int compareLastAccessedDateDesc(Metadata a2, Metadata b2) {
        if (a2.getLastAccess() == null && b2.getLastAccess() == null) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        if (a2.getLastAccess() == null) {
            return 1;
        }
        if (b2.getLastAccess() == null) {
            return -1;
        }
        int n = a2.getLastAccess().compareTo(b2.getLastAccess());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        return -n;
    }

    public static int compareSizeAsc(Metadata a2, Metadata b2) {
        if (a2.getSize() == b2.getSize()) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        return (int)a2.getSize() - (int)b2.getSize();
    }

    public static int compareSizeDesc(Metadata a2, Metadata b2) {
        if (a2.getSize() == b2.getSize()) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        return (int)b2.getSize() - (int)a2.getSize();
    }

    public static int compareAuthorStringAsc(Metadata a2, Metadata b2) {
        if (a2.getAuthors() == null && b2.getAuthors() == null) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        if (a2.getAuthors() == null) {
            return -1;
        }
        if (b2.getAuthors() == null) {
            return 1;
        }
        int n = a2.getAuthors().compareTo(b2.getAuthors());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        return n;
    }

    public static int compareAuthorStringDesc(Metadata a2, Metadata b2) {
        if (a2.getAuthors() == null && b2.getAuthors() == null) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        if (a2.getAuthors() == null) {
            return 1;
        }
        if (b2.getAuthors() == null) {
            return -1;
        }
        int n = a2.getAuthors().compareTo(b2.getAuthors());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        return -n;
    }

    public static int compareTitleStringAsc(Metadata a2, Metadata b2) {
        if (a2.getTitle() == null && b2.getTitle() == null) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        if (a2.getTitle() == null) {
            return -1;
        }
        if (b2.getTitle() == null) {
            return 1;
        }
        int n = a2.getTitle().compareTo(b2.getTitle());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        return n;
    }

    public static int compareTitleStringDesc(Metadata a2, Metadata b2) {
        if (a2.getTitle() == null && b2.getTitle() == null) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        if (a2.getTitle() == null) {
            return 1;
        }
        if (b2.getTitle() == null) {
            return -1;
        }
        int n = a2.getTitle().compareTo(b2.getTitle());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        return -n;
    }

    public static int compareTypeAsc(Metadata a2, Metadata b2) {
        if (a2.getType() == null && b2.getType() == null) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        if (a2.getType() == null) {
            return -1;
        }
        if (b2.getType() == null) {
            return 1;
        }
        int n = a2.getType().compareTo(b2.getType());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        return n;
    }

    public static int compareTypeDesc(Metadata a2, Metadata b2) {
        if (a2.getType() == null && b2.getType() == null) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        if (a2.getType() == null) {
            return 1;
        }
        if (b2.getType() == null) {
            return -1;
        }
        int n = a2.getType().compareTo(b2.getType());
        if (n == 0) {
            return MetadataUtils.compareStringAsc(a2.getName(), b2.getName());
        }
        return -n;
    }

    public static void sortByCreatedAtDateAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareCreatedAtDateAsc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByCreatedAtDateDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareCreatedAtDateDesc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByLastModifiedAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareLastModifiedDateAsc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByLastModifiedDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareLastModifiedDateDesc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByNameAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByNameDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return -MetadataUtils.compareStringAsc(metadata.getName(), metadata2.getName());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortBySizeAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareSizeAsc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortBySizeDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareSizeDesc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByTitleAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareTitleStringAsc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByTitleDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareTitleStringDesc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByFileTypeAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareTypeAsc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByFileTypeDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareTypeDesc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByAuthorAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareAuthorStringAsc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByAuthorDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareAuthorStringDesc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByPublisherAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareStringAsc(metadata.getPublisher(), metadata2.getPublisher());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByPublisherDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return -MetadataUtils.compareStringAsc(metadata.getPublisher(), metadata2.getPublisher());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByRecentlyReadAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareLastAccessedDateAsc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByRecentlyReadDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareLastAccessedDateDesc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByLastOpenTimeAsc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareLastAccessedDateAsc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sortByLastOpenTimeDesc(List<Metadata> list) {
        Collections.sort(list, new Comparator<Metadata>(){

            public int a(Metadata metadata, Metadata metadata2) {
                return MetadataUtils.compareLastAccessedDateDesc(metadata, metadata2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Metadata)((Object)object), (Metadata)((Object)object2));
            }
        });
    }

    public static void sort(List<Metadata> list, SortBy sortBy, SortOrder order) {
        switch (sortBy) {
            case None: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByNameAsc(list);
                    break;
                }
                MetadataUtils.sortByNameDesc(list);
                break;
            }
            case Name: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByNameAsc(list);
                    break;
                }
                MetadataUtils.sortByNameDesc(list);
                break;
            }
            case FileType: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByFileTypeAsc(list);
                    break;
                }
                MetadataUtils.sortByFileTypeDesc(list);
                break;
            }
            case Size: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortBySizeAsc(list);
                    break;
                }
                MetadataUtils.sortBySizeDesc(list);
                break;
            }
            case CreationTime: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByCreatedAtDateAsc(list);
                    break;
                }
                MetadataUtils.sortByCreatedAtDateDesc(list);
                break;
            }
            case BookTitle: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByTitleAsc(list);
                    break;
                }
                MetadataUtils.sortByTitleDesc(list);
                break;
            }
            case Author: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByAuthorAsc(list);
                    break;
                }
                MetadataUtils.sortByAuthorDesc(list);
                break;
            }
            case Publisher: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByPublisherAsc(list);
                    break;
                }
                MetadataUtils.sortByPublisherDesc(list);
                break;
            }
            case RecentlyRead: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByRecentlyReadAsc(list);
                    break;
                }
                MetadataUtils.sortByRecentlyReadDesc(list);
                break;
            }
            case Total: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByLastOpenTimeAsc(list);
                    break;
                }
                MetadataUtils.sortByLastOpenTimeDesc(list);
                break;
            }
            case StartTime: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByLastOpenTimeAsc(list);
                    break;
                }
                MetadataUtils.sortByLastOpenTimeDesc(list);
                break;
            }
            case LastOpenTime: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByLastOpenTimeAsc(list);
                    break;
                }
                MetadataUtils.sortByLastOpenTimeDesc(list);
                break;
            }
            case InstallTime: {
                if (order == SortOrder.Asc) {
                    MetadataUtils.sortByLastOpenTimeAsc(list);
                    break;
                }
                MetadataUtils.sortByLastOpenTimeDesc(list);
                break;
            }
        }
    }

    public static boolean safelyContains(Set<String> set, String string2) {
        return set == null || set.size() <= 0 || set.contains(string2);
    }

    public static boolean safelyContains(Set<String> set, List<String> list) {
        if (set != null && list != null) {
            for (String string2 : list) {
                if (!set.contains(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean safelyContains(String parent, String query) {
        return !StringUtils.isNullOrEmpty((String)parent) && !StringUtils.isNullOrEmpty((String)query) && parent.contains(query);
    }

    public static boolean safelyContains(Metadata metadata, String query) {
        if (MetadataUtils.safelyContains(metadata.getName(), query)) {
            return true;
        }
        if (MetadataUtils.safelyContains(metadata.getAuthors(), query)) {
            return true;
        }
        return MetadataUtils.safelyContains(metadata.getTitle(), query);
    }

    public static boolean containsIfNotNull(Set<String> source, Collection<String> target) {
        if (source == null || source.size() == 0) {
            return true;
        }
        if (target == null) {
            return false;
        }
        for (String string2 : target) {
            if (!source.contains(string2)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getStringSplitSet(String originString, String delimiter) {
        String[] stringArray;
        HashSet<String> hashSet = new HashSet<String>();
        if (originString == null) {
            return hashSet;
        }
        for (String string2 : stringArray = originString.split(delimiter)) {
            hashSet.add(string2);
        }
        return hashSet;
    }

    public static boolean criteriaContains(Metadata metadata, QueryArgs criteria) {
        if (!CollectionUtils.contains(criteria.fileType, (String)metadata.getType().toLowerCase())) {
            return false;
        }
        if (!MetadataUtils.containsIfNotNull(criteria.author, MetadataUtils.getStringSplitSet(metadata.getAuthors(), ","))) {
            return false;
        }
        if (!MetadataUtils.containsIfNotNull(criteria.tags, MetadataUtils.getStringSplitSet(metadata.getTags(), ","))) {
            return false;
        }
        if (!CollectionUtils.contains(criteria.title, (String)metadata.getTitle())) {
            return false;
        }
        return MetadataUtils.containsIfNotNull(criteria.series, MetadataUtils.getStringSplitSet(metadata.getSeries(), ","));
    }

    public static List<Metadata> verifyReadedStatus(List<Metadata> list, BookFilter filter) {
        if (filter != BookFilter.FINISHED) {
            return list;
        }
        ArrayList<Metadata> arrayList = new ArrayList<Metadata>();
        for (Metadata metadata : list) {
            if (!metadata.isFinished()) continue;
            arrayList.add(metadata);
        }
        return arrayList;
    }

    public static Metadata ensureObject(Metadata metadata) {
        return metadata != null ? metadata : new Metadata();
    }

    public static Intent putIntentExtraDataMetadata(Intent intent, Metadata metadata) {
        intent.putExtra(INTENT_EXTRA_DATA_METADATA, JSONObjectParseUtils.toJson((Object)metadata));
        return intent;
    }

    public static Metadata getIntentExtraDataMetadata(Intent intent) {
        String string2 = intent.getStringExtra(INTENT_EXTRA_DATA_METADATA);
        return JSONObjectParseUtils.parseObject(string2, Metadata.class, new Feature[0]);
    }

    public static boolean isJdBook(Metadata metadata) {
        if (metadata == null) {
            return false;
        }
        return MetadataUtils.isJdBook(StringUtils.isNullOrEmpty((String)metadata.getType()) ? FileUtils.getFileExtension((String)metadata.getIdString()) : metadata.getType());
    }

    public static boolean isJdBook(String extension) {
        return StringUtils.safelyEquals((String)ExtensionMap.getExtension(StringUtils.isNullOrEmpty((String)extension) ? "" : extension.toUpperCase()), (String)ResManager.getString((int)R.string.jd_book_show_extension));
    }
}

