/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.data.fs;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.DataManagerHelper;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.data.model.FileModel;
import com.onyx.android.sdk.data.request.data.fs.BaseFSRequest;
import com.onyx.android.sdk.dataprovider.R;
import com.onyx.android.sdk.device.EnvironmentUtil;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.ResManager;
import com.onyx.android.sdk.utils.StorageUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageFileListLoadRequest
extends BaseFSRequest {
    private static final int a = 30;
    private boolean b;
    private File c;
    private SortBy d;
    private SortOrder e;
    private Map<String, Integer> f = new HashMap<String, Integer>();
    private List<File> g = new ArrayList<File>();
    private List<File> h = new ArrayList<File>();
    private List<String> i = new ArrayList<String>();
    private List<FileModel> j = new ArrayList<FileModel>();
    private List<String> k;
    private int l;
    private int m = Integer.MAX_VALUE;
    private int n;
    private boolean o = true;
    private boolean p = false;
    private int q;
    private int r;
    private long s;
    private long t;

    public StorageFileListLoadRequest(@NonNull DataManager dataManager, @NonNull File targetDir) {
        super(dataManager);
        this.c = targetDir;
    }

    public StorageFileListLoadRequest setSort(SortBy sortBy, SortOrder sortOrder) {
        this.d = sortBy;
        this.e = sortOrder;
        return this;
    }

    public StorageFileListLoadRequest setSkipHiddenFile(boolean skipHiddenFile) {
        this.b = skipHiddenFile;
        return this;
    }

    public StorageFileListLoadRequest setShortCutList(List<String> shortCutList) {
        this.k = shortCutList;
        return this;
    }

    public List<File> getResultFileList() {
        return this.g;
    }

    public List<File> getExcludeDirFileList() {
        return this.h;
    }

    public int getDirectoryCount() {
        return this.q;
    }

    public int getFileCount() {
        return this.r;
    }

    public StorageFileListLoadRequest setResultFileList(@NonNull List<File> list) {
        this.g = list;
        return this;
    }

    public List<FileModel> getResultDataItemList() {
        return this.j;
    }

    public StorageFileListLoadRequest setOffset(int offset) {
        this.n = offset;
        return this;
    }

    public StorageFileListLoadRequest setLimit(int limit) {
        this.m = limit;
        return this;
    }

    public StorageFileListLoadRequest setLoadThumbnail(boolean loadThumbnail) {
        this.o = loadThumbnail;
        return this;
    }

    public StorageFileListLoadRequest setThumbnailLocalResource(Map<String, Integer> defaultThumbnailMap) {
        this.f.clear();
        this.f.putAll(defaultThumbnailMap);
        return this;
    }

    public StorageFileListLoadRequest setFilterDirFileList(List<String> filterDirList) {
        if (filterDirList != null) {
            this.i.addAll(filterDirList);
        }
        return this;
    }

    public int getTotalCount() {
        return this.l;
    }

    public long getStorageTotalCapacity() {
        return this.s;
    }

    public long getStorageAvailableCapacity() {
        return this.t;
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        this.q = 0;
        this.r = 0;
        this.a();
        this.c();
        this.d();
        if (FileUtils.isStorageRoot((File)this.c)) {
            this.e();
        } else {
            this.f();
        }
        if (this.g()) {
            FileUtils.sortFileList(this.g, (SortBy)this.d, (SortOrder)this.e);
        }
        this.a(this.c, this.g);
    }

    private void a() {
        this.s = StorageUtils.getDisplayGBForUser((double)StorageUtils.getInternalStorageAmount());
        this.b();
    }

    private void b() {
        Long[] longArray = StorageUtils.STANDARD_STORAGE;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long l = longArray[i];
            if (l < this.s) continue;
            this.s = l;
            break;
        }
    }

    private void c() {
        this.t = StorageUtils.getSDCardFreeMB();
    }

    private void d() {
        if (this.g == null) {
            this.g = new ArrayList<File>();
        }
    }

    private void e() {
        this.g.clear();
        if (EnvironmentUtil.getExternalStorageDirectory().canRead()) {
            this.g.add(EnvironmentUtil.getExternalStorageDirectory());
        }
        if (EnvironmentUtil.getRemovableSDCardDirectory().canRead()) {
            this.g.add(EnvironmentUtil.getRemovableSDCardDirectory());
        }
    }

    private void f() {
        if (!CollectionUtils.isNullOrEmpty(this.g)) {
            return;
        }
        this.g = FileUtils.loadStorageFileList((File)this.c, (boolean)this.b, this.i);
    }

    private boolean g() {
        return this.d != null && this.e != null;
    }

    private void a(File file, List<File> list) {
        this.j.clear();
        this.h.clear();
        if (this.p) {
            this.b(file);
        }
        this.a(list, this.e(file));
        this.h();
        this.a(list);
    }

    private void a(List<File> list) {
        for (File file : list) {
            if (file.isDirectory()) {
                ++this.q;
                continue;
            }
            ++this.r;
            this.a(file);
        }
    }

    private void a(File file) {
        this.h.add(file);
    }

    private void h() {
        if (!this.o) {
            return;
        }
        int n = Math.min(CollectionUtils.getSize(this.j), 30);
        for (int i = 0; i < n; ++i) {
            FileModel fileModel = this.j.get(i);
            if (!fileModel.isFileType()) continue;
            fileModel.setRefCoverBitmap(DataManagerHelper.loadThumbnailBitmapWithCache(this.getContext(), this.getDataManager().getRemoteContentProvider(), this.getDataManager().getCacheManager().getBitmapLruCache(), fileModel.getFile().getAbsolutePath()));
        }
    }

    private void a(List<File> list, List<String> list2) {
        int n;
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        int n2 = list.size();
        int n3 = n2 + (n = CollectionUtils.getSize(list2));
        if (this.n >= n3) {
            this.n = Math.max(0, n3 - this.m);
        }
        if (this.m + this.n > n3) {
            this.m = n3 - this.n;
        }
        for (int i = 0; i < this.m; ++i) {
            int n4 = this.n + i;
            if (n4 < n2) {
                FileModel fileModel = this.d(list.get(n4));
                if (fileModel == null) continue;
                this.j.add(fileModel);
                continue;
            }
            this.j.add(this.a(list2.get(n4 - n2)));
        }
        this.l += n3;
    }

    private void b(File file) {
        if (FileUtils.isStorageRoot((File)file)) {
            return;
        }
        ++this.l;
        if (this.n <= 0) {
            this.j.add(this.c(file));
        }
        if (--this.n < 0) {
            this.n = 0;
        }
    }

    private FileModel c(File file) {
        FileModel fileModel = FileModel.createGoUpModel(file, ResManager.getString((int)R.string.storage_item_go_up));
        fileModel.setThumbnailResId(this.b("goup"));
        return fileModel;
    }

    private FileModel d(File file) {
        if (!file.canRead()) {
            return null;
        }
        int n = 0;
        FileModel fileModel = FileModel.create(file, null);
        if (file.getAbsolutePath().equalsIgnoreCase(EnvironmentUtil.getExternalStorageDirectory().getAbsolutePath()) || FileUtils.isStorageRoot((File)file)) {
            fileModel.setName(ResManager.getString((int)R.string.external_storage));
        }
        if (fileModel.isDirectoryType()) {
            n = this.b("directory");
        } else if (fileModel.isFileType()) {
            n = this.b("filecover");
        } else if (fileModel.isApkType()) {
            n = this.b("apk");
            fileModel.showExtensionOnCover();
            fileModel.setCanPadding(true);
        }
        fileModel.setThumbnailResId(n);
        return fileModel;
    }

    private FileModel a(String string2) {
        FileModel fileModel = FileModel.createShortcutModel(new File(this.c.getParentFile() + File.separator + new File(string2).getName()));
        fileModel.setShortcutPath(string2);
        fileModel.setThumbnailResId(this.b("shortcut"));
        return fileModel;
    }

    private int b(String string2) {
        if (this.f.containsKey(string2)) {
            return this.f.get(string2);
        }
        return this.f.get("");
    }

    @Nullable
    private List<String> e(File file) {
        if (FileUtils.isStorageRoot((File)file)) {
            return this.k;
        }
        return null;
    }
}

