/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.data.fs;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.util.Log;
import com.onyx.android.sdk.data.AppDataInfo;
import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.data.request.data.fs.BaseFSRequest;
import com.onyx.android.sdk.utils.ApplicationUtil;
import com.onyx.android.sdk.utils.Benchmark;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.ComparatorUtils;
import com.onyx.android.sdk.utils.RawResourceUtil;
import com.onyx.android.sdk.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppsListLoadRequest
extends BaseFSRequest {
    private static final String a = AppsListLoadRequest.class.getSimpleName();
    private Map<String, String> b = new HashMap<String, String>();
    private List<AppDataInfo> c = new ArrayList<AppDataInfo>();
    private List<AppDataInfo> d = new ArrayList<AppDataInfo>();
    private SortBy e;
    private SortOrder f;
    private boolean g = false;
    private String h;
    private List<String> i = new ArrayList<String>();
    private List<String> j = new ArrayList<String>();

    public AppsListLoadRequest(DataManager dataManager, List<String> ignoreAppList, List<String> testAppList, Map<String, String> customizedIconAppsMap) {
        super(dataManager);
        CollectionUtils.safeAddAll(this.i, ignoreAppList);
        CollectionUtils.safeAddAll(this.j, testAppList);
        CollectionUtils.safeAddAllMap(this.b, customizedIconAppsMap);
    }

    public List<AppDataInfo> getAppInfoList() {
        return this.d;
    }

    public boolean isTestAppExist() {
        return this.g;
    }

    public void setSort(SortBy sortBy, SortOrder sortOrder) {
        this.e = sortBy;
        this.f = sortOrder;
    }

    public void setAppRemoteIconDir(String appRemoteIconDir) {
        this.h = appRemoteIconDir;
    }

    public void addExtraAppData(List<AppDataInfo> list) {
        CollectionUtils.safeAddAll(this.c, list);
    }

    public void filterAppByPreference(boolean isEnable, List<String> filterApps) {
        if (!isEnable) {
            this.i.addAll(filterApps);
        }
    }

    public void setFilterAppList(List<String> filterApps) {
        this.i.addAll(filterApps);
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        this.a();
        this.processLoadApplication();
        if (this.b()) {
            this.a(this.d, this.e, this.f);
        }
    }

    private void a() {
        for (AppDataInfo appDataInfo : this.c) {
            AppDataInfo appDataInfo2 = this.a(appDataInfo.clone());
            if (appDataInfo2 == null) continue;
            this.d.add(appDataInfo2);
        }
    }

    protected void processLoadApplication() throws Exception {
        Intent intent = new Intent("android.intent.action.MAIN", null);
        intent.addCategory("android.intent.category.LAUNCHER");
        List list = this.getContext().getPackageManager().getInstalledPackages(0);
        List list2 = this.getContext().getPackageManager().queryIntentActivities(intent, 512);
        for (PackageInfo packageInfo : list) {
            AppDataInfo appDataInfo;
            String string2 = packageInfo.applicationInfo.packageName;
            if (CollectionUtils.safelyContains(this.i, (String)string2)) continue;
            if (CollectionUtils.safelyContains(this.j, (String)string2)) {
                if (ApplicationUtil.testAppRecordExist((Context)this.getContext(), (String)string2)) continue;
                this.g = true;
                appDataInfo = ApplicationUtil.appDataFromPackageInfo((Context)this.getContext(), (PackageInfo)packageInfo);
            } else {
                appDataInfo = ApplicationUtil.appDataFromPackageInfo((Context)this.getContext(), (List)list2, (PackageInfo)packageInfo);
            }
            if (appDataInfo == null) continue;
            ApplicationUtil.checkCustomIcon((Context)this.getContext(), this.b, (AppDataInfo)appDataInfo);
            ApplicationUtil.checkIconByTargetDir((String)this.h, (AppDataInfo)appDataInfo);
            appDataInfo.isEnable = packageInfo.applicationInfo.enabled;
            this.d.add(appDataInfo);
        }
    }

    private AppDataInfo a(AppDataInfo appDataInfo) {
        if (appDataInfo == null || StringUtils.isNullOrEmpty((String)appDataInfo.packageName)) {
            return null;
        }
        if (appDataInfo.intent != null) {
            return appDataInfo;
        }
        AppDataInfo appDataInfo2 = null;
        PackageInfo packageInfo = ApplicationUtil.getPackageInfoFromPackageName((Context)this.getContext(), (String)appDataInfo.packageName);
        if (packageInfo != null) {
            appDataInfo.lastUpdatedTime = packageInfo.lastUpdateTime;
            appDataInfo2 = ApplicationUtil.appDataFromPackageInfo((Context)this.getContext(), (PackageInfo)packageInfo);
        }
        if (StringUtils.isNullOrEmpty((String)appDataInfo.activityClassName)) {
            return appDataInfo2;
        }
        appDataInfo.intent = new Intent();
        appDataInfo.intent.setComponent(new ComponentName(appDataInfo.packageName, appDataInfo.activityClassName));
        String string2 = RawResourceUtil.getStringByResourceName((Context)this.getContext(), (String)appDataInfo.labelName);
        if (StringUtils.isNotBlank((String)string2)) {
            appDataInfo.labelName = string2;
        }
        if (appDataInfo.iconDrawable == null && StringUtils.isNotBlank((String)appDataInfo.iconDrawableName)) {
            appDataInfo.iconDrawable = RawResourceUtil.getDrawableByResourceName((Context)this.getContext(), (String)appDataInfo.iconDrawableName);
            if (appDataInfo.iconDrawable == null && appDataInfo2 != null) {
                appDataInfo.iconDrawable = appDataInfo2.iconDrawable;
            }
        }
        return appDataInfo;
    }

    private boolean b() {
        return this.e != null && this.f != null;
    }

    private void a(List<AppDataInfo> list, SortBy sortBy, SortOrder sortOrder) {
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        Benchmark benchmark = new Benchmark();
        switch (sortBy) {
            case Name: {
                AppsListLoadRequest.sortListByName(list, sortOrder);
                break;
            }
            case InstallTime: {
                AppsListLoadRequest.sortListByInstallTime(list, sortOrder);
            }
        }
        Log.w((String)a, (String)("Sort duration:" + benchmark.duration() + "ms"));
    }

    public static void sortListByName(List<AppDataInfo> fileList, final SortOrder sortOrder) {
        Collections.sort(fileList, new Comparator<AppDataInfo>(){

            public int a(AppDataInfo appDataInfo, AppDataInfo appDataInfo2) {
                return ComparatorUtils.stringComparator((String)appDataInfo.labelName, (String)appDataInfo2.labelName, (SortOrder)sortOrder);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((AppDataInfo)object, (AppDataInfo)object2);
            }
        });
    }

    public static void sortListByInstallTime(List<AppDataInfo> fileList, final SortOrder sortOrder) {
        Collections.sort(fileList, new Comparator<AppDataInfo>(){

            public int a(AppDataInfo appDataInfo, AppDataInfo appDataInfo2) {
                return ComparatorUtils.longComparator((long)appDataInfo.lastUpdatedTime, (long)appDataInfo2.lastUpdatedTime, (SortOrder)sortOrder);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((AppDataInfo)object, (AppDataInfo)object2);
            }
        });
    }

    public AppsListLoadRequest setTestAppExist(boolean testAppExist) {
        this.g = testAppExist;
        return this;
    }

    public String getAppRemoteIconDir() {
        return this.h;
    }

    public List<String> getIgnoreAppList() {
        return this.i;
    }

    public List<String> getTestAppList() {
        return this.j;
    }

    public Map<String, String> getCustomizedIconAppsMap() {
        return this.b;
    }
}

