/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import android.content.Context;
import com.alibaba.fastjson.JSON;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.model.BaseQuery;
import com.onyx.android.sdk.data.model.Link;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.ProductResult;
import com.onyx.android.sdk.data.model.PushProduct;
import com.onyx.android.sdk.data.model.PushProduct_Table;
import com.onyx.android.sdk.data.model.PushRecord;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.provider.DataProviderManager;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.StoreUtils;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.NetworkUtil;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import retrofit2.Response;

public class PushRecordListRequest
extends BaseCloudRequest {
    private boolean a;
    private boolean b;
    private BaseQuery c;
    private List<PushRecord> d = new ArrayList<PushRecord>();
    private List<PushProduct> e = new ArrayList<PushProduct>();
    private Set<String> f;

    public PushRecordListRequest(CloudManager cloudManager, BaseQuery pushQuery, boolean cloud, boolean clearLocal) {
        super(cloudManager);
        this.c = pushQuery;
        this.b = clearLocal;
        this.a = cloud;
    }

    public List<PushProduct> getProductList() {
        return this.e;
    }

    public List<PushRecord> getRecordList() {
        return this.d;
    }

    public void setFilterSet(Set<String> filterSet) {
        this.f = filterSet;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        if (!this.a) {
            this.a(parent);
            return;
        }
        if (NetworkUtil.isWiFiConnected((Context)this.getContext())) {
            this.b(parent);
        } else {
            this.a(parent);
        }
    }

    private void a(CloudManager cloudManager) throws Exception {
        this.e = this.a();
        this.a(this.getContext(), this.e);
        this.a(this.e, cloudManager.getCloudConf().getCloudStorage());
    }

    private void b(CloudManager cloudManager) throws Exception {
        ProductResult productResult;
        Response<ProductResult<PushRecord>> response = this.executeCall(ServiceFactory.getPushService(cloudManager.getCloudConf().getApiBase()).pushRecordList(JSON.toJSONString((Object)this.c), this.getAccountSessionToken()));
        if (response.isSuccessful() && !StoreUtils.isEmpty(productResult = (ProductResult)response.body())) {
            this.d = productResult.list;
            this.f = this.f == null ? new HashSet() : this.f;
            for (PushRecord pushRecord : productResult.list) {
                String string2;
                PushProduct pushProduct = pushRecord.parsePushProduct();
                if (pushProduct == null || this.f.contains(string2 = pushProduct.getGuid())) continue;
                this.f.add(string2);
                if (pushRecord.getCreatedAt() != null) {
                    pushProduct.setCreatedAt(pushRecord.getCreatedAt());
                }
                pushProduct.recordId = pushRecord.getGuid();
                this.e.add(pushProduct);
            }
            if (this.e.size() > 0) {
                this.a(this.e, this.b);
            }
            this.a(this.getContext(), this.e);
            this.a(this.e, cloudManager.getCloudConf().getCloudStorage());
        }
    }

    private void a(List<PushProduct> list, boolean bl) {
        List<PushProduct> list2 = this.a();
        if (!CollectionUtils.isNullOrEmpty(list2)) {
            Map<String, PushProduct> map = this.a(list2);
            for (PushProduct pushProduct : list) {
                PushProduct pushProduct2 = map.get(pushProduct.getGuid());
                if (pushProduct2 == null) continue;
                pushProduct.setIdString(pushProduct2.getIdString());
            }
        }
        StoreUtils.saveToLocal(list, PushProduct.class, bl);
    }

    private Map<String, PushProduct> a(List<PushProduct> list) {
        if (list == null) {
            return new HashMap<String, PushProduct>(0);
        }
        HashMap<String, PushProduct> hashMap = new HashMap<String, PushProduct>(list.size());
        for (PushProduct pushProduct : list) {
            if (!StringUtils.isNotBlank((String)pushProduct.getGuid())) continue;
            hashMap.put(pushProduct.getGuid(), pushProduct);
        }
        return hashMap;
    }

    private void a(Context context, List<PushProduct> list) {
        for (PushProduct pushProduct : list) {
            boolean bl = false;
            Metadata metadata = this.b().findMetadataByPath(context, pushProduct.getGuid());
            if (metadata == null && StringUtils.isNotBlank((String)pushProduct.getIdString())) {
                metadata = this.b().findMetadataByHashTag(context, "", pushProduct.getIdString());
            }
            if (Metadata.isValid(metadata)) {
                File file = new File(metadata.getNativeAbsolutePath());
                bl = file.exists();
            }
            pushProduct.isFiLeExist = bl;
        }
    }

    private void a(List<PushProduct> list, String string2) {
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        for (PushProduct pushProduct : list) {
            Link link = pushProduct.getFirstDownloadLink();
            if (link == null) {
                link = new Link();
            }
            pushProduct.linkData = link;
        }
    }

    private List<PushProduct> a() {
        int n = 0;
        int n2 = 1000;
        if (this.c != null) {
            n = this.c.offset;
            n2 = this.c.count;
        }
        return SQLite.select((IProperty[])new IProperty[0]).from(PushProduct.class).limit(n2).offset(n).orderBy(OrderBy.fromProperty(PushProduct_Table.createdAt).descending()).queryList();
    }

    private DataProviderBase b() {
        return DataProviderManager.getRemoteDataProvider();
    }
}

