/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.provider;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.util.Log;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.QueryResult;
import com.onyx.android.sdk.data.compatability.OnyxThumbnail;
import com.onyx.android.sdk.data.db.table.OnyxAnnotationProvider;
import com.onyx.android.sdk.data.db.table.OnyxBookmarkProvider;
import com.onyx.android.sdk.data.db.table.OnyxLibraryProvider;
import com.onyx.android.sdk.data.db.table.OnyxMetadataCollectionProvider;
import com.onyx.android.sdk.data.db.table.OnyxMetadataProvider;
import com.onyx.android.sdk.data.db.table.OnyxSearchHistoryProvider;
import com.onyx.android.sdk.data.db.table.OnyxThumbnailProvider;
import com.onyx.android.sdk.data.model.Annotation;
import com.onyx.android.sdk.data.model.Annotation_Table;
import com.onyx.android.sdk.data.model.Bookmark;
import com.onyx.android.sdk.data.model.Bookmark_Table;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Library_Table;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.MetadataCollection;
import com.onyx.android.sdk.data.model.MetadataCollection_Table;
import com.onyx.android.sdk.data.model.Metadata_Table;
import com.onyx.android.sdk.data.model.SearchHistory;
import com.onyx.android.sdk.data.model.Thumbnail;
import com.onyx.android.sdk.data.model.Thumbnail_Table;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.utils.MetadataUtils;
import com.onyx.android.sdk.data.utils.QueryBuilder;
import com.onyx.android.sdk.utils.BitmapUtils;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.Debug;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.Operator;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.structure.provider.ContentUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class RemoteDataProvider
implements DataProviderBase {
    private static final String a = RemoteDataProvider.class.getSimpleName();

    @Override
    public void clearMetadata() {
        FlowManager.getContext().getContentResolver().delete(OnyxMetadataProvider.CONTENT_URI, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Metadata findMetadataByIdString(Context context, String idString) {
        Metadata metadata = null;
        try {
            metadata = (Metadata)((Object)ContentUtils.querySingle((Uri)OnyxMetadataProvider.CONTENT_URI, Metadata.class, (OperatorGroup)OperatorGroup.clause().and((SQLOperator)Metadata_Table.idString.eq((Object)idString)), null, (String[])new String[0]));
            return MetadataUtils.ensureObject(metadata);
        }
        catch (Exception exception) {
            try {
                Debug.e((Throwable)exception);
            }
            catch (Throwable throwable) {}
        }
        finally {
            return MetadataUtils.ensureObject(metadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Metadata findMetadataByCloudId(String cloudId) {
        Metadata metadata = null;
        try {
            metadata = (Metadata)((Object)ContentUtils.querySingle((Uri)OnyxMetadataProvider.CONTENT_URI, Metadata.class, (OperatorGroup)OperatorGroup.clause().and((SQLOperator)Metadata_Table.cloudId.eq((Object)cloudId)), null, (String[])new String[0]));
            return MetadataUtils.ensureObject(metadata);
        }
        catch (Exception exception) {
            try {
                Debug.e((Throwable)exception);
            }
            catch (Throwable throwable) {}
        }
        finally {
            return MetadataUtils.ensureObject(metadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Metadata findMetadataByPath(Context context, String path) {
        Metadata metadata = null;
        try {
            metadata = (Metadata)((Object)ContentUtils.querySingle((Uri)OnyxMetadataProvider.CONTENT_URI, Metadata.class, (OperatorGroup)OperatorGroup.clause().and((SQLOperator)Metadata_Table.nativeAbsolutePath.eq((Object)path)), null, (String[])new String[0]));
            return MetadataUtils.ensureObject(metadata);
        }
        catch (Exception exception) {
            try {
                Debug.e((Throwable)exception);
            }
            catch (Throwable throwable) {}
        }
        finally {
            return MetadataUtils.ensureObject(metadata);
        }
    }

    @Override
    public void saveMetadata(Context context, Metadata metadata) {
        metadata.beforeSave();
        Metadata metadata2 = this.findMetadataByHashTag(context, metadata.getNativeAbsolutePath(), metadata.getHashTag());
        if (!metadata2.hasValidId()) {
            if (this.a(metadata)) {
                return;
            }
            Uri uri = ContentUtils.insert((Uri)OnyxMetadataProvider.CONTENT_URI, (Object)((Object)metadata));
            if (uri == null) {
                Debug.e((String)("saveMetadata insert failure, file path: " + metadata.getNativeAbsolutePath()));
            }
        } else {
            int n = ContentUtils.update((Uri)OnyxMetadataProvider.CONTENT_URI, (Object)((Object)metadata));
            if (n <= 0) {
                Debug.e((String)("saveMetadata update failure, current file path: " + metadata.getNativeAbsolutePath() + ", findMeta file path: " + metadata2.getNativeAbsolutePath()));
            }
        }
    }

    @Override
    public void insertMetadata(Context context, Metadata metadata) {
        if (this.a(metadata)) {
            return;
        }
        metadata.beforeSave();
        if (ContentUtils.insert((Uri)OnyxMetadataProvider.CONTENT_URI, (Object)((Object)metadata)) == null) {
            Debug.e((String)("insertMetadata insert failure, file path: " + metadata.getNativeAbsolutePath()));
        }
    }

    @Override
    public void updateMetadata(Context context, Metadata metadata) {
        if (this.a(metadata)) {
            return;
        }
        metadata.beforeSave();
        if (ContentUtils.update((Uri)OnyxMetadataProvider.CONTENT_URI, (Object)((Object)metadata)) <= 0) {
            Debug.e((String)("updateMetadata update failure, file path: " + metadata.getNativeAbsolutePath()));
        }
    }

    @Override
    public void updateMetadata(Context context, ContentValues values, String where, String[] selectionArgs) {
        try {
            FlowManager.getContext().getContentResolver().update(OnyxMetadataProvider.CONTENT_URI, values, where, selectionArgs);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean a(Metadata metadata) {
        if (metadata.hasValidPath()) {
            return false;
        }
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("saveMetadata error , file absolute path is empty");
        Debug.e((Throwable)illegalArgumentException);
        return true;
    }

    public boolean insert(Metadata metadata) {
        if (this.a(metadata)) {
            return false;
        }
        metadata.beforeSave();
        return ContentUtils.insert((Uri)OnyxMetadataProvider.CONTENT_URI, (Object)((Object)metadata)) != null;
    }

    @Override
    public QueryResult<Metadata> findMetadataResultByQueryArgs(Context context, QueryArgs queryArgs) {
        QueryResult<Metadata> queryResult = new QueryResult<Metadata>();
        queryResult.list = this.findMetadataByQueryArgs(context, queryArgs);
        queryResult.count = this.count(context, queryArgs);
        return queryResult;
    }

    @Override
    public List<Metadata> findMetadataByQueryArgs(Context context, QueryArgs queryArgs) {
        return ContentUtils.queryList((Uri)OnyxMetadataProvider.CONTENT_URI, Metadata.class, (OperatorGroup)queryArgs.conditionGroup, (String)queryArgs.getOrderByQueryWithLimitOffset(), (String[])queryArgs.getProjectionSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Metadata findMetadataByHashTag(Context context, String path, String hashTag) {
        Metadata metadata = null;
        try {
            if (StringUtils.isNullOrEmpty((String)hashTag)) {
                hashTag = FileUtils.computeMD5((File)new File(path));
            }
            metadata = (Metadata)((Object)ContentUtils.querySingle((Uri)OnyxMetadataProvider.CONTENT_URI, Metadata.class, (OperatorGroup)OperatorGroup.clause().or((SQLOperator)Metadata_Table.hashTag.eq((Object)hashTag)).or((SQLOperator)Metadata_Table.nativeAbsolutePath.eq((Object)path)), null, (String[])new String[0]));
            return MetadataUtils.ensureObject(metadata);
        }
        catch (Exception exception) {
            try {
                Debug.e((Throwable)exception);
            }
            catch (Throwable throwable) {}
        }
        finally {
            return MetadataUtils.ensureObject(metadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Metadata findMetadataByHashTag(Context context, String hashTag) {
        Metadata metadata = null;
        try {
            if (!StringUtils.isNullOrEmpty((String)hashTag)) {
                metadata = (Metadata)((Object)ContentUtils.querySingle((Uri)OnyxMetadataProvider.CONTENT_URI, Metadata.class, (OperatorGroup)OperatorGroup.clause().or((SQLOperator)Metadata_Table.hashTag.eq((Object)hashTag)), null, (String[])new String[0]));
                return metadata;
            }
        }
        catch (Exception exception) {
            Debug.e((Throwable)exception);
        }
        finally {
            return MetadataUtils.ensureObject(metadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(Context context, QueryArgs queryArgs) {
        Cursor cursor;
        block3: {
            long l;
            cursor = null;
            try {
                cursor = FlowManager.getContext().getContentResolver().query(OnyxMetadataProvider.CONTENT_URI, queryArgs.getProjectionSet(), queryArgs.conditionGroup.getQuery(), null, null);
                if (cursor != null) break block3;
                Log.w((String)a, (String)"queryArgs count cursor null");
                l = 0L;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(cursor);
                throw throwable;
            }
            FileUtils.closeQuietly((Cursor)cursor);
            return l;
        }
        long l = cursor.getCount();
        FileUtils.closeQuietly((Cursor)cursor);
        return l;
    }

    @Override
    public void removeMetadata(Context context, Metadata metadata) {
        ContentUtils.delete((Uri)OnyxMetadataProvider.CONTENT_URI, (Object)((Object)metadata));
    }

    @Override
    public boolean saveDocumentOptions(Context context, String path, String associationId, String json) {
        try {
            Metadata metadata = this.findMetadataByHashTag(context, path, associationId);
            metadata.setExtraAttributes(json);
            metadata.beforeSave();
            if (!metadata.hasValidId()) {
                Metadata.getBasicMetadataFromFile(metadata, new File(path));
                metadata.setHashTag(associationId);
                ContentUtils.insert((Uri)OnyxMetadataProvider.CONTENT_URI, (Object)((Object)metadata));
            } else {
                ContentUtils.update((Uri)OnyxMetadataProvider.CONTENT_URI, (Object)((Object)metadata));
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public List<Annotation> loadAnnotations(String application, String associationId, int pageNumber, OrderBy orderBy) {
        OperatorGroup operatorGroup = OperatorGroup.clause().and((SQLOperator)Annotation_Table.idString.eq((Object)associationId)).and((SQLOperator)Annotation_Table.pageNumber.eq((Object)pageNumber));
        return ContentUtils.queryList((Uri)OnyxAnnotationProvider.CONTENT_URI, Annotation.class, (OperatorGroup)operatorGroup, (String)orderBy.getQuery(), (String[])new String[0]);
    }

    public List<Annotation> loadAnnotations(String associationId) {
        OperatorGroup operatorGroup = OperatorGroup.clause().and((SQLOperator)Annotation_Table.idString.eq((Object)associationId));
        return ContentUtils.queryList((Uri)OnyxAnnotationProvider.CONTENT_URI, Annotation.class, (OperatorGroup)operatorGroup, null, (String[])new String[0]);
    }

    @Override
    public List<Annotation> loadAnnotations(String application, String associationId, OrderBy orderBy) {
        OperatorGroup operatorGroup = OperatorGroup.clause().and((SQLOperator)Annotation_Table.idString.eq((Object)associationId));
        return ContentUtils.queryList((Uri)OnyxAnnotationProvider.CONTENT_URI, Annotation.class, (OperatorGroup)operatorGroup, (String)orderBy.getQuery(), (String[])new String[0]);
    }

    @Override
    public void addAnnotation(Annotation annotation) {
        annotation.beforeSave();
        ContentUtils.insert((Uri)OnyxAnnotationProvider.CONTENT_URI, (Object)((Object)annotation));
    }

    @Override
    public void updateAnnotation(Annotation annotation) {
        annotation.beforeSave();
        ContentUtils.update((Uri)OnyxAnnotationProvider.CONTENT_URI, (Object)((Object)annotation));
    }

    @Override
    public void deleteAnnotation(Annotation annotation) {
        ContentUtils.delete((Uri)OnyxAnnotationProvider.CONTENT_URI, (Object)((Object)annotation));
    }

    @Override
    public Bookmark loadBookmark(String application, String associationId, int pageNumber) {
        OperatorGroup operatorGroup = OperatorGroup.clause().and((SQLOperator)Bookmark_Table.idString.eq((Object)associationId)).and((SQLOperator)Bookmark_Table.pageNumber.eq((Object)pageNumber));
        return (Bookmark)((Object)ContentUtils.querySingle((Uri)OnyxBookmarkProvider.CONTENT_URI, Bookmark.class, (OperatorGroup)operatorGroup, null, (String[])new String[0]));
    }

    public void update(Bookmark bookmark) {
        bookmark.beforeSave();
        ContentUtils.update((Uri)OnyxBookmarkProvider.CONTENT_URI, (Object)((Object)bookmark));
    }

    @Override
    public List<Bookmark> loadBookmarks(String application, String associationId, OrderBy orderBy) {
        OperatorGroup operatorGroup = OperatorGroup.clause().and((SQLOperator)Bookmark_Table.idString.eq((Object)associationId));
        return ContentUtils.queryList((Uri)OnyxBookmarkProvider.CONTENT_URI, Bookmark.class, (OperatorGroup)operatorGroup, (String)orderBy.getQuery(), (String[])new String[0]);
    }

    public List<Bookmark> loadBookmarks(String associationId) {
        OperatorGroup operatorGroup = OperatorGroup.clause().and((SQLOperator)Bookmark_Table.idString.eq((Object)associationId));
        return ContentUtils.queryList((Uri)OnyxBookmarkProvider.CONTENT_URI, Bookmark.class, (OperatorGroup)operatorGroup, null, (String[])new String[0]);
    }

    @Override
    public void addBookmark(Bookmark bookmark) {
        bookmark.beforeSave();
        ContentUtils.insert((Uri)OnyxBookmarkProvider.CONTENT_URI, (Object)((Object)bookmark));
    }

    @Override
    public void updateBookmark(Bookmark bookmark) {
        bookmark.beforeSave();
        ContentUtils.update((Uri)OnyxBookmarkProvider.CONTENT_URI, (Object)((Object)bookmark));
    }

    @Override
    public void deleteBookmark(Bookmark bookmark) {
        ContentUtils.delete((Uri)OnyxBookmarkProvider.CONTENT_URI, (Object)((Object)bookmark));
    }

    @Override
    public Library loadLibrary(String uniqueId) {
        return (Library)((Object)ContentUtils.querySingle((Uri)OnyxLibraryProvider.CONTENT_URI, Library.class, (OperatorGroup)OperatorGroup.clause().and((SQLOperator)Library_Table.idString.eq((Object)uniqueId)), null, (String[])new String[0]));
    }

    @Override
    public QueryResult<Library> fetchAllLibrary(String parentId, QueryArgs queryArgs) {
        QueryResult<Library> queryResult = new QueryResult<Library>();
        queryResult.list = this.loadAllLibrary(parentId, queryArgs);
        queryResult.count = CollectionUtils.getSize(queryResult.list);
        return queryResult;
    }

    @Override
    public List<Library> loadAllLibrary(String parentId, QueryArgs queryArgs) {
        Operator operator = QueryBuilder.getNullOrEqualCondition(Library_Table.parentUniqueId, queryArgs.libraryUniqueId);
        QueryBuilder.andWith(queryArgs.conditionGroup, operator);
        return ContentUtils.queryList((Uri)OnyxLibraryProvider.CONTENT_URI, Library.class, (OperatorGroup)queryArgs.conditionGroup, (String)queryArgs.getOrderByQueryWithLimitOffset(), (String[])queryArgs.getProjectionSet());
    }

    @Override
    public void addLibrary(Library library) {
        library.beforeSave();
        ContentUtils.insert((Uri)OnyxLibraryProvider.CONTENT_URI, (Object)((Object)library));
    }

    @Override
    public void updateLibrary(Library library) {
        library.beforeSave();
        ContentUtils.update((Uri)OnyxLibraryProvider.CONTENT_URI, (Object)((Object)library));
    }

    @Override
    public void deleteLibrary(Library library) {
        ContentUtils.delete((Uri)OnyxLibraryProvider.CONTENT_URI, (Object)((Object)library));
    }

    @Override
    public void clearLibrary() {
        FlowManager.getContext().getContentResolver().delete(OnyxLibraryProvider.CONTENT_URI, null, null);
    }

    @Override
    public void clearThumbnails() {
        FlowManager.getContext().getContentResolver().delete(OnyxThumbnailProvider.CONTENT_URI, null, null);
    }

    @Override
    public boolean saveThumbnailEntry(Context context, Thumbnail thumbnail) {
        thumbnail.beforeSave();
        Thumbnail thumbnail2 = this.getThumbnailEntry(context, thumbnail.getIdString(), thumbnail.getThumbnailKind());
        if (thumbnail2 == null || !thumbnail2.hasValidId()) {
            return ContentUtils.insert((Uri)OnyxThumbnailProvider.CONTENT_URI, (Object)((Object)thumbnail)) != null;
        }
        thumbnail.setId(thumbnail2.getId());
        return ContentUtils.update((Uri)OnyxThumbnailProvider.CONTENT_URI, (Object)((Object)thumbnail)) > 0;
    }

    @Override
    public void updateThumbnailEntry(Context context, Thumbnail thumbnail) {
        this.update(thumbnail);
    }

    public void update(Thumbnail thumbnail) {
        thumbnail.beforeSave();
        ContentUtils.update((Uri)OnyxThumbnailProvider.CONTENT_URI, (Object)((Object)thumbnail));
    }

    @Override
    public Thumbnail getThumbnailEntry(Context context, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        OperatorGroup operatorGroup = OperatorGroup.clause().and((SQLOperator)Thumbnail_Table.thumbnailKind.eq((Object)kind)).and((SQLOperator)OperatorGroup.clause().orAll(new SQLOperator[]{Thumbnail_Table.idString.eq((Object)associationId), Thumbnail_Table.originContentPath.eq((Object)associationId)}));
        return (Thumbnail)((Object)ContentUtils.querySingle((ContentResolver)context.getContentResolver(), (Uri)OnyxThumbnailProvider.CONTENT_URI, Thumbnail.class, (OperatorGroup)operatorGroup, null, (String[])new String[0]));
    }

    @Override
    public Thumbnail getThumbnailEntry(Context context, String path, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        OperatorGroup operatorGroup = OperatorGroup.clause().and((SQLOperator)Thumbnail_Table.thumbnailKind.eq((Object)kind)).and((SQLOperator)OperatorGroup.clause().orAll(new SQLOperator[]{Thumbnail_Table.idString.eq((Object)associationId), Thumbnail_Table.originContentPath.eq((Object)path)}));
        return (Thumbnail)((Object)ContentUtils.querySingle((ContentResolver)context.getContentResolver(), (Uri)OnyxThumbnailProvider.CONTENT_URI, Thumbnail.class, (OperatorGroup)operatorGroup, null, (String[])new String[0]));
    }

    @Override
    public List<Thumbnail> getThumbnailEntry(Context context, QueryArgs queryArgs) {
        return ContentUtils.queryList((Uri)OnyxThumbnailProvider.CONTENT_URI, Thumbnail.class, (OperatorGroup)queryArgs.conditionGroup, (String)queryArgs.getOrderByQueryWithLimitOffset(), (String[])queryArgs.getProjectionSet());
    }

    @Override
    public void deleteThumbnailEntry(Thumbnail thumbnail) {
        ContentUtils.delete((Uri)OnyxThumbnailProvider.CONTENT_URI, (Object)((Object)thumbnail));
    }

    @Override
    public boolean deleteThumbnails(Context context, @NonNull OperatorGroup conditionGroup) {
        int n = FlowManager.getContext().getContentResolver().delete(OnyxThumbnailProvider.CONTENT_URI, conditionGroup.getQuery(), null);
        return n != 0;
    }

    @Override
    public boolean saveThumbnailBitmap(Context context, String associationId, OnyxThumbnail.ThumbnailKind kind, Bitmap saveBitmap) {
        return false;
    }

    @Override
    public boolean removeThumbnailBitmap(Context context, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        OperatorGroup operatorGroup = OperatorGroup.clause().and((SQLOperator)Thumbnail_Table.idString.eq((Object)associationId)).and((SQLOperator)Thumbnail_Table.thumbnailKind.eq((Object)kind));
        int n = FlowManager.getContext().getContentResolver().delete(OnyxThumbnailProvider.CONTENT_URI, operatorGroup.getQuery(), null);
        return n != 0;
    }

    @Override
    public Bitmap getThumbnailBitmap(Context context, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        Thumbnail thumbnail = this.getThumbnailEntry(context, associationId, kind);
        if (thumbnail == null || StringUtils.isNullOrEmpty((String)thumbnail.getImageDataPath())) {
            return null;
        }
        return BitmapUtils.loadBitmapFromFile((String)thumbnail.getImageDataPath());
    }

    public List<Thumbnail> loadThumbnail(Context context, String associationId) {
        OperatorGroup operatorGroup = OperatorGroup.clause().and((SQLOperator)Thumbnail_Table.idString.eq((Object)associationId));
        return ContentUtils.queryList((ContentResolver)context.getContentResolver(), (Uri)OnyxThumbnailProvider.CONTENT_URI, Thumbnail.class, (OperatorGroup)operatorGroup, null, (String[])new String[0]);
    }

    @Override
    public void clearMetadataCollection() {
        FlowManager.getContext().getContentResolver().delete(OnyxMetadataCollectionProvider.CONTENT_URI, null, null);
    }

    @Override
    public void addMetadataCollection(Context context, MetadataCollection collection) {
        collection.beforeSave();
        ContentUtils.insert((Uri)OnyxMetadataCollectionProvider.CONTENT_URI, (Object)((Object)collection));
    }

    @Override
    public void deleteMetadataCollection(Context context, String libraryUniqueId, String associationId) {
        if (StringUtils.isNullOrEmpty((String)associationId)) {
            return;
        }
        OperatorGroup operatorGroup = OperatorGroup.clause().and((SQLOperator)MetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId));
        operatorGroup.and((SQLOperator)MetadataCollection_Table.documentUniqueId.eq((Object)associationId));
        FlowManager.getContext().getContentResolver().delete(OnyxMetadataCollectionProvider.CONTENT_URI, operatorGroup.getQuery(), null);
    }

    @Override
    public void deleteMetadataCollection(Context context, String libraryUniqueId) {
        FlowManager.getContext().getContentResolver().delete(OnyxMetadataCollectionProvider.CONTENT_URI, OperatorGroup.clause().and((SQLOperator)MetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId)).getQuery(), null);
    }

    @Override
    public void deleteMetadataCollection(Context context, OperatorGroup operator) {
        FlowManager.getContext().getContentResolver().delete(OnyxMetadataCollectionProvider.CONTENT_URI, operator.getQuery(), null);
    }

    @Override
    public void deleteMetadataCollectionByDocId(Context context, String docId) {
        FlowManager.getContext().getContentResolver().delete(OnyxMetadataCollectionProvider.CONTENT_URI, OperatorGroup.clause().and((SQLOperator)MetadataCollection_Table.documentUniqueId.eq((Object)docId)).getQuery(), null);
    }

    @Override
    public void updateMetadataCollection(MetadataCollection collection) {
        collection.beforeSave();
        ContentUtils.update((Uri)OnyxMetadataCollectionProvider.CONTENT_URI, (Object)((Object)collection));
    }

    @Override
    public MetadataCollection loadMetadataCollection(Context context, String libraryUniqueId, String associationId) {
        OperatorGroup operatorGroup = OperatorGroup.clause().and((SQLOperator)MetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId)).and((SQLOperator)MetadataCollection_Table.documentUniqueId.eq((Object)associationId));
        return (MetadataCollection)((Object)ContentUtils.querySingle((Uri)OnyxMetadataCollectionProvider.CONTENT_URI, MetadataCollection.class, (OperatorGroup)operatorGroup, null, (String[])new String[0]));
    }

    @Override
    public List<MetadataCollection> loadMetadataCollection(Context context, String libraryUniqueId) {
        OperatorGroup operatorGroup = OperatorGroup.clause().and((SQLOperator)MetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId));
        return ContentUtils.queryList((Uri)OnyxMetadataCollectionProvider.CONTENT_URI, MetadataCollection.class, (OperatorGroup)operatorGroup, null, (String[])new String[0]);
    }

    @Override
    public MetadataCollection findMetadataCollection(Context context, String associationId) {
        OperatorGroup operatorGroup = OperatorGroup.clause().and((SQLOperator)MetadataCollection_Table.documentUniqueId.eq((Object)associationId));
        return (MetadataCollection)((Object)ContentUtils.querySingle((Uri)OnyxMetadataCollectionProvider.CONTENT_URI, MetadataCollection.class, (OperatorGroup)operatorGroup, null, (String[])new String[0]));
    }

    @Override
    public boolean moveMetadataCollection(String fromLibraryId, String toLibraryId, List<Metadata> metadataList) {
        Log.i((String)a, (String)("moveMetadataCollection, total:" + CollectionUtils.getSize(metadataList)));
        if (CollectionUtils.isNullOrEmpty(metadataList) || StringUtils.safelyEquals((String)fromLibraryId, (String)toLibraryId)) {
            return false;
        }
        if (StringUtils.isNullOrEmpty((String)toLibraryId)) {
            return this.a(metadataList);
        }
        if (StringUtils.isNullOrEmpty((String)fromLibraryId)) {
            return this.a(toLibraryId, metadataList);
        }
        return this.a(fromLibraryId, toLibraryId, metadataList);
    }

    private boolean a(List<Metadata> list) {
        StringBuilder stringBuilder = new StringBuilder(MetadataCollection_Table.documentUniqueId.getNameAlias().getNameAsKey());
        String[] stringArray = new String[CollectionUtils.getSize(list)];
        this.a(stringBuilder, list, stringArray);
        int n = FlowManager.getContext().getContentResolver().delete(OnyxMetadataCollectionProvider.CONTENT_URI, stringBuilder.toString(), stringArray);
        return n > 0;
    }

    private boolean a(String string2, List<Metadata> list) {
        ArrayList<MetadataCollection> arrayList = new ArrayList<MetadataCollection>();
        for (Metadata metadata : list) {
            arrayList.add(MetadataCollection.create(metadata.getIdString(), string2));
        }
        int n = ContentUtils.bulkInsert((Uri)OnyxMetadataCollectionProvider.CONTENT_URI, MetadataCollection.class, arrayList);
        return CollectionUtils.getSize(arrayList) == n;
    }

    private boolean a(String string2, String string3, List<Metadata> list) {
        char c = '\'';
        ContentValues contentValues = new ContentValues();
        contentValues.put(MetadataCollection_Table.libraryUniqueId.getNameAlias().getNameAsKey(), string3);
        StringBuilder stringBuilder = new StringBuilder(MetadataCollection_Table.libraryUniqueId.getNameAlias().getNameAsKey() + "=" + c + string2 + c);
        stringBuilder.append(" AND ").append(MetadataCollection_Table.documentUniqueId.getNameAlias().getNameAsKey());
        String[] stringArray = new String[CollectionUtils.getSize(list)];
        this.a(stringBuilder, list, stringArray);
        int n = FlowManager.getContext().getContentResolver().update(OnyxMetadataCollectionProvider.CONTENT_URI, contentValues, stringBuilder.toString(), stringArray);
        return n > 0;
    }

    private void a(StringBuilder stringBuilder, List<Metadata> list, String[] stringArray) {
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                stringBuilder.append(" IN (?");
            } else {
                stringBuilder.append(",?");
            }
            stringArray[i] = list.get(i).getIdString();
        }
        stringBuilder.append(")");
    }

    @Override
    public long libraryCount(String parentUniqueId) {
        Operator operator = QueryBuilder.getNullOrEqualCondition(Library_Table.parentUniqueId, parentUniqueId);
        return ContentUtils.queryList((Uri)OnyxLibraryProvider.CONTENT_URI, Library.class, (OperatorGroup)OperatorGroup.clause().and((SQLOperator)operator), null, (String[])new String[0]).size();
    }

    @Override
    public long libraryCount(QueryArgs queryArgs) {
        QueryBuilder.andWith(queryArgs.conditionGroup, QueryBuilder.getNullOrEqualCondition(Library_Table.parentUniqueId, queryArgs.libraryUniqueId));
        return ContentUtils.queryList((Uri)OnyxLibraryProvider.CONTENT_URI, Library.class, (OperatorGroup)queryArgs.conditionGroup, null, (String[])new String[0]).size();
    }

    @Override
    public void clearMetadata(QueryArgs queryArgs) {
        FlowManager.getContext().getContentResolver().delete(OnyxMetadataProvider.CONTENT_URI, queryArgs.conditionGroup.getQuery(), queryArgs.getProjectionSet());
    }

    @Override
    public boolean bulkInsertMetadata(List<Metadata> metadataList) {
        if (CollectionUtils.isNullOrEmpty(metadataList)) {
            return false;
        }
        int n = ContentUtils.bulkInsert((Uri)OnyxMetadataProvider.CONTENT_URI, Metadata.class, metadataList);
        return CollectionUtils.getSize(metadataList) == n;
    }

    public List<SearchHistory> loadSearchHistories(String associationId) {
        OperatorGroup operatorGroup = OperatorGroup.clause().and((SQLOperator)Annotation_Table.idString.eq((Object)associationId));
        return ContentUtils.queryList((Uri)OnyxSearchHistoryProvider.CONTENT_URI, SearchHistory.class, (OperatorGroup)operatorGroup, null, (String[])new String[0]);
    }

    public void update(SearchHistory searchHistory) {
        searchHistory.beforeSave();
        ContentUtils.update((Uri)OnyxSearchHistoryProvider.CONTENT_URI, (Object)((Object)searchHistory));
    }
}

