/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.provider;

import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.QueryResult;
import com.onyx.android.sdk.data.common.ContentException;
import com.onyx.android.sdk.data.compatability.OnyxThumbnail;
import com.onyx.android.sdk.data.converter.QueryArgsFilter;
import com.onyx.android.sdk.data.db.ContentDatabase;
import com.onyx.android.sdk.data.db.table.OnyxThumbnailProvider;
import com.onyx.android.sdk.data.model.Annotation;
import com.onyx.android.sdk.data.model.Bookmark;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.MetadataCollection;
import com.onyx.android.sdk.data.model.ProductResult;
import com.onyx.android.sdk.data.model.Thumbnail;
import com.onyx.android.sdk.data.model.Thumbnail_Table;
import com.onyx.android.sdk.data.model.common.FetchPolicy;
import com.onyx.android.sdk.data.model.v2.CloudLibrary;
import com.onyx.android.sdk.data.model.v2.CloudLibrary_Table;
import com.onyx.android.sdk.data.model.v2.CloudMetadata;
import com.onyx.android.sdk.data.model.v2.CloudMetadataCollection;
import com.onyx.android.sdk.data.model.v2.CloudMetadataCollection_Table;
import com.onyx.android.sdk.data.model.v2.CloudMetadata_Table;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.utils.CloudConf;
import com.onyx.android.sdk.data.utils.MetadataUtils;
import com.onyx.android.sdk.data.utils.RetrofitUtils;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.data.v2.ContentService;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.NetworkUtil;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.Delete;
import com.raizlabs.android.dbflow.sql.language.Method;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.Where;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.raizlabs.android.dbflow.structure.provider.ContentUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import retrofit2.Response;

public class CloudDataProvider
implements DataProviderBase {
    private static final String a = CloudDataProvider.class.getSimpleName();
    private CloudConf b;

    public CloudDataProvider(CloudConf conf) {
        this.b = conf;
    }

    public void setCloudConf(CloudConf cloudConf) {
        this.b = cloudConf;
    }

    @Override
    public void clearMetadata() {
        Delete.table(CloudMetadata.class, (SQLOperator[])new SQLOperator[0]);
    }

    @Override
    public void saveMetadata(Context context, Metadata metadata) {
        metadata.beforeSave();
        Metadata metadata2 = this.a(metadata.getCloudId());
        metadata.setId(metadata2.getId());
        metadata.save();
    }

    @Override
    public void insertMetadata(Context context, Metadata metadata) {
        metadata.beforeSave();
        Metadata metadata2 = this.a(metadata.getCloudId());
        metadata.setId(metadata2.getId());
        metadata.insert();
    }

    @Override
    public void updateMetadata(Context context, Metadata metadata) {
        metadata.beforeSave();
        Metadata metadata2 = this.a(metadata.getCloudId());
        metadata.setId(metadata2.getId());
        metadata.update();
    }

    @Override
    public void updateMetadata(Context context, ContentValues values, String where, String[] selectionArgs) {
    }

    private Metadata a(String string2) {
        Metadata metadata = (Metadata)((Object)new Select(new IProperty[0]).from(CloudMetadata.class).where(new SQLOperator[]{CloudMetadata_Table.cloudId.eq((Object)string2)}).querySingle());
        return MetadataUtils.ensureObject(metadata);
    }

    private List<Metadata> a(Context context, QueryArgs queryArgs) {
        if (queryArgs.conditionGroup != null) {
            Where where = new Select(queryArgs.propertyList.toArray(new IProperty[0])).from(CloudMetadata.class).where(new SQLOperator[]{queryArgs.conditionGroup});
            for (OrderBy object2 : queryArgs.orderByList) {
                where.orderBy(object2);
            }
            List list = where.offset(queryArgs.offset).limit(queryArgs.limit).queryList();
            ArrayList<Metadata> arrayList = new ArrayList<Metadata>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                CloudMetadata cloudMetadata = (CloudMetadata)((Object)iterator.next());
                arrayList.add(cloudMetadata);
            }
            return arrayList;
        }
        return new ArrayList<Metadata>();
    }

    private long b(Context context, QueryArgs queryArgs) {
        return new Select(new IProperty[]{Method.count((IProperty[])new IProperty[0])}).from(CloudMetadata.class).where(new SQLOperator[]{queryArgs.conditionGroup}).count();
    }

    private QueryResult<Metadata> c(Context context, QueryArgs queryArgs) {
        QueryResult<Metadata> queryResult = new QueryResult<Metadata>();
        queryResult.list = this.a(context, queryArgs);
        queryResult.count = this.b(context, queryArgs);
        queryResult.fetchSource = 0;
        return queryResult;
    }

    private QueryResult<Metadata> d(Context context, QueryArgs queryArgs) {
        QueryResult<Metadata> queryResult;
        block4: {
            queryResult = new QueryResult<Metadata>();
            try {
                Response<ProductResult<CloudMetadata>> response = RetrofitUtils.executeCall(this.a().loadBookList(queryArgs.libraryUniqueId, JSON.toJSONString((Object)queryArgs, (SerializeFilter)new QueryArgsFilter(), (SerializerFeature[])new SerializerFeature[0])));
                if (response.isSuccessful()) {
                    queryResult.list = new ArrayList();
                    for (Metadata metadata : ((ProductResult)response.body()).list) {
                        queryResult.list.add(metadata);
                    }
                    queryResult.count = ((ProductResult)response.body()).count;
                    queryResult.fetchSource = 1;
                }
                this.a(queryResult);
            }
            catch (Exception exception) {
                queryResult.setException(ContentException.createException(exception));
                if (FetchPolicy.isCloudOnlyPolicy(queryArgs.fetchPolicy) || FetchPolicy.isMemDbCloudPolicy(queryArgs.fetchPolicy)) break block4;
                queryResult = this.c(context, queryArgs);
            }
        }
        return queryResult;
    }

    private void a(QueryResult<Metadata> queryResult) {
        if (queryResult == null || queryResult.count <= 0L || CollectionUtils.isNullOrEmpty(queryResult.list)) {
            Log.w((String)a, (String)"detect cloud metadata is empty");
        }
    }

    @Override
    public QueryResult<Metadata> findMetadataResultByQueryArgs(Context context, QueryArgs queryArgs) {
        QueryResult<Metadata> queryResult;
        if (FetchPolicy.isCloudPartPolicy(queryArgs.fetchPolicy)) {
            queryResult = this.d(context, queryArgs);
        } else {
            queryResult = this.c(context, queryArgs);
            if (FetchPolicy.isMemDbCloudPolicy(queryArgs.fetchPolicy) && queryResult.isContentEmpty()) {
                queryResult = this.d(context, queryArgs);
            }
        }
        return queryResult;
    }

    @Override
    public List<Metadata> findMetadataByQueryArgs(Context context, QueryArgs queryArgs) {
        QueryResult<Metadata> queryResult = this.findMetadataResultByQueryArgs(context, queryArgs);
        return queryResult.getEnsureList();
    }

    @Override
    public Metadata findMetadataByIdString(Context context, String idString) {
        return null;
    }

    @Override
    public Metadata findMetadataByPath(Context context, String path) {
        return null;
    }

    @Override
    public Metadata findMetadataByHashTag(Context context, String path, String hashTag) {
        return null;
    }

    @Override
    public Metadata findMetadataByHashTag(Context context, String hashTag) {
        return null;
    }

    @Override
    public long count(Context context, QueryArgs queryArgs) {
        long l = NetworkUtil.isWiFiConnected((Context)context) ? this.findMetadataResultByQueryArgs((Context)context, (QueryArgs)queryArgs).count : this.b(context, queryArgs);
        return l;
    }

    @Override
    public void removeMetadata(Context context, Metadata metadata) {
        metadata.delete();
    }

    @Override
    public boolean saveDocumentOptions(Context context, String path, String associationId, String json) {
        return false;
    }

    @Override
    public List<Annotation> loadAnnotations(String application, String associationId, int pageNumber, OrderBy orderBy) {
        return null;
    }

    @Override
    public List<Annotation> loadAnnotations(String application, String associationId, OrderBy orderBy) {
        return null;
    }

    @Override
    public void addAnnotation(Annotation annotation) {
    }

    @Override
    public void updateAnnotation(Annotation annotation) {
    }

    @Override
    public void deleteAnnotation(Annotation annotation) {
    }

    @Override
    public Bookmark loadBookmark(String application, String associationId, int pageNumber) {
        return null;
    }

    @Override
    public List<Bookmark> loadBookmarks(String application, String associationId, OrderBy orderBy) {
        return null;
    }

    @Override
    public void addBookmark(Bookmark bookmark) {
    }

    @Override
    public void updateBookmark(Bookmark bookmark) {
    }

    @Override
    public void deleteBookmark(Bookmark bookmark) {
    }

    @Override
    public Library loadLibrary(String uniqueId) {
        return (Library)((Object)new Select(new IProperty[0]).from(CloudLibrary.class).where(new SQLOperator[0]).and((SQLOperator)CloudLibrary_Table.idString.eq((Object)uniqueId)).querySingle());
    }

    @Override
    public QueryResult<Library> fetchAllLibrary(String parentId, QueryArgs queryArgs) {
        QueryResult<Library> queryResult;
        if (FetchPolicy.isCloudPartPolicy(queryArgs.fetchPolicy)) {
            queryResult = this.fetchLibraryListFromCloud(queryArgs.libraryUniqueId, queryArgs);
        } else {
            queryResult = this.fetchLibraryListFromLocal(queryArgs.libraryUniqueId);
            if (FetchPolicy.isMemDbCloudPolicy(queryArgs.fetchPolicy) && !QueryResult.isValidQueryResult(queryResult)) {
                queryResult = this.fetchLibraryListFromCloud(queryArgs.libraryUniqueId, queryArgs);
            }
        }
        return queryResult;
    }

    @Override
    public List<Library> loadAllLibrary(String parentId, QueryArgs queryArgs) {
        QueryResult<Library> queryResult = this.fetchAllLibrary(parentId, queryArgs);
        return queryResult.getEnsureList();
    }

    public QueryResult<Library> fetchLibraryListFromCloud(String parentId, QueryArgs queryArgs) {
        QueryResult<Library> queryResult;
        block4: {
            queryResult = new QueryResult<Library>();
            try {
                Response<QueryResult<CloudLibrary>> response = RetrofitUtils.executeCall(this.a().loadLibraryList(parentId));
                if (response.isSuccessful()) {
                    queryResult.list = new ArrayList();
                    for (CloudLibrary cloudLibrary : ((QueryResult)response.body()).list) {
                        queryResult.list.add(cloudLibrary);
                    }
                    queryResult.count = ((QueryResult)response.body()).count;
                    queryResult.fetchSource = 1;
                }
            }
            catch (Exception exception) {
                if (FetchPolicy.isCloudOnlyPolicy(queryArgs.fetchPolicy) || FetchPolicy.isMemDbCloudPolicy(queryArgs.fetchPolicy)) break block4;
                queryResult = this.fetchLibraryListFromLocal(parentId);
            }
        }
        return queryResult;
    }

    public QueryResult<Library> fetchLibraryListFromLocal(String parentId) {
        QueryResult<Library> queryResult = new QueryResult<Library>();
        List list = new Select(new IProperty[0]).from(CloudLibrary.class).where(new SQLOperator[0]).and((SQLOperator)CloudLibrary_Table.parentUniqueId.eq((Object)parentId)).queryList();
        if (CollectionUtils.isNullOrEmpty((Collection)list)) {
            return queryResult;
        }
        queryResult.list = new ArrayList();
        for (CloudLibrary cloudLibrary : list) {
            queryResult.list.add(cloudLibrary);
        }
        queryResult.count = list.size();
        queryResult.fetchSource = 0;
        return queryResult;
    }

    @Override
    public void addLibrary(Library library) {
        Library library2 = this.loadLibrary(library.getIdString());
        if (library2 != null) {
            library.setId(library2.getId());
        }
        library.save();
    }

    @Override
    public void updateLibrary(Library library) {
    }

    @Override
    public void deleteLibrary(Library library) {
        library.delete();
    }

    @Override
    public void clearLibrary() {
        Delete.table(CloudLibrary.class, (SQLOperator[])new SQLOperator[0]);
    }

    @Override
    public void clearThumbnails() {
        Delete.table(Thumbnail.class, (SQLOperator[])new SQLOperator[0]);
    }

    @Override
    public boolean saveThumbnailEntry(Context context, Thumbnail thumbnail) {
        thumbnail.beforeSave();
        Thumbnail thumbnail2 = this.getThumbnailEntry(context, thumbnail.getIdString(), thumbnail.getThumbnailKind());
        if (thumbnail2 != null) {
            thumbnail.setId(thumbnail2.getId());
        }
        return thumbnail.save();
    }

    @Override
    public void updateThumbnailEntry(Context context, Thumbnail thumbnail) {
        thumbnail.beforeSave();
        ContentUtils.update((Uri)OnyxThumbnailProvider.CONTENT_URI, (Object)((Object)thumbnail));
    }

    @Override
    public Thumbnail getThumbnailEntry(Context context, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        return (Thumbnail)((Object)new Select(new IProperty[0]).from(Thumbnail.class).where(new SQLOperator[0]).and((SQLOperator)Thumbnail_Table.thumbnailKind.eq((Object)kind)).and((SQLOperator)OperatorGroup.clause().orAll(new SQLOperator[]{Thumbnail_Table.idString.eq((Object)associationId), Thumbnail_Table.originContentPath.eq((Object)associationId)})).querySingle());
    }

    @Override
    public Thumbnail getThumbnailEntry(Context context, String path, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        return (Thumbnail)((Object)new Select(new IProperty[0]).from(Thumbnail.class).where(new SQLOperator[0]).and((SQLOperator)Thumbnail_Table.thumbnailKind.eq((Object)kind)).and((SQLOperator)OperatorGroup.clause().orAll(new SQLOperator[]{Thumbnail_Table.idString.eq((Object)associationId), Thumbnail_Table.originContentPath.eq((Object)path)})).querySingle());
    }

    @Override
    public List<Thumbnail> getThumbnailEntry(Context context, QueryArgs queryArgs) {
        return new ArrayList<Thumbnail>();
    }

    @Override
    public void deleteThumbnailEntry(Thumbnail thumbnail) {
    }

    @Override
    public boolean deleteThumbnails(Context context, @NonNull OperatorGroup conditionGroup) {
        return false;
    }

    @Override
    public boolean saveThumbnailBitmap(Context context, String associationId, OnyxThumbnail.ThumbnailKind kind, Bitmap saveBitmap) {
        return false;
    }

    @Override
    public Bitmap getThumbnailBitmap(Context context, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        return null;
    }

    @Override
    public boolean removeThumbnailBitmap(Context context, String associationId, OnyxThumbnail.ThumbnailKind kind) {
        return false;
    }

    @Override
    public void clearMetadataCollection() {
        Delete.table(CloudMetadataCollection.class, (SQLOperator[])new SQLOperator[0]);
    }

    @Override
    public void addMetadataCollection(Context context, MetadataCollection collection) {
        MetadataCollection metadataCollection = this.loadMetadataCollection(context, collection.getLibraryUniqueId(), collection.getDocumentUniqueId());
        if (metadataCollection != null) {
            collection.setId(metadataCollection.getId());
        }
        collection.save();
    }

    @Override
    public void deleteMetadataCollection(Context context, String libraryUniqueId, String associationId) {
        new Delete().from(CloudMetadataCollection.class).where(new SQLOperator[]{CloudMetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId)}).and((SQLOperator)CloudMetadataCollection_Table.documentUniqueId.eq((Object)associationId)).execute();
    }

    @Override
    public void deleteMetadataCollection(Context context, String libraryUniqueId) {
        new Delete().from(CloudMetadataCollection.class).where(new SQLOperator[]{CloudMetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId)}).execute();
    }

    @Override
    public void deleteMetadataCollection(Context context, OperatorGroup operator) {
        new Delete().from(CloudMetadataCollection.class).where(new SQLOperator[]{operator}).execute();
    }

    @Override
    public void deleteMetadataCollectionByDocId(Context context, String docId) {
        new Delete().from(CloudMetadataCollection.class).where(new SQLOperator[]{CloudMetadataCollection_Table.documentUniqueId.eq((Object)docId)}).execute();
    }

    @Override
    public void updateMetadataCollection(MetadataCollection collection) {
        collection.update();
    }

    @Override
    public MetadataCollection loadMetadataCollection(Context context, String libraryUniqueId, String associationId) {
        return (MetadataCollection)((Object)new Select(new IProperty[0]).from(CloudMetadataCollection.class).where(new SQLOperator[]{CloudMetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId)}).and((SQLOperator)CloudMetadataCollection_Table.documentUniqueId.eq((Object)associationId)).querySingle());
    }

    @Override
    public List<MetadataCollection> loadMetadataCollection(Context context, String libraryUniqueId) {
        List list = new Select(new IProperty[0]).from(CloudMetadataCollection.class).where(new SQLOperator[]{CloudMetadataCollection_Table.libraryUniqueId.eq((Object)libraryUniqueId)}).queryList();
        if (CollectionUtils.isNullOrEmpty((Collection)list)) {
            return new ArrayList<MetadataCollection>();
        }
        ArrayList<MetadataCollection> arrayList = new ArrayList<MetadataCollection>();
        for (CloudMetadataCollection cloudMetadataCollection : list) {
            arrayList.add(cloudMetadataCollection);
        }
        return arrayList;
    }

    @Override
    public MetadataCollection findMetadataCollection(Context context, String associationId) {
        return (MetadataCollection)((Object)new Select(new IProperty[0]).from(CloudMetadataCollection.class).where(new SQLOperator[]{CloudMetadataCollection_Table.documentUniqueId.eq((Object)associationId)}).querySingle());
    }

    @Override
    public boolean moveMetadataCollection(String fromLibraryId, String toLibraryId, List<Metadata> metadataList) {
        return false;
    }

    @Override
    public long libraryCount(String parentUniqueId) {
        return new Select(new IProperty[]{Method.count((IProperty[])new IProperty[0])}).from(CloudLibrary.class).where(new SQLOperator[]{CloudLibrary_Table.parentUniqueId.eq((Object)parentUniqueId)}).count();
    }

    @Override
    public long libraryCount(QueryArgs queryArgs) {
        return 0L;
    }

    @Override
    public void clearMetadata(QueryArgs queryArgs) {
        Delete.table(CloudMetadata.class, (SQLOperator[])new SQLOperator[]{queryArgs.conditionGroup});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean bulkInsertMetadata(List<Metadata> metadataList) {
        if (CollectionUtils.isNullOrEmpty(metadataList)) {
            return false;
        }
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase(ContentDatabase.class).getWritableDatabase();
        databaseWrapper.beginTransaction();
        try {
            for (Metadata metadata : metadataList) {
                metadata.insert();
            }
            databaseWrapper.setTransactionSuccessful();
        }
        finally {
            databaseWrapper.endTransaction();
        }
        return true;
    }

    private ContentService a() {
        return ServiceFactory.getContentService(this.b.getApiBase());
    }
}

