/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.newword;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import com.onyx.android.sdk.data.newword.OnyxNewWordGroupCenter;
import com.onyx.android.sdk.data.newword.OnyxNewWordGroupItem;
import com.onyx.android.sdk.data.newword.OnyxNewWordItem;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class OnyxNewWordCenter {
    public static final String TAG = OnyxNewWordCenter.class.getSimpleName();
    public static final String PROVIDER_AUTHORITY = "com.onyx.android.sdk.OnyxNewWordProvider";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean insert(Context context, OnyxNewWordItem item) {
        Object object;
        if (item != null && StringUtils.isNullOrEmpty((String)(object = item.getSaveDate()))) {
            return false;
        }
        object = OnyxNewWordGroupCenter.getCurrentGroup(context, 1);
        if (object != null) {
            item.setGroup(((OnyxNewWordGroupItem)object).getGroup());
        }
        Cursor cursor = null;
        try {
            String[] stringArray = new String[]{item.getNewWord()};
            cursor = context.getContentResolver().query(OnyxNewWordItem.CONTENT_URI, null, "new_word=?", stringArray, null);
            if (cursor != null && cursor.moveToFirst()) {
                int n = cursor.getColumnIndex("_id");
                item.setId(n);
                context.getContentResolver().update(OnyxNewWordItem.CONTENT_URI, OnyxNewWordItem.Columns.createColumnData(item), "new_word=?", stringArray);
            } else {
                Uri uri = context.getContentResolver().insert(OnyxNewWordItem.CONTENT_URI, OnyxNewWordItem.Columns.createColumnData(item));
                if (uri == null) {
                    FileUtils.closeQuietly((Cursor)cursor);
                    boolean bl = false;
                    FileUtils.closeQuietly((Cursor)cursor);
                    return bl;
                }
                String string2 = uri.getLastPathSegment();
                if (string2 == null) {
                    FileUtils.closeQuietly((Cursor)cursor);
                    boolean bl = false;
                    FileUtils.closeQuietly((Cursor)cursor);
                    return bl;
                }
                item.setId(Long.parseLong(string2));
            }
            FileUtils.closeQuietly((Cursor)cursor);
            return true;
        }
        catch (Exception exception) {
            Log.i((String)TAG, (String)exception.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            FileUtils.closeQuietly(cursor);
        }
    }

    public static boolean update(Context context, OnyxNewWordItem item) {
        Uri uri = Uri.withAppendedPath((Uri)OnyxNewWordItem.CONTENT_URI, (String)String.valueOf(item.getId()));
        int n = context.getContentResolver().update(uri, OnyxNewWordItem.Columns.createColumnData(item), null, null);
        if (n <= 0) {
            return false;
        }
        assert (n == 1);
        return true;
    }

    public static boolean delete(Context context, OnyxNewWordItem item) {
        Uri uri = Uri.withAppendedPath((Uri)OnyxNewWordItem.CONTENT_URI, (String)String.valueOf(item.getId()));
        int n = context.getContentResolver().delete(uri, null, null);
        if (n <= 0) {
            return false;
        }
        assert (n == 1);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OnyxNewWordItem query(Context context, String newWord) {
        OnyxNewWordItem onyxNewWordItem;
        Cursor cursor;
        block4: {
            String[] stringArray = new String[]{newWord};
            cursor = null;
            onyxNewWordItem = null;
            try {
                cursor = context.getContentResolver().query(OnyxNewWordItem.CONTENT_URI, null, "new_word=?", stringArray, null);
                if (cursor == null || !cursor.moveToFirst()) break block4;
                onyxNewWordItem = OnyxNewWordItem.Columns.readColumnData(cursor);
            }
            catch (Exception exception) {
                try {
                    Log.i((String)TAG, (String)exception.toString());
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(cursor);
                    throw throwable;
                }
                FileUtils.closeQuietly((Cursor)cursor);
            }
        }
        FileUtils.closeQuietly((Cursor)cursor);
        return onyxNewWordItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int queryGroupNewWord(Context context, String groupName, boolean isNull) {
        int n;
        Cursor cursor;
        block6: {
            String string2 = null;
            String[] stringArray = null;
            if (groupName != null) {
                string2 = "group_name=?";
                stringArray = new String[]{groupName};
            }
            if (isNull) {
                string2 = "group_name is null";
            }
            cursor = null;
            n = 0;
            try {
                cursor = context.getContentResolver().query(OnyxNewWordItem.CONTENT_URI, null, string2, stringArray, null);
                if (cursor == null || !cursor.moveToFirst()) break block6;
                n = cursor.getCount();
            }
            catch (Exception exception) {
                try {
                    Log.i((String)TAG, (String)exception.toString());
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(cursor);
                    throw throwable;
                }
                FileUtils.closeQuietly((Cursor)cursor);
            }
        }
        FileUtils.closeQuietly((Cursor)cursor);
        return n;
    }

    public static boolean clearNewWord(Context context, String startDate, String endDate) {
        int n = 0;
        if (startDate == null) {
            n = context.getContentResolver().delete(OnyxNewWordItem.CONTENT_URI, null, null);
        } else {
            String[] stringArray = new String[]{startDate, endDate};
            n = context.getContentResolver().delete(OnyxNewWordItem.CONTENT_URI, "save_data>=?  and save_data<=?", stringArray);
        }
        return n > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<OnyxNewWordItem> getAllNewWord(Context context, String groupName, boolean isNull, String sortOrder) {
        Cursor cursor;
        ArrayList<OnyxNewWordItem> arrayList;
        block7: {
            arrayList = new ArrayList<OnyxNewWordItem>();
            String string2 = null;
            String[] stringArray = null;
            if (groupName != null) {
                stringArray = new String[]{groupName};
                string2 = "group_name=?";
            }
            if (isNull) {
                string2 = "group_name is null";
            }
            cursor = null;
            try {
                cursor = context.getContentResolver().query(OnyxNewWordItem.CONTENT_URI, null, string2, stringArray, sortOrder);
                if (cursor == null || !cursor.moveToFirst()) break block7;
                do {
                    OnyxNewWordItem onyxNewWordItem = OnyxNewWordItem.Columns.readColumnData(cursor);
                    arrayList.add(onyxNewWordItem);
                } while (cursor.moveToNext());
            }
            catch (Exception exception) {
                try {
                    Log.i((String)TAG, (String)exception.toString());
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(cursor);
                    throw throwable;
                }
                FileUtils.closeQuietly((Cursor)cursor);
            }
        }
        FileUtils.closeQuietly((Cursor)cursor);
        return arrayList;
    }
}

