/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.model;

import android.text.TextUtils;
import com.alibaba.fastjson.annotation.JSONField;
import com.onyx.android.sdk.data.model.BaseData;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.annotation.ColumnIgnore;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Metadata
extends BaseData {
    public static final String PROGRESS_DIVIDER = "/";
    private String name = null;
    private String title = null;
    private String authors = null;
    private String publisher = null;
    private String language = null;
    private String ISBN = null;
    private String description = null;
    private String location = null;
    private String nativeAbsolutePath = null;
    private long size = 0L;
    private String encoding = null;
    private Date lastAccess = null;
    private Date lastModified = null;
    private String progress = null;
    private int favorite = 0;
    private int rating = 0;
    private String tags = null;
    private String series = null;
    private String extraAttributes = null;
    private String type = null;
    private String cloudId;
    private String parentId;
    private int readingStatus = 0;
    private String hashTag;
    private String storageId;
    private int fetchSource;
    private String coverUrl;
    private int ordinal;
    private String downloadInfo;
    @ColumnIgnore
    private Map<String, String> bookCovers = new HashMap<String, String>();

    public void setFetchSource(int fetchSource) {
        this.fetchSource = fetchSource;
    }

    public int getFetchSource() {
        return this.fetchSource;
    }

    public void setCoverUrl(String coverUrl) {
        this.coverUrl = coverUrl;
    }

    public String getCoverUrl() {
        return this.coverUrl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public String getAuthors() {
        return this.authors;
    }

    public void setAuthors(String a2) {
        this.authors = a2;
    }

    public List<String> getAuthorList() {
        return StringUtils.split((String)this.authors, (String)",");
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String p) {
        this.publisher = p;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String l) {
        this.language = l;
    }

    public String getISBN() {
        return this.ISBN;
    }

    public void setISBN(String value) {
        this.ISBN = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String l) {
        this.location = l;
    }

    public String getNativeAbsolutePath() {
        return this.nativeAbsolutePath;
    }

    public void setNativeAbsolutePath(String path) {
        this.nativeAbsolutePath = path;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long s) {
        this.size = s;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String e) {
        this.encoding = e;
    }

    public Date getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(Date lastAccess) {
        this.lastAccess = lastAccess;
    }

    public void updateLastAccess() {
        this.setLastAccess(new Date());
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public String getProgress() {
        return this.progress;
    }

    public void setProgress(String p) {
        this.progress = p;
    }

    public void setProgress(int currentPage, int totalPage) {
        this.setProgress(String.format(Locale.getDefault(), "%d/%d", currentPage, totalPage));
    }

    public int getFavorite() {
        return this.favorite;
    }

    public void setFavorite(int f) {
        this.favorite = f;
    }

    public int getRating() {
        return this.rating;
    }

    public void setRating(int r) {
        this.rating = r;
    }

    public String getTags() {
        return this.tags;
    }

    public List<String> getTagList() {
        return StringUtils.split((String)this.getTags(), (String)",");
    }

    public void setTags(String t) {
        this.tags = t;
    }

    public String getSeries() {
        return this.series;
    }

    public List<String> getSerieList() {
        return StringUtils.split((String)this.getSeries(), (String)",");
    }

    public void setSeries(String s) {
        this.series = s;
    }

    public String getExtraAttributes() {
        return this.extraAttributes;
    }

    public void setExtraAttributes(String e) {
        this.extraAttributes = e;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String t) {
        this.type = t;
    }

    public String getCloudId() {
        return this.cloudId;
    }

    public void setCloudId(String c) {
        this.cloudId = c;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String id) {
        this.parentId = id;
    }

    public int getReadingStatus() {
        return this.readingStatus;
    }

    public void setReadingStatus(int status) {
        this.readingStatus = status;
    }

    public String getHashTag() {
        return this.hashTag;
    }

    public void setHashTag(String hashTag) {
        this.hashTag = hashTag;
    }

    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }

    public String getStorageId() {
        return this.storageId;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public Map<String, String> getBookCovers() {
        return this.bookCovers;
    }

    public void setBookCovers(Map<String, String> coversMap) {
        this.bookCovers = coversMap;
    }

    public String getDownloadInfo() {
        return this.downloadInfo;
    }

    public void setDownloadInfo(String downloadInfo) {
        this.downloadInfo = downloadInfo;
    }

    @JSONField(deserialize=false, serialize=false)
    public String getCoverUrl(String key) {
        if (CollectionUtils.isNullOrEmpty(this.bookCovers)) {
            return null;
        }
        return this.bookCovers.get(key);
    }

    public static Metadata createFromFile(String path) {
        return Metadata.createFromFile(new File(path));
    }

    public static Metadata createFromFile(File file) {
        return Metadata.createFromFile(file, true);
    }

    public static Metadata createFromMetadataPath(Metadata metadata, boolean computeMd5) {
        File file = new File(metadata.getNativeAbsolutePath());
        try {
            if (computeMd5) {
                String string2 = FileUtils.computeMD5((File)file);
                metadata.setHashTag(string2);
            }
            Metadata.getBasicMetadataFromFile(metadata, file);
            return metadata;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Metadata createFromFile(File file, boolean computeMd5) {
        Metadata metadata = new Metadata();
        metadata.setNativeAbsolutePath(file.getAbsolutePath());
        return Metadata.createFromMetadataPath(metadata, computeMd5);
    }

    public static void getBasicMetadataFromFile(Metadata data2, File file) {
        data2.setName(file.getName());
        data2.setTitle(data2.getTitle());
        data2.setIdString(file.getAbsolutePath());
        data2.setLocation(file.getAbsolutePath());
        data2.setNativeAbsolutePath(file.getAbsolutePath());
        data2.setSize(file.length());
        data2.setLastModified(new Date(FileUtils.getLastChangeTime((File)file)));
        data2.setType(FileUtils.getFileExtension((String)file.getName()));
    }

    private int parseProgress(String progress) {
        try {
            return Integer.parseInt(progress);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public float getProgressFloatPercent() {
        if (StringUtils.isNullOrEmpty((String)this.progress)) {
            return 0.0f;
        }
        String[] stringArray = this.progress.split(PROGRESS_DIVIDER);
        if (stringArray.length != 2) {
            return 0.0f;
        }
        int n = this.parseProgress(stringArray[0]);
        int n2 = this.parseProgress(stringArray[1]);
        if (n2 == 0) {
            return 0.0f;
        }
        return (float)n * 100.0f / (float)n2;
    }

    public int getProgressPercent() {
        return (int)this.getProgressFloatPercent();
    }

    public boolean internalProgressEqual(String progress) {
        String[] stringArray = progress.split(PROGRESS_DIVIDER);
        if (stringArray.length != 2) {
            return false;
        }
        return stringArray[0].equals(stringArray[1]);
    }

    public String getAssociationId() {
        return this.getHashTag();
    }

    public boolean isFinished() {
        return this.readingStatus == ReadingStatus.FINISHED;
    }

    public boolean isReading() {
        return this.readingStatus == ReadingStatus.READING;
    }

    public boolean isNew() {
        return this.readingStatus == ReadingStatus.NEW;
    }

    public boolean hasValidPath() {
        return !TextUtils.isEmpty((CharSequence)this.getNativeAbsolutePath());
    }

    public static class FetchSource {
        public static final int LOCAL = 0;
        public static final int CLOUD = 1;
        public static final int JD_CLOUD_TRY_READ = 2;
        public static final int JD_PRESET = 3;
        public static final int ONYX_CLOUD = 4;
        public static final int JD_CLOUD = 5;
    }

    public static class ReadingStatus {
        public static int NEW = 0;
        public static int READING = 1;
        public static int FINISHED = 2;
    }
}

