/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.model;

import android.databinding.BaseObservable;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import com.facebook.common.references.CloseableReference;
import com.onyx.android.sdk.data.model.ExtensionMap;
import com.onyx.android.sdk.dataprovider.R;
import com.onyx.android.sdk.utils.DateTimeUtil;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.ResManager;
import java.io.File;
import java.util.Date;

public class FileModel
extends BaseObservable {
    public static final int TYPE_DIRECTORY = 0;
    public static final int TYPE_FILE = 1;
    public static final int TYPE_GO_UP = 2;
    public static final int TYPE_SHORTCUT = 3;
    public static final int TYPE_APK = 4;
    private File file;
    private String name;
    private String shortcutPath;
    private int type;
    private Drawable thumbnail;
    private int thumbnailResId;
    private CloseableReference<Bitmap> coverBitmap;
    private boolean canPadding = false;
    private boolean isFromLibrary = false;
    private int childFolderCount;
    private int childFileCount;
    private int selectChildCount;

    public static FileModel create(File file, Drawable thumbnail) {
        FileModel fileModel = new FileModel();
        fileModel.file = file;
        fileModel.thumbnail = thumbnail;
        fileModel.initFileType();
        return fileModel;
    }

    private void initFileType() {
        int n = this.type = this.file.isDirectory() ? 0 : 1;
        if ("apk".equals(FileUtils.getFileExtension((String)this.file.getName()))) {
            this.type = 4;
        }
    }

    public static FileModel createGoUpModel(File file, String name) {
        FileModel fileModel = new FileModel();
        fileModel.file = file;
        fileModel.type = 2;
        fileModel.name = name;
        return fileModel;
    }

    public static FileModel createShortcutModel(File file) {
        FileModel fileModel = FileModel.create(file, null);
        fileModel.type = 3;
        return fileModel;
    }

    public String getFileLastModifiedTime() {
        return DateTimeUtil.DATE_FORMAT_YYYYMMDD_HHMMSS.format(new Date(this.file.lastModified()));
    }

    public String getShortcutPath() {
        return this.shortcutPath;
    }

    public void setShortcutPath(String shortcutPath) {
        this.shortcutPath = shortcutPath;
    }

    public File getFile() {
        if (this.isShortcutType()) {
            return new File(this.shortcutPath);
        }
        return this.file;
    }

    public File getFileByType() {
        File file = this.getFile();
        if (this.isGoUpType()) {
            file = this.getFile().getParentFile();
        } else if (this.isShortcutType()) {
            file = new File(this.getShortcutPath());
        }
        return file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public Drawable getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(Drawable thumbnail) {
        this.thumbnail = thumbnail;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getChildFolderCount() {
        return this.childFolderCount;
    }

    public void setChildFolderCount(int childFolderCount) {
        this.childFolderCount = childFolderCount;
    }

    public int getChildFileCount() {
        return this.childFileCount;
    }

    public void setChildFileCount(int childFileCount) {
        this.childFileCount = childFileCount;
    }

    public int getSelectChildCount() {
        return this.selectChildCount;
    }

    public void setSelectChildCount(int selectChildCount) {
        this.selectChildCount = selectChildCount;
    }

    private void resetToFileType() {
        this.type = 1;
    }

    public void showExtensionOnCover() {
        this.resetToFileType();
    }

    public String getName() {
        if (this.name == null) {
            return this.getFileName();
        }
        return this.name;
    }

    public String getBaseName() {
        if (this.name == null) {
            return ExtensionMap.getFileName(this.getFile());
        }
        return this.name;
    }

    private String getFileName() {
        if (this.file == null) {
            return null;
        }
        return this.file.getName();
    }

    private String getFileExtension() {
        if (this.isDirectoryType()) {
            return ResManager.getString((int)R.string.folder);
        }
        if (this.isShortcutType()) {
            return ResManager.getString((int)R.string.short_cut);
        }
        return FileUtils.getFileExtension((String)this.getName());
    }

    public String getExtension() {
        String string2 = this.getFileExtension();
        return ExtensionMap.getExtension(string2.toUpperCase());
    }

    public String lastModified() {
        String string2 = "";
        if (!this.isShortcutType()) {
            string2 = this.file == null ? "" : DateTimeUtil.DATE_FORMAT_YYYYMMDD_HHMM.format(this.file.lastModified());
        }
        return string2;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isGoUpType() {
        return this.getType() == 2;
    }

    public boolean isFileType() {
        return this.getType() == 1;
    }

    public boolean isDirectoryType() {
        return this.getType() == 0;
    }

    public boolean isShortcutType() {
        return this.getType() == 3;
    }

    public boolean isApkType() {
        return this.getType() == 4;
    }

    public int getThumbnailResId() {
        return this.thumbnailResId;
    }

    public void setThumbnailResId(int thumbnailResId) {
        this.thumbnailResId = thumbnailResId;
    }

    public Bitmap getCoverBitmap() {
        return this.isCoverBitmapValid() ? (Bitmap)this.coverBitmap.get() : null;
    }

    public CloseableReference<Bitmap> getRefCoverBitmap() {
        return this.coverBitmap;
    }

    public void setRefCoverBitmap(CloseableReference<Bitmap> bitmap) {
        this.coverBitmap = bitmap;
        this.notifyChange();
    }

    public boolean isCoverBitmapValid() {
        return this.coverBitmap != null && this.coverBitmap.isValid() && this.coverBitmap.get() != null;
    }

    public boolean isCanPadding() {
        return this.canPadding;
    }

    public void setCanPadding(boolean canPadding) {
        this.canPadding = canPadding;
    }

    public boolean isFromLibrary() {
        return this.isFromLibrary;
    }

    public void setFromLibrary(boolean fromLibrary) {
        this.isFromLibrary = fromLibrary;
    }

    public String getTitleWithChildCount() {
        return String.format(ResManager.getString((int)R.string.title_with_count), this.getBaseName(), this.getChildFolderCount(), this.getChildFileCount());
    }

    public long getFileSize() {
        switch (this.getType()) {
            case 1: 
            case 4: {
                return this.file == null ? 0L : this.file.length();
            }
        }
        return 0L;
    }
}

