/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.manager;

import android.content.Context;
import android.content.Intent;
import android.graphics.Point;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.CloudStore;
import com.onyx.android.sdk.data.model.Device;
import com.onyx.android.sdk.data.model.Firmware;
import com.onyx.android.sdk.data.model.v2.IndexService;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.request.cloud.CheckLocalFirmwareRequest;
import com.onyx.android.sdk.data.request.cloud.FirmwareUpdateRequest;
import com.onyx.android.sdk.data.utils.CloudConf;
import com.onyx.android.sdk.device.EnvironmentUtil;
import com.onyx.android.sdk.rx.RxCallback;
import com.onyx.android.sdk.utils.DeviceInfoUtil;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.NetworkUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;

public class OTAManager {
    private static final String a = OTAManager.class.getSimpleName();
    private static OTAManager b;
    private CloudStore c;
    private boolean d = false;
    private static final String e = "com.onyx.android.onyxotaservice";
    private static final String f = "com.onyx.android.onyxotaservice.OtaInfoActivity";
    private static final String g = "updatePath";
    public static final String LOCAL_PATH_SDCARD;
    public static final String CLOUD_PATH_SDCARD;
    public static final String LOCAL_PATH_EXTSD;
    public String otaUrl;

    private void a() {
    }

    public boolean isHasNewFirmwareFromCloud() {
        return this.d;
    }

    public OTAManager setHasNewFirmwareFromCloud(boolean hasNewFirmwareFromCloud) {
        this.d = hasNewFirmwareFromCloud;
        return this;
    }

    public void startFirmwareUpdate(Context context, String path) {
        this.a();
        Intent intent = new Intent();
        intent.putExtra(g, path);
        intent.setClassName(e, f);
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }

    public static OTAManager sharedInstance() {
        if (b == null) {
            b = new OTAManager();
        }
        return b;
    }

    public static CheckLocalFirmwareRequest localFirmwareCheckRequest(Context context) {
        return OTAManager.localFirmwareCheckRequest(context, OTAManager.sharedInstance().getCloudStore().getCloudManager());
    }

    public static CheckLocalFirmwareRequest localFirmwareCheckRequest(Context context, CloudManager cloudManager) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(LOCAL_PATH_SDCARD);
        arrayList.add(LOCAL_PATH_EXTSD);
        return new CheckLocalFirmwareRequest(cloudManager, arrayList);
    }

    public static FirmwareUpdateRequest cloudFirmwareCheckRequest(Context context) {
        return OTAManager.cloudFirmwareCheckRequest(context, OTAManager.sharedInstance().getCloudStore().getCloudManager());
    }

    public static FirmwareUpdateRequest cloudFirmwareCheckRequest(Context context, CloudManager cloudManager) {
        Point point = DeviceInfoUtil.getScreenResolution((Context)context);
        Firmware firmware = Firmware.currentFirmware();
        firmware.lang = Locale.getDefault().toString();
        firmware.widthPixels = point.x;
        firmware.heightPixels = point.y;
        Device device = Device.updateCurrentDeviceInfo(context);
        if (device != null) {
            firmware.deviceMAC = device.macAddress;
        }
        return new FirmwareUpdateRequest(cloudManager, firmware);
    }

    public void submitRequest(Context context, BaseCloudRequest request, RxCallback callback) {
        this.getCloudStore().submitRequest(context, request, callback);
    }

    public CloudStore getCloudStore() {
        if (this.c == null) {
            this.c = new CloudStore().setCloudConf(CloudConf.create("http://dev.onyx-international.cn", "http://dev.onyx-international.cn/api/1/", "oss"));
        }
        return this.c;
    }

    public IndexService createIndexService(Context context) {
        IndexService indexService = new IndexService();
        indexService.mac = NetworkUtil.getMacAddress((Context)context);
        return indexService;
    }

    public static String getLocalSdcardPath() {
        return EnvironmentUtil.getExternalStorageDirectory() + File.separator + com.onyx.android.sdk.device.Device.currentDevice.getUpgradePackageName();
    }

    private static String b() {
        return EnvironmentUtil.getRemovableSDCardDirectory() + File.separator + com.onyx.android.sdk.device.Device.currentDevice.getUpgradePackageName();
    }

    private static String c() {
        return EnvironmentUtil.getExternalStorageDirectory() + File.separator + "cloud." + com.onyx.android.sdk.device.Device.currentDevice.getUpgradePackageName();
    }

    public static String getLocalUpdatePagePath() {
        if (FileUtils.fileExist((String)LOCAL_PATH_SDCARD)) {
            return LOCAL_PATH_SDCARD;
        }
        if (FileUtils.fileExist((String)LOCAL_PATH_EXTSD)) {
            return LOCAL_PATH_EXTSD;
        }
        return null;
    }

    public String getOtaUrl() {
        return this.otaUrl;
    }

    public void setOtaUrl(String otaUrl) {
        this.otaUrl = otaUrl;
    }

    static {
        LOCAL_PATH_SDCARD = OTAManager.getLocalSdcardPath();
        CLOUD_PATH_SDCARD = OTAManager.c();
        LOCAL_PATH_EXTSD = OTAManager.b();
    }
}

