/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.db;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import com.onyx.android.sdk.data.compatability.HighLightColor;
import com.onyx.android.sdk.data.model.Annotation;
import com.onyx.android.sdk.data.model.Annotation_Table;
import com.onyx.android.sdk.data.model.Bookmark;
import com.onyx.android.sdk.data.model.Bookmark_Table;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Library_Table;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.Metadata_Table;
import com.onyx.android.sdk.data.model.Thumbnail;
import com.onyx.android.sdk.data.model.Thumbnail_Table;
import com.onyx.android.sdk.data.model.v2.CloudMetadata;
import com.onyx.android.sdk.data.model.v2.CloudMetadata_Table;
import com.onyx.android.sdk.data.model.v2.DeviceBind;
import com.onyx.android.sdk.data.model.v2.DeviceBind_Table;
import com.onyx.android.sdk.utils.Debug;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.SQLiteType;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.migration.AlterTableMigration;
import com.raizlabs.android.dbflow.sql.migration.BaseMigration;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;

public class ContentDatabase {
    public static final String NAME = "ContentDatabase";
    public static final int VERSION = 12;

    public static class Version12BookmarkMigration
    extends AlterTableMigration<Bookmark> {
        public Version12BookmarkMigration(Class<Bookmark> table) {
            super(table);
        }

        public void onPreMigrate() {
            this.addColumn(SQLiteType.TEXT, Bookmark_Table.title.getNameAlias().name());
        }
    }

    public static class Version11AnnotationMigration
    extends BaseMigration {
        private final String a = "Highlight";
        private final String b = "Underline";
        private static final int c = 0;
        private static final int d = 1;

        public void migrate(@NonNull DatabaseWrapper database) {
            SQLite.update(Annotation.class).set(new SQLOperator[]{Annotation_Table.color.eq((Object)HighLightColor.getDefaultColor())}).execute(database);
            SQLite.update(Annotation.class).set(new SQLOperator[]{Annotation_Table.shape.eq((Object)this.getHighlightShapeFromSP(FlowManager.getContext()))}).execute(database);
        }

        public int getHighlightShapeFromSP(Context context) {
            try {
                SharedPreferences sharedPreferences = context.getSharedPreferences(context.getPackageName() + "_preferences", 4);
                String string2 = sharedPreferences.getString("settings_annotation_highlight_style_key", "Highlight");
                if (StringUtils.isEquals((String)"Highlight", (String)string2)) {
                    return 0;
                }
                if (StringUtils.isEquals((String)"Underline", (String)string2)) {
                    return 1;
                }
            }
            catch (Exception exception) {
                Debug.e((Throwable)exception);
            }
            return 0;
        }
    }

    public static class Version10AnnotationMigration
    extends AlterTableMigration<Annotation> {
        public Version10AnnotationMigration(Class<Annotation> table) {
            super(table);
        }

        public void onPreMigrate() {
            this.addColumn(SQLiteType.INTEGER, Annotation_Table.color.getNameAlias().name());
            this.addColumn(SQLiteType.INTEGER, Annotation_Table.shape.getNameAlias().name());
        }
    }

    public static class Version9BookmarkMigration
    extends AlterTableMigration<Bookmark> {
        public Version9BookmarkMigration(Class<Bookmark> table) {
            super(table);
        }

        public void onPreMigrate() {
            this.addColumn(SQLiteType.TEXT, Bookmark_Table.oldPosition.getNameAlias().name());
            this.addColumn(SQLiteType.INTEGER, Bookmark_Table.positionType.getNameAlias().name());
        }
    }

    public static class Version9AnnotationMigration
    extends AlterTableMigration<Annotation> {
        public Version9AnnotationMigration(Class<Annotation> table) {
            super(table);
        }

        public void onPreMigrate() {
            this.addColumn(SQLiteType.TEXT, Annotation_Table.oldLocationBegin.getNameAlias().name());
            this.addColumn(SQLiteType.TEXT, Annotation_Table.oldLocationEnd.getNameAlias().name());
            this.addColumn(SQLiteType.INTEGER, Annotation_Table.positionType.getNameAlias().name());
        }
    }

    public static class Version8Migration
    extends AlterTableMigration<Library> {
        public Version8Migration(Class<Library> table) {
            super(table);
        }

        public void onPreMigrate() {
            this.addColumn(SQLiteType.INTEGER, Library_Table.fetchSource.getNameAlias().name());
        }
    }

    public static class Version6Migration
    extends AlterTableMigration<Metadata> {
        public Version6Migration(Class<Metadata> table) {
            super(table);
        }

        public void onPreMigrate() {
            this.addColumn(SQLiteType.TEXT, Metadata_Table.downloadInfo.getNameAlias().name());
        }
    }

    public static class Version5LibraryMigration
    extends AlterTableMigration<Library> {
        public Version5LibraryMigration(Class<Library> table) {
            super(table);
        }

        public void onPreMigrate() {
            this.addColumn(SQLiteType.TEXT, Library_Table.storageId.getNameAlias().name());
        }
    }

    public static class Version4ThumbnailMigration
    extends AlterTableMigration<Thumbnail> {
        public Version4ThumbnailMigration(Class<Thumbnail> table) {
            super(table);
        }

        public void onPreMigrate() {
            this.addColumn(SQLiteType.TEXT, Thumbnail_Table.originContentPath.getNameAlias().name());
            this.addColumn(SQLiteType.TEXT, Thumbnail_Table._data.getNameAlias().name());
        }
    }

    public static class Version4DeviceBindMigration
    extends AlterTableMigration<DeviceBind> {
        public Version4DeviceBindMigration(Class<DeviceBind> table) {
            super(table);
        }

        public void onPreMigrate() {
            this.addColumn(SQLiteType.TEXT, DeviceBind_Table.tag.getNameAlias().name());
        }
    }

    public static class Version4CloudMetadataMigration
    extends AlterTableMigration<CloudMetadata> {
        public Version4CloudMetadataMigration(Class<CloudMetadata> table) {
            super(table);
        }

        public void onPreMigrate() {
            this.addColumn(SQLiteType.INTEGER, CloudMetadata_Table.ordinal.getNameAlias().name());
        }
    }

    public static class Version4MetadataMigration
    extends AlterTableMigration<Metadata> {
        public Version4MetadataMigration(Class<Metadata> table) {
            super(table);
        }

        public void onPreMigrate() {
            this.addColumn(SQLiteType.INTEGER, Metadata_Table.ordinal.getNameAlias().name());
        }
    }

    public static class Version3Migration
    extends AlterTableMigration<Metadata> {
        public Version3Migration(Class<Metadata> table) {
            super(table);
        }

        public void onPreMigrate() {
            this.addColumn(SQLiteType.INTEGER, Metadata_Table.fetchSource.getNameAlias().name());
            this.addColumn(SQLiteType.TEXT, Metadata_Table.coverUrl.getNameAlias().name());
        }
    }

    public static class Version2Migration
    extends AlterTableMigration<Metadata> {
        public Version2Migration(Class<Metadata> table) {
            super(table);
        }

        public void onPreMigrate() {
            this.addColumn(SQLiteType.INTEGER, Metadata_Table.readingStatus.getNameAlias().name());
            this.addColumn(SQLiteType.TEXT, Metadata_Table.hashTag.getNameAlias().name());
            this.addColumn(SQLiteType.TEXT, Metadata_Table.storageId.getNameAlias().name());
        }
    }
}

