/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.compatability;

import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.BaseColumns;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.onyx.android.sdk.data.compatability.CursorUtil;
import com.onyx.android.sdk.data.compatability.OnyxBookProgress;
import com.onyx.android.sdk.data.compatability.SerializationUtil;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OnyxMetadata
implements Parcelable {
    private static final String TAG = "OnyxMetadata";
    public static final String DB_TABLE_NAME = "library_metadata";
    public static final Uri CONTENT_URI = Uri.parse((String)"content://com.onyx.android.sdk.OnyxCmsProvider/library_metadata");
    private static final int INVALID_ID = -1;
    private long mId = -1L;
    private String mMD5 = null;
    private String mName = null;
    private String mTitle = null;
    private ArrayList<String> mAuthors = null;
    private String mPublisher = null;
    private String mLanguage = null;
    private String mISBN = null;
    private String mDescription = null;
    private String mLocation = null;
    private String mNativeAbsolutePath = null;
    private long mSize = 0L;
    private String mEncoding = null;
    private Date mLastAccess = null;
    private Date mLastModified = null;
    private OnyxBookProgress mProgress = null;
    private int mFavorite = 0;
    private int mRating = 0;
    private ArrayList<String> mTags = null;
    private Set<String> series = null;
    private int libRefCount = 0;
    private JSONObject mExtraAttributes = new JSONObject();
    private String mType = null;
    private String cloudReference;
    public static final Parcelable.Creator<OnyxMetadata> CREATOR = new Parcelable.Creator<OnyxMetadata>(){

        public OnyxMetadata a(Parcel parcel) {
            Log.i((String)OnyxMetadata.TAG, (String)"Create metadata from parcel!");
            return new OnyxMetadata(parcel);
        }

        public OnyxMetadata[] a(int n) {
            return new OnyxMetadata[n];
        }

        public /* synthetic */ Object[] newArray(int n) {
            return this.a(n);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.a(parcel);
        }
    };

    public OnyxMetadata() {
    }

    public OnyxMetadata(Parcel source) {
        this.readFromParcel(source);
    }

    public static OnyxMetadata createFromFile(File file) {
        return OnyxMetadata.createFromFile(file, true);
    }

    public static OnyxMetadata createFromFile(String path) {
        return OnyxMetadata.createFromFile(new File(path));
    }

    public static OnyxMetadata createFromFile(File file, boolean computeMd5) {
        try {
            OnyxMetadata onyxMetadata = new OnyxMetadata();
            if (computeMd5) {
                String string = FileUtils.computeMD5((File)file);
                onyxMetadata.setMD5(string);
            }
            OnyxMetadata.getBasicMetadataFromFile(onyxMetadata, file);
            return onyxMetadata;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)TAG, (Throwable)noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            Log.w((String)TAG, (Throwable)iOException);
        }
        return null;
    }

    public static void getBasicMetadataFromFile(OnyxMetadata data2, File file) {
        data2.setName(file.getName());
        data2.setLocation(file.getAbsolutePath());
        data2.setNativeAbsolutePath(file.getAbsolutePath());
        data2.setSize(file.length());
        data2.setlastModified(new Date(FileUtils.getLastChangeTime((File)file)));
        data2.setType(FileUtils.getFileExtension((String)file.getName()));
    }

    public Object clone() {
        OnyxMetadata onyxMetadata = new OnyxMetadata();
        onyxMetadata.setId(this.mId);
        onyxMetadata.setMD5(this.mMD5);
        onyxMetadata.setName(this.mName);
        onyxMetadata.setTitle(this.mTitle);
        onyxMetadata.setAuthors(this.mAuthors);
        onyxMetadata.setPublisher(this.mPublisher);
        onyxMetadata.setLanguage(this.mLanguage);
        onyxMetadata.setISBN(this.mISBN);
        onyxMetadata.setDescription(this.mDescription);
        onyxMetadata.setLocation(this.mLocation);
        onyxMetadata.setNativeAbsolutePath(this.mNativeAbsolutePath);
        onyxMetadata.setSize(this.mSize);
        onyxMetadata.setEncoding(this.mEncoding);
        onyxMetadata.setLastAccess(this.mLastAccess);
        onyxMetadata.setlastModified(this.mLastModified);
        onyxMetadata.setProgress(this.mProgress);
        onyxMetadata.setFavorite(this.mFavorite);
        onyxMetadata.setRating(this.mRating);
        onyxMetadata.setTags(this.mTags);
        onyxMetadata.putExtraAttributes((Map<String, Object>)this.mExtraAttributes);
        onyxMetadata.setType(this.mType);
        onyxMetadata.setCloudReference(this.cloudReference);
        onyxMetadata.setSeries(this.series);
        onyxMetadata.setLibRefCount(this.libRefCount);
        return onyxMetadata;
    }

    public boolean isDataFromDB() {
        return this.mId != -1L;
    }

    public long getId() {
        return this.mId;
    }

    public void setId(long id) {
        this.mId = id;
    }

    public String getMD5() {
        return this.mMD5;
    }

    public void setMD5(String md5) {
        this.mMD5 = md5;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public ArrayList<String> getAuthors() {
        return this.mAuthors;
    }

    public String getAuthorsString() {
        if (this.mAuthors != null) {
            return StringUtils.join(this.mAuthors, (String)",");
        }
        return "";
    }

    public String getAuthorsStringWithCustomSeparator(String separator) {
        if (this.mAuthors != null) {
            return StringUtils.join(this.mAuthors, (String)separator);
        }
        return "";
    }

    public void setAuthors(ArrayList<String> authors) {
        this.mAuthors = authors;
    }

    public String getPublisher() {
        return this.mPublisher;
    }

    public void setPublisher(String publisher) {
        this.mPublisher = publisher;
    }

    public String getLanguage() {
        return this.mLanguage;
    }

    public void setLanguage(String language) {
        this.mLanguage = language;
    }

    public String getISBN() {
        return this.mISBN;
    }

    public void setISBN(String isbn) {
        this.mISBN = isbn;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getLocation() {
        return this.mLocation;
    }

    public void setLocation(String location) {
        this.mLocation = location;
    }

    public String getNativeAbsolutePath() {
        return this.mNativeAbsolutePath;
    }

    public void setNativeAbsolutePath(String nativeAbsolutePath) {
        this.mNativeAbsolutePath = nativeAbsolutePath;
    }

    public long getSize() {
        return this.mSize;
    }

    public void setSize(long size) {
        this.mSize = size;
    }

    public String getEncoding() {
        return this.mEncoding;
    }

    public void setEncoding(String encoding) {
        this.mEncoding = encoding;
    }

    public Date getLastAccess() {
        return this.mLastAccess;
    }

    public void setLastAccess(Date lastAccess) {
        this.mLastAccess = lastAccess;
    }

    public void updateLastAccess() {
        this.mLastAccess = new Date();
    }

    public Date getLastModified() {
        return this.mLastModified;
    }

    public void setlastModified(Date lastModified) {
        this.mLastModified = lastModified;
    }

    public OnyxBookProgress getProgress() {
        return this.mProgress;
    }

    public void setProgress(OnyxBookProgress progress) {
        this.mProgress = progress;
    }

    public boolean isReaded() {
        return this.mProgress != null && this.mProgress.isFinished();
    }

    public boolean isReading() {
        return this.mProgress != null;
    }

    public boolean isNew() {
        return this.mProgress == null;
    }

    public int getFavorite() {
        return this.mFavorite;
    }

    public void setFavorite(int favorite) {
        this.mFavorite = favorite;
    }

    public int getRating() {
        return this.mRating;
    }

    public void setRating(int rating) {
        this.mRating = rating;
    }

    public ArrayList<String> getTags() {
        return this.mTags;
    }

    public void setTags(ArrayList<String> tags) {
        this.mTags = tags;
    }

    public String getTagsString() {
        if (this.mTags != null) {
            return StringUtils.join(this.mTags, (String)", ");
        }
        return "";
    }

    public JSONObject getExtraAttributes() {
        return this.mExtraAttributes;
    }

    public void putExtraAttribute(String key, Object value) {
        this.mExtraAttributes.put(key, value);
    }

    public void putExtraAttributes(Map<String, Object> value) {
        if (value != null) {
            this.mExtraAttributes.putAll(value);
        }
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String type) {
        this.mType = type;
    }

    public String getCloudReference() {
        return this.cloudReference;
    }

    public void setCloudReference(String ref) {
        this.cloudReference = ref;
    }

    public final Set<String> getSeries() {
        return this.series;
    }

    public final String getSeriesString() {
        return SerializationUtil.setToString(this.series);
    }

    public void setSeries(Set<String> s) {
        this.series = s;
    }

    public int getLibRefCount() {
        return this.libRefCount;
    }

    public void setLibRefCount(int refCount) {
        this.libRefCount = refCount;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mId);
        dest.writeString(this.mMD5);
        dest.writeString(this.mName);
        dest.writeString(this.mTitle);
        dest.writeStringList(this.mAuthors);
        dest.writeString(this.mPublisher);
        dest.writeString(this.mLanguage);
        dest.writeString(this.mISBN);
        dest.writeString(this.mDescription);
        dest.writeString(this.mLocation);
        dest.writeString(this.mNativeAbsolutePath);
        dest.writeLong(this.mSize);
        dest.writeString(this.mEncoding);
        dest.writeString(SerializationUtil.dateToString(this.mLastAccess));
        dest.writeString(SerializationUtil.dateToString(this.mLastModified));
        dest.writeInt(this.mFavorite);
        dest.writeInt(this.mRating);
        dest.writeStringList(this.mTags);
        dest.writeString(JSON.toJSONString((Object)this.mExtraAttributes));
        dest.writeString(this.mType);
        dest.writeString(this.cloudReference);
        if (this.series != null && this.series.size() > 0) {
            dest.writeStringList(new ArrayList<String>(this.series));
        }
        dest.writeInt(this.libRefCount);
    }

    public void readFromParcel(Parcel source) {
        this.mId = source.readLong();
        this.mMD5 = source.readString();
        this.mName = source.readString();
        this.mTitle = source.readString();
        this.mAuthors = new ArrayList();
        source.readStringList(this.mAuthors);
        this.mPublisher = source.readString();
        this.mLanguage = source.readString();
        this.mISBN = source.readString();
        this.mDescription = source.readString();
        this.mLocation = source.readString();
        this.mNativeAbsolutePath = source.readString();
        this.mSize = source.readLong();
        this.mEncoding = source.readString();
        this.mLastAccess = SerializationUtil.dateFromString(source.readString());
        this.mLastModified = SerializationUtil.dateFromString(source.readString());
        this.mFavorite = source.readInt();
        this.mRating = source.readInt();
        this.mTags = new ArrayList();
        source.readStringList(this.mTags);
        this.mExtraAttributes = JSON.parseObject((String)source.readString());
        this.mType = source.readString();
        this.cloudReference = source.readString();
        ArrayList arrayList = new ArrayList();
        source.readStringList(arrayList);
        if (arrayList.size() > 0) {
            this.series = new HashSet<String>(arrayList);
        }
        this.libRefCount = source.readInt();
    }

    public static class Columns
    implements BaseColumns {
        public static String MD5 = "MD5";
        public static String NAME = "Name";
        public static String TITLE = "Title";
        public static String AUTHORS = "Authors";
        public static String PUBLISHER = "Publisher";
        public static String LANGUAGE = "Language";
        public static String ISBN = "ISBN";
        public static String DESCRIPTION = "Description";
        public static String LOCATION = "Location";
        public static String NATIVE_ABSOLUTE_PATH = "NativeAbsolutePath";
        public static String SIZE = "Size";
        public static String ENCODING = "Encoding";
        public static String LAST_ACCESS = "LastAccess";
        public static String LAST_MODIFIED = "LastModified";
        public static String PROGRESS = "Progress";
        public static String FAVORITE = "Favorite";
        public static String RATING = "Rating";
        public static String TAGS = "Tags";
        public static String EXTRA_ATTRIBUTES = "ExtraAttributes";
        public static String TYPE = "Type";
        public static String CLOUD_REFERENCE = "CloudReference";
        public static String SERIES = "Series";
        public static String LIB_REF_COUNT = "LibRefCount";
        private static boolean a = false;
        private static int b = -1;
        private static int c = -1;
        private static int d = -1;
        private static int e = -1;
        private static int f = -1;
        private static int g = -1;
        private static int h = -1;
        private static int i = -1;
        private static int j = -1;
        private static int k = -1;
        private static int l = -1;
        private static int m = -1;
        private static int n = -1;
        private static int o = -1;
        private static int p = -1;
        private static int q = -1;
        private static int r = -1;
        private static int s = -1;
        private static int t = -1;
        private static int u = -1;
        private static int v = -1;
        private static int w = -1;
        private static int x = -1;
        private static int y = -1;

        public static ContentValues createColumnData(OnyxMetadata data2) {
            ContentValues contentValues = new ContentValues();
            contentValues.put(MD5, data2.getMD5());
            contentValues.put(NAME, data2.getName());
            contentValues.put(TITLE, data2.getTitle());
            contentValues.put(AUTHORS, SerializationUtil.authorsToString(data2.getAuthors()));
            contentValues.put(PUBLISHER, data2.getPublisher());
            contentValues.put(LANGUAGE, data2.getLanguage());
            contentValues.put(ISBN, data2.getISBN());
            contentValues.put(DESCRIPTION, data2.getDescription());
            contentValues.put(LOCATION, data2.getLocation());
            contentValues.put(NATIVE_ABSOLUTE_PATH, data2.getNativeAbsolutePath());
            contentValues.put(SIZE, Long.valueOf(data2.getSize()));
            contentValues.put(ENCODING, data2.getEncoding());
            contentValues.put(LAST_ACCESS, data2.getLastAccess() == null ? null : Long.valueOf(data2.getLastAccess().getTime()));
            contentValues.put(LAST_MODIFIED, data2.getLastModified() == null ? null : Long.valueOf(data2.getLastModified().getTime()));
            contentValues.put(PROGRESS, data2.getProgress() == null ? null : data2.getProgress().toString());
            contentValues.put(FAVORITE, Integer.valueOf(data2.getFavorite()));
            contentValues.put(RATING, Integer.valueOf(data2.getRating()));
            contentValues.put(TAGS, SerializationUtil.tagsToString(data2.getTags()));
            contentValues.put(EXTRA_ATTRIBUTES, JSON.toJSONString((Object)data2.getExtraAttributes()));
            contentValues.put(TYPE, data2.getType());
            contentValues.put(CLOUD_REFERENCE, data2.getCloudReference());
            contentValues.put(SERIES, SerializationUtil.setToString(data2.getSeries()));
            contentValues.put(LIB_REF_COUNT, Integer.valueOf(data2.getLibRefCount()));
            return contentValues;
        }

        public static void readColumnData(Cursor c, OnyxMetadata data2) {
            JSONObject jSONObject;
            if (!a) {
                b = c.getColumnIndex("_id");
                Columns.c = c.getColumnIndex(MD5);
                d = c.getColumnIndex(NAME);
                e = c.getColumnIndex(TITLE);
                f = c.getColumnIndex(AUTHORS);
                g = c.getColumnIndex(PUBLISHER);
                h = c.getColumnIndex(LANGUAGE);
                i = c.getColumnIndex(ISBN);
                j = c.getColumnIndex(DESCRIPTION);
                k = c.getColumnIndex(LOCATION);
                l = c.getColumnIndex(NATIVE_ABSOLUTE_PATH);
                m = c.getColumnIndex(SIZE);
                n = c.getColumnIndex(ENCODING);
                o = c.getColumnIndex(LAST_ACCESS);
                p = c.getColumnIndex(LAST_MODIFIED);
                q = c.getColumnIndex(PROGRESS);
                r = c.getColumnIndex(FAVORITE);
                s = c.getColumnIndex(RATING);
                t = c.getColumnIndex(TAGS);
                u = c.getColumnIndex(EXTRA_ATTRIBUTES);
                v = c.getColumnIndex(TYPE);
                w = c.getColumnIndex(CLOUD_REFERENCE);
                x = c.getColumnIndex(SERIES);
                y = c.getColumnIndex(LIB_REF_COUNT);
                a = true;
            }
            long l = CursorUtil.getLong(c, b);
            String string = CursorUtil.getString(c, Columns.c);
            String string2 = CursorUtil.getString(c, d);
            String string3 = CursorUtil.getString(c, e);
            String string4 = CursorUtil.getString(c, f);
            String string5 = CursorUtil.getString(c, g);
            String string6 = CursorUtil.getString(c, h);
            String string7 = CursorUtil.getString(c, i);
            String string8 = CursorUtil.getString(c, j);
            String string9 = CursorUtil.getString(c, k);
            String string10 = CursorUtil.getString(c, Columns.l);
            Long l2 = CursorUtil.getLong(c, m);
            String string11 = CursorUtil.getString(c, n);
            Long l3 = CursorUtil.getLong(c, o);
            Long l4 = CursorUtil.getLong(c, p);
            OnyxBookProgress onyxBookProgress = OnyxBookProgress.fromString(CursorUtil.getString(c, q));
            int n = c.getInt(r);
            int n2 = c.getInt(s);
            String string12 = CursorUtil.getString(c, t);
            String string13 = CursorUtil.getString(c, w);
            String string14 = CursorUtil.getString(c, x);
            int n3 = c.getInt(y);
            try {
                jSONObject = (JSONObject)JSON.parseObject((String)CursorUtil.getString(c, u), JSONObject.class);
            }
            catch (Throwable throwable) {
                jSONObject = new JSONObject();
            }
            String string15 = CursorUtil.getString(c, v);
            data2.setId(l);
            data2.setMD5(string);
            data2.setName(string2);
            data2.setTitle(string3);
            data2.setAuthors(SerializationUtil.authorsFromString(string4));
            data2.setPublisher(string5);
            data2.setLanguage(string6);
            data2.setISBN(string7);
            data2.setDescription(string8);
            data2.setLocation(string9);
            data2.setNativeAbsolutePath(string10);
            if (l3 != null && l3 > 0L) {
                data2.setLastAccess(new Date(l3));
            }
            data2.setlastModified(new Date(l4 == null ? 0L : l4));
            data2.setSize(l2 == null ? 0L : l2);
            data2.setEncoding(string11);
            data2.setProgress(onyxBookProgress);
            data2.setFavorite(n);
            data2.setRating(n2);
            data2.setTags(SerializationUtil.tagsFromString(string12));
            data2.putExtraAttributes((Map<String, Object>)jSONObject);
            data2.setType(string15);
            data2.setCloudReference(string13);
            data2.setSeries(SerializationUtil.setFromString(string14));
            data2.setLibRefCount(n3);
        }

        public static OnyxMetadata readColumnData(Cursor c) {
            OnyxMetadata onyxMetadata = new OnyxMetadata();
            Columns.readColumnData(c, onyxMetadata);
            return onyxMetadata;
        }
    }
}

