/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import com.onyx.android.sdk.data.common.ContentException;
import com.onyx.android.sdk.utils.CollectionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class QueryResult<T>
implements Serializable {
    public List<T> list;
    public long count;
    public int fetchSource;
    public ContentException exception;

    public QueryResult<T> copy(int limit) {
        QueryResult<T> queryResult = new QueryResult<T>();
        queryResult.count = this.count;
        queryResult.fetchSource = this.fetchSource;
        queryResult.list = new ArrayList<T>();
        for (int i = 0; i < CollectionUtils.getSize(this.list) && i < limit; ++i) {
            queryResult.list.add(this.list.get(i));
        }
        return queryResult;
    }

    public boolean isFetchFromCloud() {
        return this.fetchSource == 1;
    }

    public boolean isContentEmpty() {
        return this.count <= 0L || CollectionUtils.isNullOrEmpty(this.list);
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public void setException(ContentException e) {
        this.exception = e;
    }

    public ContentException getException() {
        return this.exception;
    }

    public static boolean isValidQueryResult(QueryResult result) {
        return result != null && !result.isContentEmpty();
    }

    public List<T> getEnsureList() {
        return this.list == null ? new ArrayList() : this.list;
    }
}

