/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.FileSystemSnapshot;
import com.onyx.android.sdk.data.request.data.BaseDataRequest;
import com.onyx.android.sdk.data.request.data.fs.FileSystemScanRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileSystemManager {
    private HashMap<String, FileSystemSnapshot> a = new HashMap();

    public void diff(String storageId, HashSet<String> newSet, HashSet<String> added, HashSet<String> removed) {
        FileSystemSnapshot fileSystemSnapshot = this.a.get(storageId);
        if (fileSystemSnapshot == null) {
            return;
        }
        fileSystemSnapshot.diff(newSet, added, removed);
    }

    public void clear(String storageId) {
        FileSystemSnapshot fileSystemSnapshot = this.a.get(storageId);
        if (fileSystemSnapshot == null) {
            return;
        }
        fileSystemSnapshot.clear();
    }

    public void addAll(String storageId, Collection<String> pathList, boolean createIfNotExist) {
        FileSystemSnapshot fileSystemSnapshot = this.a.get(storageId);
        if (fileSystemSnapshot == null) {
            if (!createIfNotExist) {
                return;
            }
            fileSystemSnapshot = new FileSystemSnapshot();
            this.a.put(storageId, fileSystemSnapshot);
        }
        fileSystemSnapshot.addAll(pathList);
    }

    public static List<BaseDataRequest> getFileSystemScanRequestList(DataManager dataManager, Map<String, List<String>> storageIdDirMap, Set<String> defaultFileTypes) {
        ArrayList<BaseDataRequest> arrayList = new ArrayList<BaseDataRequest>();
        for (String string2 : storageIdDirMap.keySet()) {
            FileSystemScanRequest fileSystemScanRequest = new FileSystemScanRequest(dataManager, String.valueOf(string2), storageIdDirMap.get(string2), true).setExtensionFilterSet(defaultFileTypes);
            arrayList.add(fileSystemScanRequest);
        }
        return arrayList;
    }
}

