/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.data.fs;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.DataManagerHelper;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.data.model.FileModel;
import com.onyx.android.sdk.data.model.common.FilesType;
import com.onyx.android.sdk.data.request.data.fs.BaseFSRequest;
import com.onyx.android.sdk.dataprovider.R;
import com.onyx.android.sdk.device.EnvironmentUtil;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.ResManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StorageFileListLoadRequest
extends BaseFSRequest {
    private static final int a = 30;
    private boolean b;
    private File c;
    private SortBy d;
    private SortOrder e;
    private Map<String, Integer> f;
    private List<File> g = new ArrayList<File>();
    private List<FileModel> h = new ArrayList<FileModel>();
    private List<String> i;
    private int j;
    private int k = Integer.MAX_VALUE;
    private int l;
    private boolean m = true;

    public StorageFileListLoadRequest(@NonNull DataManager dataManager, @NonNull File targetDir) {
        super(dataManager);
        this.c = targetDir;
        this.f = FilesType.defaultThumbnailMapping();
    }

    public StorageFileListLoadRequest setSort(SortBy sortBy, SortOrder sortOrder) {
        this.d = sortBy;
        this.e = sortOrder;
        return this;
    }

    public StorageFileListLoadRequest setSkipHiddenFile(boolean skipHiddenFile) {
        this.b = skipHiddenFile;
        return this;
    }

    public StorageFileListLoadRequest setShortCutList(List<String> shortCutList) {
        this.i = shortCutList;
        return this;
    }

    public List<File> getResultFileList() {
        return this.g;
    }

    public StorageFileListLoadRequest setResultFileList(@NonNull List<File> list) {
        this.g = list;
        return this;
    }

    public List<FileModel> getResultDataItemList() {
        return this.h;
    }

    public StorageFileListLoadRequest setOffset(int offset) {
        this.l = offset;
        return this;
    }

    public StorageFileListLoadRequest setLimit(int limit) {
        this.k = limit;
        return this;
    }

    public StorageFileListLoadRequest setLoadThumbnail(boolean loadThumbnail) {
        this.m = loadThumbnail;
        return this;
    }

    public int getTotalCount() {
        return this.j;
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        this.a();
        if (FileUtils.isStorageRoot((File)this.c)) {
            this.b();
        } else {
            this.c();
        }
        if (this.d()) {
            FileUtils.sortFileList(this.g, (SortBy)this.d, (SortOrder)this.e);
        }
        this.a(this.c, this.g);
    }

    private void a() {
        if (this.g == null) {
            this.g = new ArrayList<File>();
        }
    }

    private void b() {
        this.g.clear();
        this.g.add(EnvironmentUtil.getExternalStorageDirectory());
        this.g.add(EnvironmentUtil.getRemovableSDCardDirectory());
    }

    private void c() {
        if (!CollectionUtils.isNullOrEmpty(this.g)) {
            return;
        }
        this.g = FileUtils.loadStorageFileList((File)this.c, (boolean)this.b);
    }

    private boolean d() {
        return this.d != null && this.e != null;
    }

    private void a(File file, List<File> list) {
        this.h.clear();
        this.a(list, this.d(file));
        this.e();
    }

    private void e() {
        if (!this.m) {
            return;
        }
        int n = Math.min(CollectionUtils.getSize(this.h), 30);
        for (int i = 0; i < n; ++i) {
            FileModel fileModel = this.h.get(i);
            if (!fileModel.isFileType()) continue;
            fileModel.setRefCoverBitmap(DataManagerHelper.loadThumbnailBitmapWithCache(this.getContext(), this.getDataManager().getRemoteContentProvider(), this.getDataManager().getCacheManager().getBitmapLruCache(), fileModel.getFile().getAbsolutePath()));
        }
    }

    private void a(List<File> list, List<String> list2) {
        int n;
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        int n2 = list.size();
        int n3 = n2 + (n = CollectionUtils.getSize(list2));
        if (this.k + this.l > n3) {
            this.k = n3 - this.l;
        }
        for (int i = 0; i < this.k; ++i) {
            int n4 = this.l + i;
            if (n4 < n2) {
                FileModel fileModel = this.c(list.get(n4));
                if (fileModel == null) continue;
                this.h.add(fileModel);
                continue;
            }
            this.h.add(this.a(list2.get(n4 - n2)));
        }
        this.j += n3;
    }

    private void a(File file) {
        if (FileUtils.isStorageRoot((File)file)) {
            return;
        }
        ++this.j;
        if (this.l <= 0) {
            this.h.add(this.b(file));
        }
        if (--this.l < 0) {
            this.l = 0;
        }
    }

    private FileModel b(File file) {
        FileModel fileModel = FileModel.createGoUpModel(file, ResManager.getString((int)R.string.storage_item_go_up));
        fileModel.setThumbnailResId(this.f.get("goup"));
        return fileModel;
    }

    private FileModel c(File file) {
        if (!file.canRead()) {
            return null;
        }
        int n = 0;
        FileModel fileModel = FileModel.create(file, null);
        if (file.getAbsolutePath().equalsIgnoreCase(EnvironmentUtil.getExternalStorageDirectory().getAbsolutePath()) || FileUtils.isStorageRoot((File)file)) {
            fileModel.setName(this.getContext().getString(R.string.external_storage));
        }
        if (fileModel.isDirectoryType()) {
            n = this.b("directory");
        } else if (fileModel.isFileType()) {
            n = this.b("fileCover");
        }
        fileModel.setThumbnailResId(n);
        return fileModel;
    }

    private FileModel a(String string2) {
        FileModel fileModel = FileModel.createShortcutModel(new File(this.c.getParentFile() + File.separator + new File(string2).getName()));
        fileModel.setShotCutPath(string2);
        fileModel.setThumbnailResId(this.f.get("shotCut"));
        return fileModel;
    }

    private int b(String string2) {
        if (this.f.containsKey(string2)) {
            return this.f.get(string2);
        }
        return this.f.get("");
    }

    @Nullable
    private List<String> d(File file) {
        if (FileUtils.isStorageRoot((File)file)) {
            return this.i;
        }
        return null;
    }
}

