/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.model;

import android.databinding.BaseObservable;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import com.facebook.common.references.CloseableReference;
import com.onyx.android.sdk.utils.FileUtils;
import java.io.File;

public class FileModel
extends BaseObservable {
    public static final int TYPE_DIRECTORY = 0;
    public static final int TYPE_FILE = 1;
    public static final int TYPE_GO_UP = 2;
    public static final int TYPE_SHORT_CUT = 3;
    private File file;
    private Drawable thumbnail;
    private int thumbnailResId;
    private int type;
    private String name;
    private String shotCutPath;
    private CloseableReference<Bitmap> coverBitmap;

    public static FileModel create(File file, Drawable thumbnail) {
        FileModel fileModel = new FileModel();
        fileModel.file = file;
        fileModel.thumbnail = thumbnail;
        fileModel.type = file.isDirectory() ? 0 : 1;
        return fileModel;
    }

    public static FileModel createGoUpModel(File file, String name) {
        FileModel fileModel = new FileModel();
        fileModel.file = file;
        fileModel.type = 2;
        fileModel.name = name;
        return fileModel;
    }

    public static FileModel createShortcutModel(File file) {
        FileModel fileModel = FileModel.create(file, null);
        fileModel.type = 3;
        return fileModel;
    }

    public String getShotCutPath() {
        return this.shotCutPath;
    }

    public void setShotCutPath(String shotCutPath) {
        this.shotCutPath = shotCutPath;
    }

    public File getFile() {
        return this.file;
    }

    public File getFileByType() {
        File file = this.getFile();
        if (this.isGoUpType()) {
            file = this.getFile().getParentFile();
        } else if (this.isShortcutType()) {
            file = new File(this.getShotCutPath());
        }
        return file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public Drawable getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(Drawable thumbnail) {
        this.thumbnail = thumbnail;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getName() {
        if (this.name == null) {
            return this.getFileName();
        }
        return this.name;
    }

    private String getFileName() {
        if (this.file == null) {
            return null;
        }
        return this.file.getName();
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isGoUpType() {
        return this.getType() == 2;
    }

    public boolean isFileType() {
        return this.getType() == 1;
    }

    public boolean isDirectoryType() {
        return this.getType() == 0;
    }

    public boolean isShortcutType() {
        return this.getType() == 3;
    }

    public int getThumbnailResId() {
        return this.thumbnailResId;
    }

    public void setThumbnailResId(int thumbnailResId) {
        this.thumbnailResId = thumbnailResId;
    }

    public Bitmap getCoverBitmap() {
        return this.isCoverBitmapValid() ? (Bitmap)this.coverBitmap.get() : null;
    }

    public CloseableReference<Bitmap> getRefCoverBitmap() {
        return this.coverBitmap;
    }

    public void setRefCoverBitmap(CloseableReference<Bitmap> bitmap) {
        this.coverBitmap = bitmap;
        this.notifyChange();
    }

    public boolean isCoverBitmapValid() {
        return this.coverBitmap != null && this.coverBitmap.isValid() && this.coverBitmap.get() != null;
    }

    public String getExtension() {
        return FileUtils.getFileExtension((String)this.getName());
    }
}

