/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.model;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SecurePreferences {
    private static final String TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final String KEY_TRANSFORMATION = "AES/ECB/PKCS5Padding";
    private static final String SECRET_KEY_HASH_TRANSFORMATION = "SHA-256";
    private static final String CHARSET = "UTF-8";
    private final boolean encryptKeys;
    private final Cipher writer;
    private final Cipher reader;
    private final Cipher keyWriter;
    private final SharedPreferences preferences;

    public SecurePreferences(Context context, String string2, String string3, boolean bl) throws SecurePreferencesException {
        try {
            this.writer = Cipher.getInstance(TRANSFORMATION);
            this.reader = Cipher.getInstance(TRANSFORMATION);
            this.keyWriter = Cipher.getInstance(KEY_TRANSFORMATION);
            this.initCiphers(string3);
            this.preferences = context.getSharedPreferences(string2, 0);
            this.encryptKeys = bl;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SecurePreferencesException(generalSecurityException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SecurePreferencesException(unsupportedEncodingException);
        }
    }

    protected void initCiphers(String string2) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec ivParameterSpec = this.getIv();
        SecretKeySpec secretKeySpec = this.getSecretKey(string2);
        this.writer.init(1, (Key)secretKeySpec, ivParameterSpec);
        this.reader.init(2, (Key)secretKeySpec, ivParameterSpec);
        this.keyWriter.init(1, secretKeySpec);
    }

    protected IvParameterSpec getIv() {
        byte[] byArray = new byte[this.writer.getBlockSize()];
        System.arraycopy("fldsjfodasjifudslfjdsaofshaufihadsf".getBytes(), 0, byArray, 0, this.writer.getBlockSize());
        return new IvParameterSpec(byArray);
    }

    protected SecretKeySpec getSecretKey(String string2) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        byte[] byArray = this.createKeyBytes(string2);
        return new SecretKeySpec(byArray, TRANSFORMATION);
    }

    protected byte[] createKeyBytes(String string2) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(SECRET_KEY_HASH_TRANSFORMATION);
        messageDigest.reset();
        byte[] byArray = messageDigest.digest(string2.getBytes(CHARSET));
        return byArray;
    }

    public void put(String string2, String string3) {
        if (string3 == null) {
            this.preferences.edit().remove(this.toKey(string2)).commit();
        } else {
            this.putValue(this.toKey(string2), string3);
        }
    }

    public boolean containsKey(String string2) {
        return this.preferences.contains(this.toKey(string2));
    }

    public void removeValue(String string2) {
        this.preferences.edit().remove(this.toKey(string2)).commit();
    }

    public String getString(String string2) throws SecurePreferencesException {
        if (this.preferences.contains(this.toKey(string2))) {
            String string3 = this.preferences.getString(this.toKey(string2), "");
            return this.decrypt(string3);
        }
        return null;
    }

    public void clear() {
        this.preferences.edit().clear().commit();
    }

    private String toKey(String string2) {
        if (this.encryptKeys) {
            return this.encrypt(string2, this.keyWriter);
        }
        return string2;
    }

    private void putValue(String string2, String string3) throws SecurePreferencesException {
        String string4 = this.encrypt(string3, this.writer);
        this.preferences.edit().putString(string2, string4).commit();
    }

    protected String encrypt(String string2, Cipher cipher) throws SecurePreferencesException {
        byte[] byArray;
        try {
            byArray = SecurePreferences.convert(cipher, string2.getBytes(CHARSET));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SecurePreferencesException(unsupportedEncodingException);
        }
        String string3 = Base64.encodeToString((byte[])byArray, (int)2);
        return string3;
    }

    protected String decrypt(String string2) {
        byte[] byArray = Base64.decode((String)string2, (int)2);
        byte[] byArray2 = SecurePreferences.convert(this.reader, byArray);
        try {
            return new String(byArray2, CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SecurePreferencesException(unsupportedEncodingException);
        }
    }

    private static byte[] convert(Cipher cipher, byte[] byArray) throws SecurePreferencesException {
        try {
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new SecurePreferencesException(exception);
        }
    }

    public static class SecurePreferencesException
    extends RuntimeException {
        public SecurePreferencesException(Throwable throwable) {
            super(throwable);
        }
    }
}

