/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.manager;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.OSS;
import com.alibaba.sdk.android.oss.OSSClient;
import com.alibaba.sdk.android.oss.ServiceException;
import com.alibaba.sdk.android.oss.callback.OSSCompletedCallback;
import com.alibaba.sdk.android.oss.callback.OSSProgressCallback;
import com.alibaba.sdk.android.oss.common.auth.OSSCredentialProvider;
import com.alibaba.sdk.android.oss.common.auth.OSSPlainTextAKSKCredentialProvider;
import com.alibaba.sdk.android.oss.internal.OSSAsyncTask;
import com.alibaba.sdk.android.oss.model.OSSRequest;
import com.alibaba.sdk.android.oss.model.OSSResult;
import com.alibaba.sdk.android.oss.model.PutObjectRequest;
import com.alibaba.sdk.android.oss.model.PutObjectResult;
import com.onyx.android.sdk.common.request.BaseCallback;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.rx.RxCallback;
import com.onyx.android.sdk.utils.FileUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class OssManager {
    private OSS a;
    private OssConfig b;
    private Handler c = new Handler(Looper.getMainLooper());
    private static Map<OssWrapRequest, BaseCallback.ProgressInfo> d = new HashMap<OssWrapRequest, BaseCallback.ProgressInfo>();

    public OssManager(Context context, @NonNull OssConfig ossConfig) {
        this.a = OssManager.a(context, ossConfig);
        this.a(ossConfig);
    }

    private void a(OssConfig ossConfig) {
        this.b = new OssConfig();
        this.b.setBucketName(ossConfig.getBucketName());
        this.b.setEndPoint(ossConfig.getEndPoint());
    }

    private static OSSClient a(Context context, OssConfig ossConfig) {
        OSSPlainTextAKSKCredentialProvider oSSPlainTextAKSKCredentialProvider = new OSSPlainTextAKSKCredentialProvider(ossConfig.getKeyId(), ossConfig.getKeySecret());
        return new OSSClient(context.getApplicationContext(), ossConfig.getEndPoint(), (OSSCredentialProvider)oSSPlainTextAKSKCredentialProvider);
    }

    public OSS getOssClient() {
        return this.a;
    }

    public OssConfig getOssConfig() {
        return this.b;
    }

    public String getOssBucketName() {
        return this.b.getBucketName();
    }

    public String getOssEndPoint() {
        return this.b.getEndPoint();
    }

    public String getOssFileObjectKey(String string) {
        String string2 = UUID.randomUUID().toString().replaceAll("-", "") + "." + FileUtils.getFileExtension((String)string);
        Log.d((String)"oss-objectKey", (String)String.valueOf(string2));
        return string2;
    }

    private PutObjectRequest a(String string, String string2) {
        return new PutObjectRequest(string, this.getOssFileObjectKey(string2), string2);
    }

    public void asyncUploadFile(Context context, String string, RxCallback rxCallback) {
        this.asyncUploadFile(context, this.getOssBucketName(), string, rxCallback);
    }

    public void asyncUploadFile(Context context, String string, String string2, final RxCallback rxCallback) {
        OSS oSS = this.getOssClient();
        PutObjectRequest putObjectRequest = this.a(string, string2);
        final OssWrapRequest<PutObjectRequest> ossWrapRequest = new OssWrapRequest<PutObjectRequest>(putObjectRequest);
        putObjectRequest.setProgressCallback((OSSProgressCallback)new OSSProgressCallback<PutObjectRequest>(){

            public void a(PutObjectRequest putObjectRequest, long l, long l2) {
                OssManager.this.a(ossWrapRequest, rxCallback, l, l2);
            }

            public /* synthetic */ void onProgress(Object object, long l, long l2) {
                this.a((PutObjectRequest)object, l, l2);
            }
        });
        OSSAsyncTask oSSAsyncTask = oSS.asyncPutObject(putObjectRequest, (OSSCompletedCallback)new OSSCompletedCallback<PutObjectRequest, PutObjectResult>(){

            public void a(PutObjectRequest putObjectRequest, PutObjectResult putObjectResult) {
                OssManager.this.a(ossWrapRequest, rxCallback, null);
            }

            public void a(PutObjectRequest putObjectRequest, ClientException clientException, ServiceException serviceException) {
                ClientException clientException2 = clientException;
                if (clientException != null) {
                    clientException.printStackTrace();
                }
                if (serviceException != null) {
                    OssManager.this.a(serviceException);
                    clientException2 = serviceException;
                }
                OssManager.this.a(ossWrapRequest, rxCallback, (Exception)clientException2);
            }

            public /* synthetic */ void onFailure(OSSRequest oSSRequest, ClientException clientException, ServiceException serviceException) {
                this.a((PutObjectRequest)oSSRequest, clientException, serviceException);
            }

            public /* synthetic */ void onSuccess(OSSRequest oSSRequest, OSSResult oSSResult) {
                this.a((PutObjectRequest)oSSRequest, (PutObjectResult)oSSResult);
            }
        });
    }

    public String syncUploadFile(Context context, String string) throws Exception {
        return this.syncUploadFile(context, this.getOssBucketName(), string);
    }

    public String syncUploadFile(Context context, String string, String string2) throws Exception {
        PutObjectRequest putObjectRequest = this.a(string, string2);
        PutObjectResult putObjectResult = this.getOssClient().putObject(putObjectRequest);
        if (putObjectResult.getStatusCode() == 200) {
            return putObjectRequest.getObjectKey();
        }
        return null;
    }

    private BaseCallback.ProgressInfo a(OssWrapRequest ossWrapRequest) {
        if (!d.containsKey((Object)ossWrapRequest)) {
            BaseCallback.ProgressInfo progressInfo = new BaseCallback.ProgressInfo();
            d.put(ossWrapRequest, progressInfo);
        }
        return d.get((Object)ossWrapRequest);
    }

    private void b(OssWrapRequest ossWrapRequest) {
        d.remove((Object)ossWrapRequest);
    }

    private void a(final OssWrapRequest ossWrapRequest, RxCallback rxCallback, long l, long l2) {
        this.a(l, l2);
        if (rxCallback != null) {
            final BaseCallback.ProgressInfo progressInfo = this.a(ossWrapRequest);
            progressInfo.soFarBytes = l;
            progressInfo.totalBytes = l2;
            progressInfo.progress = (float)l * 1.0f / (float)l2 * 100.0f;
            this.c.post(new Runnable(){

                @Override
                public void run() {
                    ossWrapRequest.getEventBus().post((Object)progressInfo);
                }
            });
        }
    }

    private void a(final OssWrapRequest ossWrapRequest, final RxCallback rxCallback, final Exception exception) {
        this.b(ossWrapRequest);
        this.c.post(new Runnable(){

            @Override
            public void run() {
                if (exception != null) {
                    RxCallback.onError((RxCallback)rxCallback, (Throwable)exception);
                } else {
                    RxCallback.onNext((RxCallback)rxCallback, (Object)((Object)ossWrapRequest));
                }
            }
        });
    }

    private void a(long l, long l2) {
    }

    private void a(ServiceException serviceException) {
    }

    public static class OssConfig {
        private String a;
        private String b;
        private String c;
        private String d;

        public String getKeyId() {
            return this.a;
        }

        public void setKeyId(String string) {
            this.a = string;
        }

        public String getKeySecret() {
            return this.b;
        }

        public void setKeySecret(String string) {
            this.b = string;
        }

        public String getEndPoint() {
            return this.c;
        }

        public void setEndPoint(String string) {
            this.c = string;
        }

        public String getBucketName() {
            return this.d;
        }

        public void setBucketName(String string) {
            this.d = string;
        }
    }

    public static class OssWrapRequest<T extends OSSRequest>
    extends BaseCloudRequest {
        private T a;

        public OssWrapRequest(T t) {
            super(null);
            this.a = t;
        }

        public T getRequest() {
            return this.a;
        }

        @Override
        public void execute(CloudManager cloudManager) throws Exception {
        }
    }
}

