/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.compatability;

import android.graphics.Rect;
import android.text.TextUtils;
import android.util.Log;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public abstract class SerializationUtil {
    private static final String a = SerializationUtil.class.getSimpleName();
    public static final String SEPERATOR = ", ";

    public static String dateToString(Date date) {
        if (date == null) {
            return "";
        }
        return date.getTime() + "";
    }

    public static Date dateFromString(String string) {
        if (StringUtils.isNullOrEmpty((String)string) || "null".equals(string)) {
            return null;
        }
        try {
            return new Date(Long.parseLong(string));
        }
        catch (NumberFormatException numberFormatException) {
            Log.w((String)a, (Throwable)numberFormatException);
            return null;
        }
    }

    public static String authorsToString(ArrayList<String> arrayList) {
        if (arrayList == null) {
            return null;
        }
        if (arrayList.size() <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(arrayList.get(0));
        for (int i = 1; i < arrayList.size(); ++i) {
            stringBuilder.append(SEPERATOR).append(arrayList.get(i));
        }
        return stringBuilder.toString();
    }

    public static ArrayList<String> authorsFromString(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(SEPERATOR);
        if (stringArray == null || stringArray.length <= 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static String tagsToString(ArrayList<String> arrayList) {
        if (arrayList == null) {
            return null;
        }
        if (arrayList.size() <= 0) {
            return "";
        }
        return TextUtils.join((CharSequence)SEPERATOR, arrayList);
    }

    public static ArrayList<String> tagsFromString(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(SEPERATOR);
        if (stringArray == null || stringArray.length <= 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static String setToString(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        if (collection.size() <= 0) {
            return "";
        }
        return TextUtils.join((CharSequence)SEPERATOR, collection);
    }

    public static Set<String> setFromString(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(SEPERATOR);
        if (stringArray == null || stringArray.length <= 0) {
            return null;
        }
        return new HashSet<String>(Arrays.asList(stringArray));
    }

    public static String pointsToString(ArrayList<Float> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Float f : arrayList) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(" ");
            }
            stringBuilder.append(f.toString());
        }
        return stringBuilder.toString();
    }

    public static ArrayList<Float> pointsFromString(String string) {
        String[] stringArray;
        ArrayList<Float> arrayList = new ArrayList<Float>();
        if (StringUtils.isNullOrEmpty((String)string)) {
            return arrayList;
        }
        for (String string2 : stringArray = string.trim().split(" ")) {
            arrayList.add(Float.valueOf(Float.parseFloat(string2)));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] rectsToByteArray(Collection<Rect> collection) {
        if (collection == null) {
            return new byte[0];
        }
        DataOutputStream dataOutputStream = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                for (Rect rect : collection) {
                    dataOutputStream.writeInt(rect.left);
                    dataOutputStream.writeInt(rect.top);
                    dataOutputStream.writeInt(rect.right);
                    dataOutputStream.writeInt(rect.bottom);
                }
            }
            finally {
                dataOutputStream.close();
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            Log.e((String)a, (String)"", (Throwable)throwable);
            return new byte[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Rect> rectsFromByteArray(byte[] byArray) {
        ArrayList<Rect> arrayList = new ArrayList<Rect>();
        if (byArray == null) {
            return arrayList;
        }
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            try (DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);){
                for (int i = 0; i < byArray.length / 16; ++i) {
                    int n = dataInputStream.readInt();
                    int n2 = dataInputStream.readInt();
                    int n3 = dataInputStream.readInt();
                    int n4 = dataInputStream.readInt();
                    arrayList.add(new Rect(n, n2, n3, n4));
                }
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            Log.e((String)a, (String)"", (Throwable)throwable);
            return arrayList;
        }
    }
}

