/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.cache;

import android.graphics.Bitmap;
import android.util.LruCache;
import com.facebook.common.references.CloseableReference;
import com.onyx.android.sdk.utils.BitmapUtils;

public class BitmapReferenceLruCache
extends LruCache<String, CloseableReference<Bitmap>> {
    public BitmapReferenceLruCache(int maxSize) {
        super(maxSize);
    }

    protected void entryRemoved(boolean evicted, String key, CloseableReference<Bitmap> oldValue, CloseableReference<Bitmap> newValue) {
        oldValue.close();
    }

    protected int sizeOf(String key, CloseableReference<Bitmap> value) {
        if (value == null || !value.isValid() || !BitmapUtils.isValid((Bitmap)((Bitmap)value.get()))) {
            return 0;
        }
        return BitmapUtils.getSizeInBytes((Bitmap)((Bitmap)value.get()));
    }

    public void clear() {
        this.evictAll();
    }
}

