/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import com.onyx.android.sdk.data.BookFilter;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.v2.CloudMetadataCollection;
import com.onyx.android.sdk.data.model.v2.CloudMetadataCollection_Table;
import com.onyx.android.sdk.data.model.v2.CloudMetadata_Table;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.language.BaseModelQueriable;
import com.raizlabs.android.dbflow.sql.language.Operator;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.Where;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.language.property.Property;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class CloudQueryBuilder {
    public static QueryArgs libraryAllBookQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = CloudQueryBuilder.allBooksQuery(sortBy, sortOrder);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return CloudQueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryAllBookQuery(String libraryUniqueId, Set<String> fileTypes, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = CloudQueryBuilder.allBooksQuery(fileTypes, sortBy, sortOrder);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return CloudQueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryAllBookQuery(String libraryUniqueId, Set<String> fileTypes, OrderBy orderBy) {
        QueryArgs queryArgs = QueryArgs.queryBy(CloudQueryBuilder.orTypeCondition(fileTypes), orderBy);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return CloudQueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryBookListNewQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = CloudQueryBuilder.newBookListQuery(sortBy, sortOrder);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return CloudQueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryFinishReadQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = CloudQueryBuilder.finishReadQuery(sortBy, sortOrder);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return CloudQueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryRecentReadingQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = CloudQueryBuilder.recentReadingQuery(sortBy, sortOrder);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return CloudQueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryRecentAddQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder);
        queryArgs.libraryUniqueId = libraryUniqueId;
        queryArgs.conditionGroup = CloudQueryBuilder.recentAddCondition();
        return CloudQueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryTagsFilterQuery(String libraryUniqueId, Set<String> tags, SortBy sortBy, SortOrder order) {
        QueryArgs queryArgs = CloudQueryBuilder.tagsFilterQuery(tags, sortBy, order);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return CloudQueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs librarySearchQuery(String libraryUniqueId, String search, SortBy sortBy, SortOrder order) {
        QueryArgs queryArgs = CloudQueryBuilder.searchQuery(search, sortBy, order);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return CloudQueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs allBooksQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.ALL);
        return CloudQueryBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs allBooksQuery(Set<String> fileTypes, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.ALL);
        queryArgs.fileType = fileTypes;
        return CloudQueryBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs allBooksQuery(Set<String> fileTypes, OrderBy orderBy) {
        return QueryArgs.queryBy(CloudQueryBuilder.orTypeCondition(fileTypes), orderBy);
    }

    public static QueryArgs newBookListQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.NEW);
        return CloudQueryBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs finishReadQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.FINISHED);
        return CloudQueryBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs recentReadingQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.READING);
        return CloudQueryBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs tagsFilterQuery(Set<String> tags, SortBy sortBy, SortOrder order) {
        QueryArgs queryArgs = new QueryArgs(sortBy, order).appendFilter(BookFilter.TAG);
        queryArgs.tags = tags;
        return CloudQueryBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs searchQuery(String search, SortBy sortBy, SortOrder order) {
        QueryArgs queryArgs = new QueryArgs(sortBy, order).appendFilter(BookFilter.SEARCH);
        queryArgs.query = search;
        return CloudQueryBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs recentAddQuery() {
        QueryArgs queryArgs = QueryArgs.queryBy(CloudQueryBuilder.recentAddCondition(), CloudQueryBuilder.getOrderByUpdateAt().descending());
        return queryArgs;
    }

    public static Property<Integer> getMetadataReadingStatusProperty() {
        return CloudMetadata_Table.readingStatus;
    }

    public static Property<String> getMetadataTypeProperty() {
        return CloudMetadata_Table.type;
    }

    public static Property<String> getMetadataTitleProperty() {
        return CloudMetadata_Table.title;
    }

    public static Property<String> getMetadataNameProperty() {
        return CloudMetadata_Table.name;
    }

    public static Property<String> getMetadataAuthorsProperty() {
        return CloudMetadata_Table.authors;
    }

    public static Property<String> getMetadataPublisherProperty() {
        return CloudMetadata_Table.publisher;
    }

    public static Property<String> getMetadataTagsProperty() {
        return CloudMetadata_Table.tags;
    }

    public static Property<String> getMetadataSeriesProperty() {
        return CloudMetadata_Table.series;
    }

    public static Property<String> getMetadataIdStringProperty() {
        return CloudMetadata_Table.idString;
    }

    public static Property<String> getMetadataCloudIdProperty() {
        return CloudMetadata_Table.cloudId;
    }

    public static Property<Long> getMetadataSizeProperty() {
        return CloudMetadata_Table.size;
    }

    public static Property<Date> getMetadataCreatedAtProperty() {
        return CloudMetadata_Table.createdAt;
    }

    public static Property<Date> getMetadataLastAccessProperty() {
        return CloudMetadata_Table.lastAccess;
    }

    public static Property<Integer> getMetadataOrdinalProperty() {
        return CloudMetadata_Table.ordinal;
    }

    public static Property<String> getMetadataCollectionDocIdProperty() {
        return CloudMetadataCollection_Table.documentUniqueId;
    }

    public static Property<String> getMetadataCollectionLibraryIdProperty() {
        return CloudMetadataCollection_Table.libraryUniqueId;
    }

    public static OperatorGroup newBookListCondition() {
        return OperatorGroup.clause().and((SQLOperator)CloudQueryBuilder.getMetadataReadingStatusProperty().eq((Object)Metadata.ReadingStatus.NEW));
    }

    public static OperatorGroup finishReadCondition() {
        return OperatorGroup.clause().and((SQLOperator)CloudQueryBuilder.getMetadataReadingStatusProperty().eq((Object)Metadata.ReadingStatus.FINISHED));
    }

    public static OperatorGroup recentReadingCondition() {
        return OperatorGroup.clause().and((SQLOperator)CloudQueryBuilder.getMetadataReadingStatusProperty().eq((Object)Metadata.ReadingStatus.READING));
    }

    public static OperatorGroup recentAddCondition() {
        return OperatorGroup.clause().and((SQLOperator)CloudQueryBuilder.getMetadataReadingStatusProperty().eq((Object)Metadata.ReadingStatus.NEW));
    }

    public static OperatorGroup orTypeCondition(Set<String> fileTypes) {
        if (CollectionUtils.isNullOrEmpty(fileTypes)) {
            return OperatorGroup.clause();
        }
        OperatorGroup operatorGroup = OperatorGroup.clause();
        ArrayList<Operator> arrayList = new ArrayList<Operator>();
        for (String string : fileTypes) {
            arrayList.add(CloudQueryBuilder.getMetadataTypeProperty().eq((Object)string));
        }
        return operatorGroup.orAll(arrayList);
    }

    public static OperatorGroup orTagsCondition(Set<String> tags) {
        if (CollectionUtils.isNullOrEmpty(tags)) {
            return OperatorGroup.clause();
        }
        ArrayList<Operator> arrayList = new ArrayList<Operator>();
        for (String string : tags) {
            arrayList.add(CloudQueryBuilder.matchLike(CloudQueryBuilder.getMetadataTagsProperty(), string));
        }
        return OperatorGroup.clause().orAll(arrayList);
    }

    public static OperatorGroup orSearchCondition(String search) {
        if (StringUtils.isNullOrEmpty((String)search)) {
            return OperatorGroup.clause();
        }
        return OperatorGroup.clause().or((SQLOperator)CloudQueryBuilder.matchLike(CloudQueryBuilder.getMetadataTitleProperty(), search)).or((SQLOperator)CloudQueryBuilder.matchLike(CloudQueryBuilder.getMetadataNameProperty(), search)).or((SQLOperator)CloudQueryBuilder.matchLike(CloudQueryBuilder.getMetadataAuthorsProperty(), search));
    }

    public static List<OrderBy> getOrderByList() {
        ArrayList<OrderBy> arrayList = new ArrayList<OrderBy>();
        arrayList.add(OrderBy.fromProperty(CloudQueryBuilder.getMetadataNameProperty()).ascending());
        return arrayList;
    }

    public static OrderBy getOrderByUpdateAt() {
        return CloudQueryBuilder.getOrderBy(CloudQueryBuilder.getMetadataCreatedAtProperty());
    }

    public static OrderBy getOrderByCreateAt() {
        return CloudQueryBuilder.getOrderBy(CloudQueryBuilder.getMetadataCreatedAtProperty());
    }

    public static OrderBy getOrderByName() {
        return CloudQueryBuilder.getOrderBy(CloudQueryBuilder.getMetadataNameProperty()).ascending();
    }

    public static OrderBy getOrderBy(IProperty property) {
        return OrderBy.fromProperty((IProperty)property);
    }

    public static void andWith(OperatorGroup parent, OperatorGroup child) {
        if (parent != null && child != null) {
            parent.and((SQLOperator)child);
        }
    }

    public static Operator matchLike(Property<String> property, String match) {
        if (StringUtils.isNullOrEmpty((String)match)) {
            return null;
        }
        return property.like("%" + match + "%");
    }

    public static OperatorGroup matchLikeSet(Property<String> property, Set<String> set) {
        if (set == null || set.size() <= 0) {
            return null;
        }
        OperatorGroup operatorGroup = OperatorGroup.clause();
        for (String string : set) {
            Operator operator = CloudQueryBuilder.matchLike(property, string);
            if (operator == null) continue;
            operatorGroup.or((SQLOperator)operator);
        }
        return operatorGroup;
    }

    public static OperatorGroup matchEqualSet(Property<String> property, Set<String> set) {
        if (set == null || set.size() <= 0) {
            return null;
        }
        OperatorGroup operatorGroup = OperatorGroup.clause();
        for (String string : set) {
            operatorGroup.or((SQLOperator)property.eq((Object)string));
        }
        return operatorGroup;
    }

    private static Operator a(Property<String> property, String string) {
        return string == null ? property.isNull() : property.eq((Object)string);
    }

    private static Operator b(Property<String> property, String string) {
        return string == null ? property.isNotNull() : property.eq((Object)string);
    }

    private static Operator.In a(Property property, Where where, boolean bl) {
        return bl ? property.in((BaseModelQueriable)where, new BaseModelQueriable[0]) : property.notIn((BaseModelQueriable)where, new BaseModelQueriable[0]);
    }

    public static QueryArgs generateQueryArgs(QueryArgs args) {
        switch (args.filter) {
            case ALL: {
                args.conditionGroup = CloudQueryBuilder.orTypeCondition(args.fileType);
                break;
            }
            case NEW: {
                args.conditionGroup = CloudQueryBuilder.newBookListCondition();
                break;
            }
            case READING: {
                args.conditionGroup = CloudQueryBuilder.recentReadingCondition();
                break;
            }
            case FINISHED: {
                args.conditionGroup = CloudQueryBuilder.finishReadCondition();
                break;
            }
            case TAG: {
                args.conditionGroup = CloudQueryBuilder.orTagsCondition(args.tags);
                break;
            }
            case SEARCH: {
                args.conditionGroup = CloudQueryBuilder.orSearchCondition(args.query);
            }
        }
        CloudQueryBuilder.generateQueryArgsSortBy(args);
        CloudQueryBuilder.generateCriteriaCondition(args);
        return args;
    }

    public static OrderBy ascDescOrder(OrderBy orderBy, boolean asc) {
        if (asc) {
            orderBy.ascending();
        } else {
            orderBy.descending();
        }
        return orderBy;
    }

    public static Property getPropertyFromSortBy(SortBy sortBy) {
        Object object = CloudQueryBuilder.getMetadataNameProperty();
        switch (sortBy) {
            case None: 
            case Name: {
                break;
            }
            case FileType: {
                object = CloudQueryBuilder.getMetadataTypeProperty();
                break;
            }
            case Size: {
                object = CloudQueryBuilder.getMetadataSizeProperty();
                break;
            }
            case CreationTime: {
                object = CloudQueryBuilder.getMetadataCreatedAtProperty();
                break;
            }
            case BookTitle: {
                object = CloudQueryBuilder.getMetadataTitleProperty();
                break;
            }
            case Author: {
                object = CloudQueryBuilder.getMetadataAuthorsProperty();
                break;
            }
            case Publisher: {
                object = CloudQueryBuilder.getMetadataPublisherProperty();
                break;
            }
            case LastOpenTime: {
                object = CloudQueryBuilder.getMetadataLastAccessProperty();
                break;
            }
            case RecentlyRead: {
                object = CloudQueryBuilder.getMetadataLastAccessProperty();
                break;
            }
            case Total: {
                object = CloudQueryBuilder.getMetadataLastAccessProperty();
                break;
            }
            case StartTime: {
                object = CloudQueryBuilder.getMetadataLastAccessProperty();
                break;
            }
            case InstallTime: {
                object = CloudQueryBuilder.getMetadataLastAccessProperty();
                break;
            }
            case Ordinal: {
                object = CloudQueryBuilder.getMetadataOrdinalProperty();
            }
        }
        return object;
    }

    public static OrderBy generateOrderBy(SortBy sortBy, SortOrder order) {
        boolean bl = order == SortOrder.Asc;
        return CloudQueryBuilder.ascDescOrder(OrderBy.fromProperty((IProperty)CloudQueryBuilder.getPropertyFromSortBy(sortBy)), bl);
    }

    public static void generateQueryArgsSortBy(QueryArgs args) {
        args.orderByList.clear();
        args.orderByList.add(CloudQueryBuilder.generateOrderBy(args.sortBy, args.order));
    }

    public static void generateCriteriaCondition(QueryArgs args) {
        CloudQueryBuilder.andWith(args.conditionGroup, CloudQueryBuilder.matchLikeSet(CloudQueryBuilder.getMetadataAuthorsProperty(), args.author));
        CloudQueryBuilder.andWith(args.conditionGroup, CloudQueryBuilder.matchLikeSet(CloudQueryBuilder.getMetadataTagsProperty(), args.tags));
        CloudQueryBuilder.andWith(args.conditionGroup, CloudQueryBuilder.matchLikeSet(CloudQueryBuilder.getMetadataSeriesProperty(), args.series));
        CloudQueryBuilder.andWith(args.conditionGroup, CloudQueryBuilder.matchLikeSet(CloudQueryBuilder.getMetadataTitleProperty(), args.title));
        CloudQueryBuilder.andWith(args.conditionGroup, CloudQueryBuilder.matchLikeSet(CloudQueryBuilder.getMetadataTypeProperty(), args.fileType));
    }

    public static QueryArgs generateMetadataInQueryArgs(QueryArgs queryArgs) {
        Where where = new Select(new IProperty[]{CloudQueryBuilder.getMetadataCollectionDocIdProperty().withTable()}).from(CloudMetadataCollection.class).where(new SQLOperator[]{CloudQueryBuilder.b((Property<String>)CloudQueryBuilder.getMetadataCollectionLibraryIdProperty().withTable(), queryArgs.libraryUniqueId)});
        Operator.In in = CloudQueryBuilder.a(CloudQueryBuilder.getMetadataCloudIdProperty().withTable(), where, StringUtils.isNotBlank((String)queryArgs.libraryUniqueId));
        OperatorGroup operatorGroup = OperatorGroup.clause().and((SQLOperator)in);
        queryArgs.conditionGroup = queryArgs.conditionGroup.size() > 0 ? operatorGroup.and((SQLOperator)queryArgs.conditionGroup) : operatorGroup;
        return queryArgs;
    }
}

