/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.data.fs;

import android.util.Log;
import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.data.common.ContentException;
import com.onyx.android.sdk.data.request.data.fs.BaseFSRequest;
import com.onyx.android.sdk.utils.Benchmark;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.FileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class StorageFileListLoadRequest
extends BaseFSRequest {
    private static final String a = "StorageFileSystemLoad";
    private boolean b;
    private File c;
    private List<String> d;
    private List<File> e = new ArrayList<File>();
    private SortBy f;
    private SortOrder g;

    public StorageFileListLoadRequest(DataManager dataManager) {
        super(dataManager);
    }

    public StorageFileListLoadRequest(DataManager dataManager, File targetDir, List<String> filterFileList) {
        super(dataManager);
        this.c = targetDir;
        this.d = filterFileList;
    }

    public void setSort(SortBy sortBy, SortOrder sortOrder) {
        this.f = sortBy;
        this.g = sortOrder;
    }

    public void setSkipNoMedia(boolean isSkip) {
        this.b = isSkip;
    }

    public List<File> getResultFileList() {
        return this.e;
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        this.e = this.loadStorageFileList(this.c);
        this.a(this.e);
        if (this.a()) {
            this.a(this.e, this.f, this.g);
        }
    }

    public List<File> loadStorageFileList(File targetDir) throws ContentException {
        if (!CollectionUtils.isNullOrEmpty(this.d)) {
            return new ArrayList<File>(Arrays.asList(targetDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String filename) {
                    for (String string2 : StorageFileListLoadRequest.this.d) {
                        boolean bl = filename.contains(FileUtils.getFileName((String)string2));
                        if (!bl) continue;
                        return true;
                    }
                    return false;
                }
            })));
        }
        ArrayList<File> arrayList = new ArrayList<File>(Arrays.asList(targetDir.listFiles()));
        return arrayList;
    }

    private void a(List<File> list, SortBy sortBy, SortOrder sortOrder) {
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        Benchmark benchmark = new Benchmark();
        switch (sortBy) {
            case Name: {
                FileUtils.sortListByName(list, (SortOrder)sortOrder);
                break;
            }
            case CreationTime: {
                FileUtils.sortListByCreationTime(list, (SortOrder)sortOrder);
                break;
            }
            case FileType: {
                FileUtils.sortListByFileType(list, (SortOrder)sortOrder);
                break;
            }
            case Size: {
                FileUtils.sortListBySize(list, (SortOrder)sortOrder);
            }
        }
        Log.w((String)a, (String)("Sort duration:" + benchmark.duration() + "ms"));
    }

    private boolean a() {
        return this.f != null && this.g != null;
    }

    private void a(List<File> list) {
        if (!this.b && CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        StorageFileListLoadRequest.filterInPlace(list);
    }

    public static void filterInPlace(List<File> src) {
        Iterator<File> iterator = src.iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (!file.isHidden()) continue;
            iterator.remove();
        }
    }
}

