/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud.v2;

import android.content.Context;
import android.util.Log;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.CloudQueryBuilder;
import com.onyx.android.sdk.data.DataManagerHelper;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.QueryResult;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.v2.CloudLibrary;
import com.onyx.android.sdk.data.model.v2.PushLibraryClearEvent;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PushLibraryClearRequest
extends BaseCloudRequest {
    private PushLibraryClearEvent a;

    public PushLibraryClearRequest(CloudManager cloudManager, PushLibraryClearEvent libraryClear) {
        super(cloudManager);
        this.a = libraryClear;
    }

    @Override
    public void execute(CloudManager parent) throws Exception {
        if (this.a == null || this.a.library == null) {
            Log.w((String)"libraryContentClear", (String)"detect the library is null");
            return;
        }
        CloudLibrary cloudLibrary = this.a.library;
        List<Library> list = this.a(parent, (Library)cloudLibrary);
        this.a(parent, list);
        if (this.a.deleteCurrent) {
            this.d(parent, cloudLibrary);
        }
    }

    private List<Library> a(CloudManager cloudManager, Library library) {
        ArrayList<Library> arrayList = new ArrayList<Library>();
        DataProviderBase dataProviderBase = cloudManager.getCloudDataProvider();
        QueryArgs queryArgs = new QueryArgs();
        queryArgs.libraryUniqueId = library.getIdString();
        queryArgs.fetchPolicy = 1;
        if (this.a.recursive) {
            DataManagerHelper.loadLibraryRecursive(dataProviderBase, arrayList, queryArgs);
        } else {
            DataManagerHelper.loadLibraryList(dataProviderBase, arrayList, queryArgs);
        }
        arrayList.add(library);
        return arrayList;
    }

    private QueryArgs a(Library library) {
        QueryArgs queryArgs = new QueryArgs();
        queryArgs.fetchPolicy = 1;
        queryArgs.limit = Integer.MAX_VALUE;
        queryArgs.libraryUniqueId = library.getIdString();
        CloudQueryBuilder.generateMetadataInQueryArgs(queryArgs);
        return queryArgs;
    }

    private QueryResult<Metadata> b(CloudManager cloudManager, Library library) {
        QueryArgs queryArgs = this.a(library);
        DataProviderBase dataProviderBase = cloudManager.getCloudDataProvider();
        return dataProviderBase.findMetadataResultByQueryArgs(this.getContext(), queryArgs);
    }

    private void c(CloudManager cloudManager, Library library) {
        DataProviderBase dataProviderBase = cloudManager.getCloudDataProvider();
        QueryResult<Metadata> queryResult = this.b(cloudManager, library);
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"ContentDatabase").getWritableDatabase();
        databaseWrapper.beginTransaction();
        this.a(dataProviderBase, library);
        if (QueryResult.isValidQueryResult(queryResult)) {
            for (Metadata metadata : queryResult.list) {
                dataProviderBase.deleteMetadataCollection(this.getContext(), library.getIdString(), metadata.getAssociationId());
                this.a(this.getContext(), dataProviderBase, metadata);
            }
        }
        databaseWrapper.setTransactionSuccessful();
        databaseWrapper.endTransaction();
    }

    private void a(CloudManager cloudManager, List<Library> list) {
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        for (Library library : list) {
            this.c(cloudManager, library);
        }
    }

    private void d(CloudManager cloudManager, Library library) {
        Library library2 = cloudManager.getCloudDataProvider().loadLibrary(library.getIdString());
        this.a(cloudManager.getCloudDataProvider(), library2);
    }

    private void a(DataProviderBase dataProviderBase, Library library) {
        if (library == null || !library.hasValidId()) {
            return;
        }
        dataProviderBase.deleteLibrary(library);
    }

    private void a(Context context, DataProviderBase dataProviderBase, Metadata metadata) {
        dataProviderBase.removeMetadata(context, metadata);
        this.a(metadata.getNativeAbsolutePath());
    }

    private void a(String string2) {
        if (StringUtils.isNullOrEmpty((String)string2)) {
            return;
        }
        File file = new File(string2);
        file.delete();
    }
}

