/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.content.Context;
import android.graphics.Bitmap;
import com.onyx.android.sdk.data.GAdapter;
import com.onyx.android.sdk.data.GAdapterUtil;
import com.onyx.android.sdk.data.GObject;
import com.onyx.android.sdk.data.model.BaseData;
import com.onyx.android.sdk.data.model.Category;
import com.onyx.android.sdk.data.model.Dictionary;
import com.onyx.android.sdk.data.model.Link;
import com.onyx.android.sdk.data.model.Product;
import com.onyx.android.sdk.data.model.ProductResult;
import com.onyx.android.sdk.data.utils.CloudConf;
import com.onyx.android.sdk.dataprovider.R;
import com.onyx.android.sdk.device.EnvironmentUtil;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.File;
import java.util.Map;
import retrofit2.Response;

public class CloudUtils {
    private static String a;

    public static final String cloudBaseDir() {
        if (a != null) {
            return a;
        }
        File file = EnvironmentUtil.getExternalStorageDirectory();
        if (file == null) {
            a = "/mnt/sdcard/cloud";
        } else {
            if (!file.exists()) {
                file.mkdirs();
            }
            a = new File(file, "cloud").getAbsolutePath();
        }
        return a;
    }

    public static File baseDataDir(Context context, String string2) {
        File file = new File(CloudUtils.cloudBaseDir(), string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static File imageCacheDirectory(Context context, String string2) {
        return CloudUtils.baseDataDir(context, string2);
    }

    public static File dataCacheDirectory(Context context, String string2) {
        return CloudUtils.baseDataDir(context, string2);
    }

    public static File imageCachePath(Context context, String string2) {
        if (StringUtils.isNullOrEmpty((String)string2)) {
            return null;
        }
        return new File(CloudUtils.imageCacheDirectory(context, string2), "cover.png");
    }

    public static File imageCachePath(Context context, String string2, String string3) {
        if (StringUtils.isNullOrEmpty((String)string2) || StringUtils.isNullOrEmpty((String)string3)) {
            return null;
        }
        return new File(CloudUtils.imageCacheDirectory(context, string2), string3 + ".png");
    }

    public static File dataCachePath(Context context, String string2, String string3, String string4) {
        if (StringUtils.isNullOrEmpty((String)string2)) {
            return null;
        }
        String string5 = !string4.startsWith(".") ? string3 + "." + string4 : string3 + string4;
        File file = new File(CloudUtils.dataCacheDirectory(context, string2), string5);
        return file;
    }

    public static Bitmap localCoverCache(Context context, String string2) {
        File file = CloudUtils.imageCachePath(context, string2);
        Bitmap bitmap = null;
        if (file.exists()) {
            // empty if block
        }
        return bitmap;
    }

    public static Bitmap localCoverBitmap(Context context, String string2) {
        File file = CloudUtils.imageCachePath(context, string2);
        Bitmap bitmap = null;
        if (file.exists()) {
            // empty if block
        }
        return bitmap;
    }

    public static boolean updateFilePath(Context context, Product product, GObject gObject) {
        Map<String, Map<String, Link>> map = product.storage;
        if (CollectionUtils.isNullOrEmpty(map)) {
            return false;
        }
        for (Map.Entry<String, Map<String, Link>> entry : map.entrySet()) {
            File file = CloudUtils.dataCachePath(context, product.getIdString(), product.title, entry.getKey());
            if (file == null || !file.exists()) continue;
            gObject.putString("path", file.getAbsolutePath());
            return true;
        }
        return false;
    }

    public static boolean updateThumbnail(Context context, Product product, GObject gObject) {
        File file = CloudUtils.imageCachePath(context, product.getIdString());
        if (file != null && file.exists()) {
            Object var4_4 = null;
            if (var4_4 != null) {
                gObject.putObject("thumbnail", var4_4);
            }
            return true;
        }
        return false;
    }

    public static final String getCoverUrl(Product product, CloudConf cloudConf) {
        Map<String, Link> map = product.covers.get("gray");
        if (CollectionUtils.isNullOrEmpty(map)) {
            if (product.coverUrl != null) {
                String string2 = product.coverUrl;
                if (!string2.startsWith(cloudConf.getHostBase())) {
                    string2 = cloudConf.getHostBase() + string2;
                }
                return string2;
            }
            return "";
        }
        Link link = map.get(cloudConf.getCloudStorage());
        if (link == null) {
            if (product.coverUrl != null) {
                String string3 = product.coverUrl;
                if (!string3.startsWith(cloudConf.getHostBase())) {
                    string3 = cloudConf.getHostBase() + string3;
                }
                return string3;
            }
            return "";
        }
        return link.url;
    }

    public static GObject objectFromProduct(Context context, Product product, boolean bl, CloudConf cloudConf) {
        if (product == null) {
            return null;
        }
        GObject gObject = new GObject();
        gObject.putString("id", product.getIdString());
        gObject.putString("title_string", product.title);
        gObject.putObject("thumbnail", (Object)R.drawable.cloud_file);
        gObject.putString("cover_url", CloudUtils.getCoverUrl(product, cloudConf));
        gObject.putObject("origin_obj", (Object)product);
        if (bl) {
            CloudUtils.updateThumbnail(context, product, gObject);
        }
        CloudUtils.updateFilePath(context, product, gObject);
        return gObject;
    }

    public static GObject objectFromDictionary(Context context, Dictionary dictionary, boolean bl, CloudConf cloudConf) {
        if (dictionary == null) {
            return null;
        }
        GObject gObject = new GObject();
        gObject.putString("id", dictionary.getIdString());
        gObject.putString("title_string", dictionary.title);
        gObject.putObject("thumbnail", (Object)R.drawable.cloud_file);
        gObject.putString("cover_url", CloudUtils.getCoverUrl(dictionary, cloudConf));
        gObject.putObject("origin_obj", (Object)dictionary);
        if (bl) {
            CloudUtils.updateThumbnail(context, dictionary, gObject);
        }
        CloudUtils.updateFilePath(context, dictionary, gObject);
        return gObject;
    }

    public static GObject objectFromContainer(Category category) {
        if (category == null) {
            return null;
        }
        GObject gObject = new GObject();
        gObject.putString("id", category.getIdString());
        gObject.putString("title_string", category.name);
        gObject.putObject("thumbnail", (Object)R.drawable.cloud_file);
        gObject.putObject("origin_obj", (Object)category);
        return gObject;
    }

    public static GAdapter adapterFromContainerResult(ProductResult<Category> productResult) {
        GAdapter gAdapter = new GAdapter();
        if (productResult == null || productResult.list == null) {
            return gAdapter;
        }
        for (Category category : productResult.list) {
            gAdapter.addObject(CloudUtils.objectFromContainer(category));
        }
        return gAdapter;
    }

    public static GAdapter adapterFromProductResult(Context context, ProductResult<Product> productResult, int n, CloudConf cloudConf) {
        GAdapter gAdapter = new GAdapter();
        if (productResult == null || productResult.list == null) {
            return gAdapter;
        }
        int n2 = 0;
        for (Product product : productResult.list) {
            gAdapter.addObject(CloudUtils.objectFromProduct(context, product, n2++ < n, cloudConf));
        }
        return gAdapter;
    }

    public static GAdapter adapterFromDictionaryResult(Context context, ProductResult<Dictionary> productResult, int n, CloudConf cloudConf) {
        GAdapter gAdapter = new GAdapter();
        if (productResult == null || productResult.list == null) {
            return gAdapter;
        }
        int n2 = 0;
        for (Dictionary dictionary : productResult.list) {
            gAdapter.addObject(CloudUtils.objectFromDictionary(context, dictionary, n2++ < n, cloudConf));
        }
        return gAdapter;
    }

    public static Product originProduct(GObject gObject) {
        Object object = GAdapterUtil.getOriginObject((GObject)gObject);
        Product product = null;
        if (object instanceof Product) {
            product = (Product)((Object)object);
        }
        return product;
    }

    public static <T extends BaseData> boolean isEmpty(ProductResult<T> productResult) {
        return productResult == null || productResult.list == null || productResult.list.size() <= 0;
    }

    public static void dumpResponseMessage(String string2, Response<ProductResult<Product>> response, boolean bl) {
    }
}

