/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import android.app.DownloadManager;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import com.onyx.android.sdk.utils.FileUtils;

public class DownloadUtils {
    static final String a = "download";
    private static final String b = DownloadUtils.class.getSimpleName();

    public static DownloadManager getDownloadManager(Context context) {
        String string2 = a;
        DownloadManager downloadManager = (DownloadManager)context.getSystemService(a);
        return downloadManager;
    }

    public static long queryReferenceByUrl(Context context, String string2) {
        DownloadManager downloadManager = (DownloadManager)context.getSystemService(a);
        DownloadManager.Query query = new DownloadManager.Query();
        Cursor cursor = downloadManager.query(query);
        cursor.moveToFirst();
        long l = -1L;
        while (!cursor.isAfterLast()) {
            String string3 = cursor.getString(cursor.getColumnIndex("uri"));
            if (string3.equalsIgnoreCase(string2)) {
                int n = cursor.getInt(cursor.getColumnIndex("status"));
                if (n == 16) break;
                l = cursor.getInt(cursor.getColumnIndex("_id"));
                break;
            }
            cursor.moveToNext();
        }
        cursor.close();
        return l;
    }

    public static long download(Context context, String string2, String string3) {
        FileUtils.deleteFile((String)string3);
        Uri uri = Uri.parse((String)string2);
        DownloadManager.Request request = new DownloadManager.Request(uri);
        String string4 = String.format("file://%s", string3);
        Uri uri2 = Uri.parse((String)string4);
        request.setDestinationUri(uri2);
        request.setAllowedNetworkTypes(2);
        request.setVisibleInDownloadsUi(false);
        return DownloadUtils.getDownloadManager(context).enqueue(request);
    }

    public static void reportState(Context context, long l, DownloadCallback downloadCallback) {
        DownloadManager.Query query = new DownloadManager.Query();
        query.setFilterById(new long[]{l});
        Cursor cursor = DownloadUtils.getDownloadManager(context).query(query);
        if (cursor.moveToFirst()) {
            int n = cursor.getInt(cursor.getColumnIndex("status"));
            int n2 = cursor.getInt(cursor.getColumnIndex("reason"));
            switch (n) {
                case 4: {
                    Log.v((String)b, (String)"STATUS_PAUSED");
                    break;
                }
                case 1: {
                    Log.v((String)b, (String)"STATUS_PENDING");
                    break;
                }
                case 2: {
                    Log.v((String)b, (String)"STATUS_RUNNING");
                    break;
                }
                case 8: {
                    Log.v((String)b, (String)"Download finished");
                    break;
                }
                case 16: {
                    Log.v((String)b, (String)("STATUS_FAILED reason: " + n2));
                }
            }
            long l2 = cursor.getInt(cursor.getColumnIndex("total_size"));
            long l3 = cursor.getInt(cursor.getColumnIndex("bytes_so_far"));
            cursor.close();
            if (downloadCallback != null) {
                if (l2 > 0L) {
                    downloadCallback.stateChanged(n, l3, l2, l3 * 100L / l2);
                } else {
                    downloadCallback.stateChanged(n, l3, l2, 0L);
                }
            }
        }
    }

    public static class DownloadCallback {
        public void stateChanged(int n, long l, long l2, long l3) {
        }
    }
}

