/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.provider;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.QueryResult;
import com.onyx.android.sdk.data.common.ContentException;
import com.onyx.android.sdk.data.compatability.OnyxThumbnail;
import com.onyx.android.sdk.data.converter.QueryArgsFilter;
import com.onyx.android.sdk.data.model.Annotation;
import com.onyx.android.sdk.data.model.Bookmark;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.MetadataCollection;
import com.onyx.android.sdk.data.model.ProductResult;
import com.onyx.android.sdk.data.model.Thumbnail;
import com.onyx.android.sdk.data.model.Thumbnail_Table;
import com.onyx.android.sdk.data.model.common.FetchPolicy;
import com.onyx.android.sdk.data.model.v2.CloudLibrary;
import com.onyx.android.sdk.data.model.v2.CloudLibrary_Table;
import com.onyx.android.sdk.data.model.v2.CloudMetadata;
import com.onyx.android.sdk.data.model.v2.CloudMetadataCollection;
import com.onyx.android.sdk.data.model.v2.CloudMetadataCollection_Table;
import com.onyx.android.sdk.data.model.v2.CloudMetadata_Table;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.utils.CloudConf;
import com.onyx.android.sdk.data.utils.MetadataUtils;
import com.onyx.android.sdk.data.utils.RetrofitUtils;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.data.v2.ContentService;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.NetworkUtil;
import com.raizlabs.android.dbflow.sql.language.Delete;
import com.raizlabs.android.dbflow.sql.language.Method;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.Where;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import retrofit2.Response;

public class CloudDataProvider
implements DataProviderBase {
    private static final String a = CloudDataProvider.class.getSimpleName();
    private CloudConf b;

    public CloudDataProvider(CloudConf cloudConf) {
        this.b = cloudConf;
    }

    public void setCloudConf(CloudConf cloudConf) {
        this.b = cloudConf;
    }

    @Override
    public void clearMetadata() {
        Delete.table(CloudMetadata.class, (SQLOperator[])new SQLOperator[0]);
    }

    @Override
    public void saveMetadata(Context context, Metadata metadata) {
        metadata.beforeSave();
        Metadata metadata2 = this.a(metadata.getCloudId());
        metadata.setId(metadata2.getId());
        metadata.save();
    }

    private Metadata a(String string2) {
        Metadata metadata = (Metadata)((Object)new Select(new IProperty[0]).from(CloudMetadata.class).where(new SQLOperator[]{CloudMetadata_Table.cloudId.eq((Object)string2)}).querySingle());
        return MetadataUtils.ensureObject(metadata);
    }

    private List<Metadata> a(Context context, QueryArgs queryArgs) {
        if (queryArgs.conditionGroup != null) {
            Where where = new Select(queryArgs.propertyList.toArray(new IProperty[0])).from(CloudMetadata.class).where(new SQLOperator[]{queryArgs.conditionGroup});
            for (OrderBy object2 : queryArgs.orderByList) {
                where.orderBy(object2);
            }
            List list = where.offset(queryArgs.offset).limit(queryArgs.limit).queryList();
            ArrayList<Metadata> arrayList = new ArrayList<Metadata>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                CloudMetadata cloudMetadata = (CloudMetadata)((Object)iterator.next());
                arrayList.add(cloudMetadata);
            }
            return arrayList;
        }
        return new ArrayList<Metadata>();
    }

    private long b(Context context, QueryArgs queryArgs) {
        return new Select(new IProperty[]{Method.count((IProperty[])new IProperty[0])}).from(CloudMetadata.class).where(new SQLOperator[]{queryArgs.conditionGroup}).count();
    }

    private QueryResult<Metadata> c(Context context, QueryArgs queryArgs) {
        QueryResult<Metadata> queryResult = new QueryResult<Metadata>();
        queryResult.list = this.a(context, queryArgs);
        queryResult.count = this.b(context, queryArgs);
        queryResult.fetchSource = Metadata.FetchSource.LOCAL;
        return queryResult;
    }

    private QueryResult<Metadata> d(Context context, QueryArgs queryArgs) {
        QueryResult<Metadata> queryResult;
        block4: {
            queryResult = new QueryResult<Metadata>();
            try {
                Response<ProductResult<CloudMetadata>> response = RetrofitUtils.executeCall(this.a().loadBookList(queryArgs.libraryUniqueId, JSON.toJSONString((Object)queryArgs, (SerializeFilter)new QueryArgsFilter(), (SerializerFeature[])new SerializerFeature[0])));
                if (response.isSuccessful()) {
                    queryResult.list = new ArrayList();
                    for (Metadata metadata : ((ProductResult)response.body()).list) {
                        queryResult.list.add(metadata);
                    }
                    queryResult.count = ((ProductResult)response.body()).count;
                    queryResult.fetchSource = Metadata.FetchSource.CLOUD;
                }
                this.a(queryResult);
            }
            catch (Exception exception) {
                queryResult.setException(ContentException.createException(exception));
                if (FetchPolicy.isCloudOnlyPolicy(queryArgs.fetchPolicy) || FetchPolicy.isMemDbCloudPolicy(queryArgs.fetchPolicy)) break block4;
                queryResult = this.c(context, queryArgs);
            }
        }
        return queryResult;
    }

    private void a(QueryResult<Metadata> queryResult) {
        if (queryResult == null || queryResult.count <= 0L || CollectionUtils.isNullOrEmpty(queryResult.list)) {
            Log.w((String)a, (String)"detect cloud metadata is empty");
        }
    }

    @Override
    public QueryResult<Metadata> findMetadataResultByQueryArgs(Context context, QueryArgs queryArgs) {
        QueryResult<Metadata> queryResult;
        if (FetchPolicy.isCloudPartPolicy(queryArgs.fetchPolicy)) {
            queryResult = this.d(context, queryArgs);
        } else {
            queryResult = this.c(context, queryArgs);
            if (FetchPolicy.isMemDbCloudPolicy(queryArgs.fetchPolicy) && queryResult.isContentEmpty()) {
                queryResult = this.d(context, queryArgs);
            }
        }
        return queryResult;
    }

    @Override
    public List<Metadata> findMetadataByQueryArgs(Context context, QueryArgs queryArgs) {
        QueryResult<Metadata> queryResult = this.findMetadataResultByQueryArgs(context, queryArgs);
        return queryResult.getEnsureList();
    }

    @Override
    public Metadata findMetadataByIdString(Context context, String string2) {
        return null;
    }

    @Override
    public Metadata findMetadataByPath(Context context, String string2) {
        return null;
    }

    @Override
    public Metadata findMetadataByHashTag(Context context, String string2, String string3) {
        return null;
    }

    @Override
    public long count(Context context, QueryArgs queryArgs) {
        long l = NetworkUtil.isWiFiConnected((Context)context) ? this.findMetadataResultByQueryArgs((Context)context, (QueryArgs)queryArgs).count : this.b(context, queryArgs);
        return l;
    }

    @Override
    public void removeMetadata(Context context, Metadata metadata) {
        metadata.delete();
    }

    @Override
    public boolean saveDocumentOptions(Context context, String string2, String string3, String string4) {
        return false;
    }

    @Override
    public List<Annotation> loadAnnotations(String string2, String string3, int n, OrderBy orderBy) {
        return null;
    }

    @Override
    public List<Annotation> loadAnnotations(String string2, String string3, OrderBy orderBy) {
        return null;
    }

    @Override
    public void addAnnotation(Annotation annotation) {
    }

    @Override
    public void updateAnnotation(Annotation annotation) {
    }

    @Override
    public void deleteAnnotation(Annotation annotation) {
    }

    @Override
    public Bookmark loadBookmark(String string2, String string3, int n) {
        return null;
    }

    @Override
    public List<Bookmark> loadBookmarks(String string2, String string3, OrderBy orderBy) {
        return null;
    }

    @Override
    public void addBookmark(Bookmark bookmark) {
    }

    @Override
    public void deleteBookmark(Bookmark bookmark) {
    }

    @Override
    public Library loadLibrary(String string2) {
        return (Library)((Object)new Select(new IProperty[0]).from(CloudLibrary.class).where(new SQLOperator[0]).and((SQLOperator)CloudLibrary_Table.idString.eq((Object)string2)).querySingle());
    }

    @Override
    public QueryResult<Library> fetchAllLibrary(String string2, QueryArgs queryArgs) {
        QueryResult<Library> queryResult;
        if (FetchPolicy.isCloudPartPolicy(queryArgs.fetchPolicy)) {
            queryResult = this.fetchLibraryListFromCloud(queryArgs.libraryUniqueId, queryArgs);
        } else {
            queryResult = this.fetchLibraryListFromLocal(queryArgs.libraryUniqueId);
            if (FetchPolicy.isMemDbCloudPolicy(queryArgs.fetchPolicy) && !QueryResult.isValidQueryResult(queryResult)) {
                queryResult = this.fetchLibraryListFromCloud(queryArgs.libraryUniqueId, queryArgs);
            }
        }
        return queryResult;
    }

    @Override
    public List<Library> loadAllLibrary(String string2, QueryArgs queryArgs) {
        QueryResult<Library> queryResult = this.fetchAllLibrary(string2, queryArgs);
        return queryResult.getEnsureList();
    }

    public QueryResult<Library> fetchLibraryListFromCloud(String string2, QueryArgs queryArgs) {
        QueryResult<Library> queryResult;
        block4: {
            queryResult = new QueryResult<Library>();
            try {
                Response<QueryResult<CloudLibrary>> response = RetrofitUtils.executeCall(this.a().loadLibraryList(string2));
                if (response.isSuccessful()) {
                    queryResult.list = new ArrayList();
                    for (CloudLibrary cloudLibrary : ((QueryResult)response.body()).list) {
                        queryResult.list.add(cloudLibrary);
                    }
                    queryResult.count = ((QueryResult)response.body()).count;
                    queryResult.fetchSource = Metadata.FetchSource.CLOUD;
                }
            }
            catch (Exception exception) {
                if (FetchPolicy.isCloudOnlyPolicy(queryArgs.fetchPolicy) || FetchPolicy.isMemDbCloudPolicy(queryArgs.fetchPolicy)) break block4;
                queryResult = this.fetchLibraryListFromLocal(string2);
            }
        }
        return queryResult;
    }

    public QueryResult<Library> fetchLibraryListFromLocal(String string2) {
        QueryResult<Library> queryResult = new QueryResult<Library>();
        List list = new Select(new IProperty[0]).from(CloudLibrary.class).where(new SQLOperator[0]).and((SQLOperator)CloudLibrary_Table.parentUniqueId.eq((Object)string2)).queryList();
        if (CollectionUtils.isNullOrEmpty((Collection)list)) {
            return queryResult;
        }
        queryResult.list = new ArrayList();
        for (CloudLibrary cloudLibrary : list) {
            queryResult.list.add(cloudLibrary);
        }
        queryResult.count = list.size();
        queryResult.fetchSource = Metadata.FetchSource.LOCAL;
        return queryResult;
    }

    @Override
    public void addLibrary(Library library) {
        Library library2 = this.loadLibrary(library.getIdString());
        if (library2 != null) {
            library.setId(library2.getId());
        }
        library.save();
    }

    @Override
    public void updateLibrary(Library library) {
    }

    @Override
    public void deleteLibrary(Library library) {
        library.delete();
    }

    @Override
    public void clearLibrary() {
        Delete.table(CloudLibrary.class, (SQLOperator[])new SQLOperator[0]);
    }

    @Override
    public void clearThumbnails() {
        Delete.table(Thumbnail.class, (SQLOperator[])new SQLOperator[0]);
    }

    @Override
    public void saveThumbnailEntry(Context context, Thumbnail thumbnail) {
        Thumbnail thumbnail2 = this.getThumbnailEntry(context, thumbnail.getIdString(), thumbnail.getThumbnailKind());
        if (thumbnail2 != null) {
            thumbnail.setId(thumbnail2.getId());
        }
        thumbnail.save();
    }

    @Override
    public Thumbnail getThumbnailEntry(Context context, String string2, OnyxThumbnail.ThumbnailKind thumbnailKind) {
        return (Thumbnail)((Object)new Select(new IProperty[0]).from(Thumbnail.class).where(new SQLOperator[0]).and((SQLOperator)Thumbnail_Table.idString.eq((Object)string2)).and((SQLOperator)Thumbnail_Table.thumbnailKind.eq((Object)thumbnailKind)).querySingle());
    }

    @Override
    public void deleteThumbnailEntry(Thumbnail thumbnail) {
    }

    @Override
    public boolean saveThumbnailBitmap(Context context, String string2, OnyxThumbnail.ThumbnailKind thumbnailKind, Bitmap bitmap) {
        return false;
    }

    @Override
    public Bitmap getThumbnailBitmap(Context context, String string2, OnyxThumbnail.ThumbnailKind thumbnailKind) {
        return null;
    }

    @Override
    public boolean removeThumbnailBitmap(Context context, String string2, OnyxThumbnail.ThumbnailKind thumbnailKind) {
        return false;
    }

    @Override
    public void clearMetadataCollection() {
        Delete.table(CloudMetadataCollection.class, (SQLOperator[])new SQLOperator[0]);
    }

    @Override
    public void addMetadataCollection(Context context, MetadataCollection metadataCollection) {
        MetadataCollection metadataCollection2 = this.loadMetadataCollection(context, metadataCollection.getLibraryUniqueId(), metadataCollection.getDocumentUniqueId());
        if (metadataCollection2 != null) {
            metadataCollection.setId(metadataCollection2.getId());
        }
        metadataCollection.save();
    }

    @Override
    public void deleteMetadataCollection(Context context, String string2, String string3) {
        new Delete().from(CloudMetadataCollection.class).where(new SQLOperator[]{CloudMetadataCollection_Table.libraryUniqueId.eq((Object)string2)}).and((SQLOperator)CloudMetadataCollection_Table.documentUniqueId.eq((Object)string3)).execute();
    }

    @Override
    public void deleteMetadataCollection(Context context, String string2) {
        new Delete().from(CloudMetadataCollection.class).where(new SQLOperator[]{CloudMetadataCollection_Table.libraryUniqueId.eq((Object)string2)}).execute();
    }

    @Override
    public void deleteMetadataCollectionByDocId(Context context, String string2) {
        new Delete().from(CloudMetadataCollection.class).where(new SQLOperator[]{CloudMetadataCollection_Table.documentUniqueId.eq((Object)string2)}).execute();
    }

    @Override
    public void updateMetadataCollection(MetadataCollection metadataCollection) {
        metadataCollection.update();
    }

    @Override
    public MetadataCollection loadMetadataCollection(Context context, String string2, String string3) {
        return (MetadataCollection)((Object)new Select(new IProperty[0]).from(CloudMetadataCollection.class).where(new SQLOperator[]{CloudMetadataCollection_Table.libraryUniqueId.eq((Object)string2)}).and((SQLOperator)CloudMetadataCollection_Table.documentUniqueId.eq((Object)string3)).querySingle());
    }

    @Override
    public List<MetadataCollection> loadMetadataCollection(Context context, String string2) {
        List list = new Select(new IProperty[0]).from(CloudMetadataCollection.class).where(new SQLOperator[]{CloudMetadataCollection_Table.libraryUniqueId.eq((Object)string2)}).queryList();
        if (CollectionUtils.isNullOrEmpty((Collection)list)) {
            return new ArrayList<MetadataCollection>();
        }
        ArrayList<MetadataCollection> arrayList = new ArrayList<MetadataCollection>();
        for (CloudMetadataCollection cloudMetadataCollection : list) {
            arrayList.add(cloudMetadataCollection);
        }
        return arrayList;
    }

    @Override
    public MetadataCollection findMetadataCollection(Context context, String string2) {
        return (MetadataCollection)((Object)new Select(new IProperty[0]).from(CloudMetadataCollection.class).where(new SQLOperator[]{CloudMetadataCollection_Table.documentUniqueId.eq((Object)string2)}).querySingle());
    }

    @Override
    public long libraryCount(String string2) {
        return new Select(new IProperty[]{Method.count((IProperty[])new IProperty[0])}).from(CloudLibrary.class).where(new SQLOperator[]{CloudLibrary_Table.parentUniqueId.eq((Object)string2)}).count();
    }

    private ContentService a() {
        return ServiceFactory.getContentService(this.b.getApiBase());
    }
}

