/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.compatability;

import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.BaseColumns;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.onyx.android.sdk.data.compatability.CursorUtil;
import com.onyx.android.sdk.data.compatability.OnyxBookProgress;
import com.onyx.android.sdk.data.compatability.SerializationUtil;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OnyxMetadata
implements Parcelable {
    private static final String TAG = "OnyxMetadata";
    public static final String DB_TABLE_NAME = "library_metadata";
    public static final Uri CONTENT_URI = Uri.parse((String)"content://com.onyx.android.sdk.OnyxCmsProvider/library_metadata");
    private static final int INVALID_ID = -1;
    private long mId = -1L;
    private String mMD5 = null;
    private String mName = null;
    private String mTitle = null;
    private ArrayList<String> mAuthors = null;
    private String mPublisher = null;
    private String mLanguage = null;
    private String mISBN = null;
    private String mDescription = null;
    private String mLocation = null;
    private String mNativeAbsolutePath = null;
    private long mSize = 0L;
    private String mEncoding = null;
    private Date mLastAccess = null;
    private Date mLastModified = null;
    private OnyxBookProgress mProgress = null;
    private int mFavorite = 0;
    private int mRating = 0;
    private ArrayList<String> mTags = null;
    private Set<String> series = null;
    private int libRefCount = 0;
    private JSONObject mExtraAttributes = new JSONObject();
    private String mType = null;
    private String cloudReference;
    public static final Parcelable.Creator<OnyxMetadata> CREATOR = new Parcelable.Creator<OnyxMetadata>(){

        public OnyxMetadata a(Parcel parcel) {
            Log.i((String)OnyxMetadata.TAG, (String)"Create metadata from parcel!");
            return new OnyxMetadata(parcel);
        }

        public OnyxMetadata[] a(int n) {
            return new OnyxMetadata[n];
        }

        public /* synthetic */ Object[] newArray(int n) {
            return this.a(n);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.a(parcel);
        }
    };

    public OnyxMetadata() {
    }

    public OnyxMetadata(Parcel parcel) {
        this.readFromParcel(parcel);
    }

    public static OnyxMetadata createFromFile(File file) {
        return OnyxMetadata.createFromFile(file, true);
    }

    public static OnyxMetadata createFromFile(String string) {
        return OnyxMetadata.createFromFile(new File(string));
    }

    public static OnyxMetadata createFromFile(File file, boolean bl) {
        try {
            OnyxMetadata onyxMetadata = new OnyxMetadata();
            if (bl) {
                String string = FileUtils.computeMD5((File)file);
                onyxMetadata.setMD5(string);
            }
            OnyxMetadata.getBasicMetadataFromFile(onyxMetadata, file);
            return onyxMetadata;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)TAG, (Throwable)noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            Log.w((String)TAG, (Throwable)iOException);
        }
        return null;
    }

    public static void getBasicMetadataFromFile(OnyxMetadata onyxMetadata, File file) {
        onyxMetadata.setName(file.getName());
        onyxMetadata.setLocation(file.getAbsolutePath());
        onyxMetadata.setNativeAbsolutePath(file.getAbsolutePath());
        onyxMetadata.setSize(file.length());
        onyxMetadata.setlastModified(new Date(FileUtils.getLastChangeTime((File)file)));
        onyxMetadata.setType(FileUtils.getFileExtension((String)file.getName()));
    }

    public Object clone() {
        OnyxMetadata onyxMetadata = new OnyxMetadata();
        onyxMetadata.setId(this.mId);
        onyxMetadata.setMD5(this.mMD5);
        onyxMetadata.setName(this.mName);
        onyxMetadata.setTitle(this.mTitle);
        onyxMetadata.setAuthors(this.mAuthors);
        onyxMetadata.setPublisher(this.mPublisher);
        onyxMetadata.setLanguage(this.mLanguage);
        onyxMetadata.setISBN(this.mISBN);
        onyxMetadata.setDescription(this.mDescription);
        onyxMetadata.setLocation(this.mLocation);
        onyxMetadata.setNativeAbsolutePath(this.mNativeAbsolutePath);
        onyxMetadata.setSize(this.mSize);
        onyxMetadata.setEncoding(this.mEncoding);
        onyxMetadata.setLastAccess(this.mLastAccess);
        onyxMetadata.setlastModified(this.mLastModified);
        onyxMetadata.setProgress(this.mProgress);
        onyxMetadata.setFavorite(this.mFavorite);
        onyxMetadata.setRating(this.mRating);
        onyxMetadata.setTags(this.mTags);
        onyxMetadata.putExtraAttributes((Map<String, Object>)this.mExtraAttributes);
        onyxMetadata.setType(this.mType);
        onyxMetadata.setCloudReference(this.cloudReference);
        onyxMetadata.setSeries(this.series);
        onyxMetadata.setLibRefCount(this.libRefCount);
        return onyxMetadata;
    }

    public boolean isDataFromDB() {
        return this.mId != -1L;
    }

    public long getId() {
        return this.mId;
    }

    public void setId(long l) {
        this.mId = l;
    }

    public String getMD5() {
        return this.mMD5;
    }

    public void setMD5(String string) {
        this.mMD5 = string;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String string) {
        this.mName = string;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String string) {
        this.mTitle = string;
    }

    public ArrayList<String> getAuthors() {
        return this.mAuthors;
    }

    public String getAuthorsString() {
        if (this.mAuthors != null) {
            return StringUtils.join(this.mAuthors, (String)",");
        }
        return "";
    }

    public String getAuthorsStringWithCustomSeparator(String string) {
        if (this.mAuthors != null) {
            return StringUtils.join(this.mAuthors, (String)string);
        }
        return "";
    }

    public void setAuthors(ArrayList<String> arrayList) {
        this.mAuthors = arrayList;
    }

    public String getPublisher() {
        return this.mPublisher;
    }

    public void setPublisher(String string) {
        this.mPublisher = string;
    }

    public String getLanguage() {
        return this.mLanguage;
    }

    public void setLanguage(String string) {
        this.mLanguage = string;
    }

    public String getISBN() {
        return this.mISBN;
    }

    public void setISBN(String string) {
        this.mISBN = string;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String string) {
        this.mDescription = string;
    }

    public String getLocation() {
        return this.mLocation;
    }

    public void setLocation(String string) {
        this.mLocation = string;
    }

    public String getNativeAbsolutePath() {
        return this.mNativeAbsolutePath;
    }

    public void setNativeAbsolutePath(String string) {
        this.mNativeAbsolutePath = string;
    }

    public long getSize() {
        return this.mSize;
    }

    public void setSize(long l) {
        this.mSize = l;
    }

    public String getEncoding() {
        return this.mEncoding;
    }

    public void setEncoding(String string) {
        this.mEncoding = string;
    }

    public Date getLastAccess() {
        return this.mLastAccess;
    }

    public void setLastAccess(Date date) {
        this.mLastAccess = date;
    }

    public void updateLastAccess() {
        this.mLastAccess = new Date();
    }

    public Date getLastModified() {
        return this.mLastModified;
    }

    public void setlastModified(Date date) {
        this.mLastModified = date;
    }

    public OnyxBookProgress getProgress() {
        return this.mProgress;
    }

    public void setProgress(OnyxBookProgress onyxBookProgress) {
        this.mProgress = onyxBookProgress;
    }

    public boolean isReaded() {
        return this.mProgress != null && this.mProgress.isFinished();
    }

    public boolean isReading() {
        return this.mProgress != null;
    }

    public boolean isNew() {
        return this.mProgress == null;
    }

    public int getFavorite() {
        return this.mFavorite;
    }

    public void setFavorite(int n) {
        this.mFavorite = n;
    }

    public int getRating() {
        return this.mRating;
    }

    public void setRating(int n) {
        this.mRating = n;
    }

    public ArrayList<String> getTags() {
        return this.mTags;
    }

    public void setTags(ArrayList<String> arrayList) {
        this.mTags = arrayList;
    }

    public String getTagsString() {
        if (this.mTags != null) {
            return StringUtils.join(this.mTags, (String)", ");
        }
        return "";
    }

    public JSONObject getExtraAttributes() {
        return this.mExtraAttributes;
    }

    public void putExtraAttribute(String string, Object object) {
        this.mExtraAttributes.put(string, object);
    }

    public void putExtraAttributes(Map<String, Object> map) {
        if (map != null) {
            this.mExtraAttributes.putAll(map);
        }
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String string) {
        this.mType = string;
    }

    public String getCloudReference() {
        return this.cloudReference;
    }

    public void setCloudReference(String string) {
        this.cloudReference = string;
    }

    public final Set<String> getSeries() {
        return this.series;
    }

    public final String getSeriesString() {
        return SerializationUtil.setToString(this.series);
    }

    public void setSeries(Set<String> set) {
        this.series = set;
    }

    public int getLibRefCount() {
        return this.libRefCount;
    }

    public void setLibRefCount(int n) {
        this.libRefCount = n;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeLong(this.mId);
        parcel.writeString(this.mMD5);
        parcel.writeString(this.mName);
        parcel.writeString(this.mTitle);
        parcel.writeStringList(this.mAuthors);
        parcel.writeString(this.mPublisher);
        parcel.writeString(this.mLanguage);
        parcel.writeString(this.mISBN);
        parcel.writeString(this.mDescription);
        parcel.writeString(this.mLocation);
        parcel.writeString(this.mNativeAbsolutePath);
        parcel.writeLong(this.mSize);
        parcel.writeString(this.mEncoding);
        parcel.writeString(SerializationUtil.dateToString(this.mLastAccess));
        parcel.writeString(SerializationUtil.dateToString(this.mLastModified));
        parcel.writeInt(this.mFavorite);
        parcel.writeInt(this.mRating);
        parcel.writeStringList(this.mTags);
        parcel.writeString(JSON.toJSONString((Object)this.mExtraAttributes));
        parcel.writeString(this.mType);
        parcel.writeString(this.cloudReference);
        if (this.series != null && this.series.size() > 0) {
            parcel.writeStringList(new ArrayList<String>(this.series));
        }
        parcel.writeInt(this.libRefCount);
    }

    public void readFromParcel(Parcel parcel) {
        this.mId = parcel.readLong();
        this.mMD5 = parcel.readString();
        this.mName = parcel.readString();
        this.mTitle = parcel.readString();
        this.mAuthors = new ArrayList();
        parcel.readStringList(this.mAuthors);
        this.mPublisher = parcel.readString();
        this.mLanguage = parcel.readString();
        this.mISBN = parcel.readString();
        this.mDescription = parcel.readString();
        this.mLocation = parcel.readString();
        this.mNativeAbsolutePath = parcel.readString();
        this.mSize = parcel.readLong();
        this.mEncoding = parcel.readString();
        this.mLastAccess = SerializationUtil.dateFromString(parcel.readString());
        this.mLastModified = SerializationUtil.dateFromString(parcel.readString());
        this.mFavorite = parcel.readInt();
        this.mRating = parcel.readInt();
        this.mTags = new ArrayList();
        parcel.readStringList(this.mTags);
        this.mExtraAttributes = JSON.parseObject((String)parcel.readString());
        this.mType = parcel.readString();
        this.cloudReference = parcel.readString();
        ArrayList arrayList = new ArrayList();
        parcel.readStringList(arrayList);
        if (arrayList.size() > 0) {
            this.series = new HashSet<String>(arrayList);
        }
        this.libRefCount = parcel.readInt();
    }

    public static class Columns
    implements BaseColumns {
        public static String MD5 = "MD5";
        public static String NAME = "Name";
        public static String TITLE = "Title";
        public static String AUTHORS = "Authors";
        public static String PUBLISHER = "Publisher";
        public static String LANGUAGE = "Language";
        public static String ISBN = "ISBN";
        public static String DESCRIPTION = "Description";
        public static String LOCATION = "Location";
        public static String NATIVE_ABSOLUTE_PATH = "NativeAbsolutePath";
        public static String SIZE = "Size";
        public static String ENCODING = "Encoding";
        public static String LAST_ACCESS = "LastAccess";
        public static String LAST_MODIFIED = "LastModified";
        public static String PROGRESS = "Progress";
        public static String FAVORITE = "Favorite";
        public static String RATING = "Rating";
        public static String TAGS = "Tags";
        public static String EXTRA_ATTRIBUTES = "ExtraAttributes";
        public static String TYPE = "Type";
        public static String CLOUD_REFERENCE = "CloudReference";
        public static String SERIES = "Series";
        public static String LIB_REF_COUNT = "LibRefCount";
        private static boolean a = false;
        private static int b = -1;
        private static int c = -1;
        private static int d = -1;
        private static int e = -1;
        private static int f = -1;
        private static int g = -1;
        private static int h = -1;
        private static int i = -1;
        private static int j = -1;
        private static int k = -1;
        private static int l = -1;
        private static int m = -1;
        private static int n = -1;
        private static int o = -1;
        private static int p = -1;
        private static int q = -1;
        private static int r = -1;
        private static int s = -1;
        private static int t = -1;
        private static int u = -1;
        private static int v = -1;
        private static int w = -1;
        private static int x = -1;
        private static int y = -1;

        public static ContentValues createColumnData(OnyxMetadata onyxMetadata) {
            ContentValues contentValues = new ContentValues();
            contentValues.put(MD5, onyxMetadata.getMD5());
            contentValues.put(NAME, onyxMetadata.getName());
            contentValues.put(TITLE, onyxMetadata.getTitle());
            contentValues.put(AUTHORS, SerializationUtil.authorsToString(onyxMetadata.getAuthors()));
            contentValues.put(PUBLISHER, onyxMetadata.getPublisher());
            contentValues.put(LANGUAGE, onyxMetadata.getLanguage());
            contentValues.put(ISBN, onyxMetadata.getISBN());
            contentValues.put(DESCRIPTION, onyxMetadata.getDescription());
            contentValues.put(LOCATION, onyxMetadata.getLocation());
            contentValues.put(NATIVE_ABSOLUTE_PATH, onyxMetadata.getNativeAbsolutePath());
            contentValues.put(SIZE, Long.valueOf(onyxMetadata.getSize()));
            contentValues.put(ENCODING, onyxMetadata.getEncoding());
            contentValues.put(LAST_ACCESS, onyxMetadata.getLastAccess() == null ? null : Long.valueOf(onyxMetadata.getLastAccess().getTime()));
            contentValues.put(LAST_MODIFIED, onyxMetadata.getLastModified() == null ? null : Long.valueOf(onyxMetadata.getLastModified().getTime()));
            contentValues.put(PROGRESS, onyxMetadata.getProgress() == null ? null : onyxMetadata.getProgress().toString());
            contentValues.put(FAVORITE, Integer.valueOf(onyxMetadata.getFavorite()));
            contentValues.put(RATING, Integer.valueOf(onyxMetadata.getRating()));
            contentValues.put(TAGS, SerializationUtil.tagsToString(onyxMetadata.getTags()));
            contentValues.put(EXTRA_ATTRIBUTES, JSON.toJSONString((Object)onyxMetadata.getExtraAttributes()));
            contentValues.put(TYPE, onyxMetadata.getType());
            contentValues.put(CLOUD_REFERENCE, onyxMetadata.getCloudReference());
            contentValues.put(SERIES, SerializationUtil.setToString(onyxMetadata.getSeries()));
            contentValues.put(LIB_REF_COUNT, Integer.valueOf(onyxMetadata.getLibRefCount()));
            return contentValues;
        }

        public static void readColumnData(Cursor cursor, OnyxMetadata onyxMetadata) {
            JSONObject jSONObject;
            if (!a) {
                b = cursor.getColumnIndex("_id");
                c = cursor.getColumnIndex(MD5);
                d = cursor.getColumnIndex(NAME);
                e = cursor.getColumnIndex(TITLE);
                f = cursor.getColumnIndex(AUTHORS);
                g = cursor.getColumnIndex(PUBLISHER);
                h = cursor.getColumnIndex(LANGUAGE);
                i = cursor.getColumnIndex(ISBN);
                j = cursor.getColumnIndex(DESCRIPTION);
                k = cursor.getColumnIndex(LOCATION);
                l = cursor.getColumnIndex(NATIVE_ABSOLUTE_PATH);
                m = cursor.getColumnIndex(SIZE);
                n = cursor.getColumnIndex(ENCODING);
                o = cursor.getColumnIndex(LAST_ACCESS);
                p = cursor.getColumnIndex(LAST_MODIFIED);
                q = cursor.getColumnIndex(PROGRESS);
                r = cursor.getColumnIndex(FAVORITE);
                s = cursor.getColumnIndex(RATING);
                t = cursor.getColumnIndex(TAGS);
                u = cursor.getColumnIndex(EXTRA_ATTRIBUTES);
                v = cursor.getColumnIndex(TYPE);
                w = cursor.getColumnIndex(CLOUD_REFERENCE);
                x = cursor.getColumnIndex(SERIES);
                y = cursor.getColumnIndex(LIB_REF_COUNT);
                a = true;
            }
            long l = CursorUtil.getLong(cursor, b);
            String string = CursorUtil.getString(cursor, c);
            String string2 = CursorUtil.getString(cursor, d);
            String string3 = CursorUtil.getString(cursor, e);
            String string4 = CursorUtil.getString(cursor, f);
            String string5 = CursorUtil.getString(cursor, g);
            String string6 = CursorUtil.getString(cursor, h);
            String string7 = CursorUtil.getString(cursor, i);
            String string8 = CursorUtil.getString(cursor, j);
            String string9 = CursorUtil.getString(cursor, k);
            String string10 = CursorUtil.getString(cursor, Columns.l);
            Long l2 = CursorUtil.getLong(cursor, m);
            String string11 = CursorUtil.getString(cursor, n);
            Long l3 = CursorUtil.getLong(cursor, o);
            Long l4 = CursorUtil.getLong(cursor, p);
            OnyxBookProgress onyxBookProgress = OnyxBookProgress.fromString(CursorUtil.getString(cursor, q));
            int n = cursor.getInt(r);
            int n2 = cursor.getInt(s);
            String string12 = CursorUtil.getString(cursor, t);
            String string13 = CursorUtil.getString(cursor, w);
            String string14 = CursorUtil.getString(cursor, x);
            int n3 = cursor.getInt(y);
            try {
                jSONObject = (JSONObject)JSON.parseObject((String)CursorUtil.getString(cursor, u), JSONObject.class);
            }
            catch (Throwable throwable) {
                jSONObject = new JSONObject();
            }
            String string15 = CursorUtil.getString(cursor, v);
            onyxMetadata.setId(l);
            onyxMetadata.setMD5(string);
            onyxMetadata.setName(string2);
            onyxMetadata.setTitle(string3);
            onyxMetadata.setAuthors(SerializationUtil.authorsFromString(string4));
            onyxMetadata.setPublisher(string5);
            onyxMetadata.setLanguage(string6);
            onyxMetadata.setISBN(string7);
            onyxMetadata.setDescription(string8);
            onyxMetadata.setLocation(string9);
            onyxMetadata.setNativeAbsolutePath(string10);
            if (l3 != null && l3 > 0L) {
                onyxMetadata.setLastAccess(new Date(l3));
            }
            onyxMetadata.setlastModified(new Date(l4 == null ? 0L : l4));
            onyxMetadata.setSize(l2 == null ? 0L : l2);
            onyxMetadata.setEncoding(string11);
            onyxMetadata.setProgress(onyxBookProgress);
            onyxMetadata.setFavorite(n);
            onyxMetadata.setRating(n2);
            onyxMetadata.setTags(SerializationUtil.tagsFromString(string12));
            onyxMetadata.putExtraAttributes((Map<String, Object>)jSONObject);
            onyxMetadata.setType(string15);
            onyxMetadata.setCloudReference(string13);
            onyxMetadata.setSeries(SerializationUtil.setFromString(string14));
            onyxMetadata.setLibRefCount(n3);
        }

        public static OnyxMetadata readColumnData(Cursor cursor) {
            OnyxMetadata onyxMetadata = new OnyxMetadata();
            Columns.readColumnData(cursor, onyxMetadata);
            return onyxMetadata;
        }
    }
}

