/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.data.fs;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.util.Log;
import com.onyx.android.sdk.data.AppDataInfo;
import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.data.request.data.fs.BaseFSRequest;
import com.onyx.android.sdk.utils.ApplicationUtil;
import com.onyx.android.sdk.utils.Benchmark;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.ComparatorUtils;
import com.onyx.android.sdk.utils.RawResourceUtil;
import com.onyx.android.sdk.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class ApplicationListLoadRequest
extends BaseFSRequest {
    private static final String a = "AppLoadRequest";
    private List<String> b;
    private List<String> c;
    private Map<String, String> d;
    private List<AppDataInfo> e = new ArrayList<AppDataInfo>();
    private List<AppDataInfo> f = new ArrayList<AppDataInfo>();
    private SortBy g;
    private SortOrder h;
    private boolean i = false;

    public ApplicationListLoadRequest(DataManager dataManager, List<String> ignoreAppList, List<String> testAppList, Map<String, String> customizedIconAppsMap) {
        super(dataManager);
        this.b = ignoreAppList;
        this.c = testAppList;
        this.d = customizedIconAppsMap;
    }

    public List<AppDataInfo> getAppInfoList() {
        return this.f;
    }

    public boolean isTestAppExist() {
        return this.i;
    }

    public void setSort(SortBy sortBy, SortOrder sortOrder) {
        this.g = sortBy;
        this.h = sortOrder;
    }

    public void addExtraAppData(List<AppDataInfo> list) {
        CollectionUtils.safeAddAll(this.e, list);
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        this.a();
        this.b();
        if (this.c()) {
            this.a(this.f, this.g, this.h);
        }
    }

    private void a() {
        for (AppDataInfo appDataInfo : this.e) {
            AppDataInfo appDataInfo2 = this.a(appDataInfo);
            if (appDataInfo2 == null) continue;
            this.f.add(appDataInfo2);
        }
    }

    private void b() throws Exception {
        Intent intent = new Intent("android.intent.action.MAIN", null);
        intent.addCategory("android.intent.category.LAUNCHER");
        List list = this.getContext().getPackageManager().getInstalledPackages(0);
        List list2 = this.getContext().getPackageManager().queryIntentActivities(intent, 0);
        for (PackageInfo packageInfo : list) {
            AppDataInfo appDataInfo;
            String string2 = packageInfo.applicationInfo.packageName;
            if (CollectionUtils.safelyContains(this.b, (String)string2)) continue;
            if (CollectionUtils.safelyContains(this.c, (String)string2)) {
                if (ApplicationUtil.testAppRecordExist((Context)this.getContext(), (String)string2)) continue;
                this.i = true;
                appDataInfo = ApplicationUtil.appDataFromPackageInfo((Context)this.getContext(), (PackageInfo)packageInfo);
            } else {
                appDataInfo = ApplicationUtil.appDataFromPackageInfo((Context)this.getContext(), (List)list2, (PackageInfo)packageInfo);
            }
            ApplicationUtil.checkCustomIcon((Context)this.getContext(), this.d, (AppDataInfo)appDataInfo);
            if (appDataInfo == null) continue;
            this.f.add(appDataInfo);
        }
    }

    private AppDataInfo a(AppDataInfo appDataInfo) {
        if (appDataInfo == null || StringUtils.isNullOrEmpty((String)appDataInfo.packageName)) {
            return null;
        }
        if (appDataInfo.intent != null) {
            return appDataInfo;
        }
        AppDataInfo appDataInfo2 = null;
        PackageInfo packageInfo = ApplicationUtil.getPackageInfoFromPackageName((Context)this.getContext(), (String)appDataInfo.packageName);
        if (packageInfo != null) {
            appDataInfo.lastUpdatedTime = packageInfo.lastUpdateTime;
            appDataInfo2 = ApplicationUtil.appDataFromPackageInfo((Context)this.getContext(), (PackageInfo)packageInfo);
        }
        if (StringUtils.isNullOrEmpty((String)appDataInfo.activityClassName)) {
            return appDataInfo2;
        }
        appDataInfo.intent = new Intent();
        appDataInfo.intent.setComponent(new ComponentName(appDataInfo.packageName, appDataInfo.activityClassName));
        String string2 = RawResourceUtil.getStringByResourceName((Context)this.getContext(), (String)appDataInfo.labelName);
        if (StringUtils.isNotBlank((String)string2)) {
            appDataInfo.labelName = string2;
        }
        if (appDataInfo.iconDrawable == null && StringUtils.isNotBlank((String)appDataInfo.iconDrawableName)) {
            appDataInfo.iconDrawable = RawResourceUtil.getDrawableByResourceName((Context)this.getContext(), (String)appDataInfo.iconDrawableName);
            if (appDataInfo.iconDrawable == null && appDataInfo2 != null) {
                appDataInfo.iconDrawable = appDataInfo2.iconDrawable;
            }
        }
        return appDataInfo;
    }

    private boolean c() {
        return this.g != null && this.h != null;
    }

    private void a(List<AppDataInfo> list, SortBy sortBy, SortOrder sortOrder) {
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        Benchmark benchmark = new Benchmark();
        switch (sortBy) {
            case Name: {
                ApplicationListLoadRequest.sortListByName(list, sortOrder);
                break;
            }
            case InstallTime: {
                ApplicationListLoadRequest.sortListByInstallTime(list, sortOrder);
            }
        }
        Log.w((String)a, (String)("Sort duration:" + benchmark.duration() + "ms"));
    }

    public static void sortListByName(List<AppDataInfo> fileList, final SortOrder sortOrder) {
        Collections.sort(fileList, new Comparator<AppDataInfo>(){

            public int a(AppDataInfo appDataInfo, AppDataInfo appDataInfo2) {
                return ComparatorUtils.stringComparator((String)appDataInfo.labelName, (String)appDataInfo2.labelName, (SortOrder)sortOrder);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((AppDataInfo)object, (AppDataInfo)object2);
            }
        });
    }

    public static void sortListByInstallTime(List<AppDataInfo> fileList, final SortOrder sortOrder) {
        Collections.sort(fileList, new Comparator<AppDataInfo>(){

            public int a(AppDataInfo appDataInfo, AppDataInfo appDataInfo2) {
                return ComparatorUtils.longComparator((long)appDataInfo.lastUpdatedTime, (long)appDataInfo2.lastUpdatedTime, (SortOrder)sortOrder);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((AppDataInfo)object, (AppDataInfo)object2);
            }
        });
    }
}

