/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.manager;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import com.liulishuo.filedownloader.BaseDownloadTask;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.OnyxDownloadManager;
import com.onyx.android.sdk.data.model.ApplicationUpdate;
import com.onyx.android.sdk.data.request.cloud.ApplicationUpdateRequest;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.NotificationItem;
import com.onyx.android.sdk.rx.RxCallback;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.PackageUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class AppUpdateManager {
    public static final String PHONE_APPLICATION_MODEL = "mobile";

    public static ApplicationUpdate getApplicationUpdate(Context context) {
        ApplicationUpdate applicationUpdate = ApplicationUpdate.create(context);
        applicationUpdate.model = PHONE_APPLICATION_MODEL;
        return applicationUpdate;
    }

    public static String getApkFilePath(Context context, ApplicationUpdate update) {
        String string = update.packageName.replaceAll("\\.", "_");
        return new File(context.getExternalCacheDir(), string + "_" + update.versionCode + ".apk").getAbsolutePath();
    }

    private static String a(ApplicationUpdate applicationUpdate) {
        return applicationUpdate.getFirstDownloadUrl();
    }

    public static void checkUpdate(Context context, CloudManager cloudManager, AppUpdateConfig config) {
        AppUpdateManager.checkUpdate(context, cloudManager, config, null);
    }

    public static void checkUpdate(Context context, CloudManager cloudManager, AppUpdateConfig config, RxCallback customCallBack) {
        ArrayList<ApplicationUpdate> arrayList = new ArrayList<ApplicationUpdate>();
        ApplicationUpdate applicationUpdate = AppUpdateManager.getApplicationUpdate(context);
        if (StringUtils.isNotBlank((String)config.model)) {
            applicationUpdate.model = config.model;
        }
        arrayList.add(applicationUpdate);
        AppUpdateManager.checkUpdate(context, cloudManager, config, arrayList, customCallBack);
    }

    public static void checkUpdate(final Context context, CloudManager cloudManager, final AppUpdateConfig config, List<ApplicationUpdate> queryList, final RxCallback customCallBack) {
        final ApplicationUpdateRequest applicationUpdateRequest = new ApplicationUpdateRequest(cloudManager, queryList);
        cloudManager.submitRequest(context, (BaseCloudRequest)applicationUpdateRequest, new RxCallback(){

            public void onNext(@NonNull Object o) {
                RxCallback.onNext((RxCallback)customCallBack, (Object)o);
                if (config.autoDownload) {
                    AppUpdateManager.checkUpdatedFileDownload(context, config, applicationUpdateRequest.getUpdateList(), null);
                }
            }

            public void onError(@NonNull Throwable e) {
                RxCallback.onError((RxCallback)customCallBack, (Throwable)e);
            }
        });
    }

    private static PendingIntent a(Context context, File file) {
        return PendingIntent.getActivity((Context)context, (int)0, (Intent)PackageUtils.getInstallIntent((File)file), (int)0x8000000);
    }

    private static NotificationItem.NotificationBean a(Context context, AppUpdateConfig appUpdateConfig, ApplicationUpdate applicationUpdate, File file) {
        NotificationItem.NotificationBean notificationBean = new NotificationItem.NotificationBean();
        notificationBean.title = PackageUtils.getAppDisplayName((Context)context, (String)context.getPackageName());
        notificationBean.desc = applicationUpdate.versionName;
        notificationBean.icon = appUpdateConfig.notificationSmallIcon;
        notificationBean.largeIcon = appUpdateConfig.notificationLargeIcon;
        notificationBean.pendingIntent = AppUpdateManager.a(context, file);
        return notificationBean;
    }

    public static boolean checkUpdatedFileDownload(Context context, AppUpdateConfig config, ApplicationUpdate update, RxCallback downloadCallback) {
        if (update == null) {
            return false;
        }
        String string = AppUpdateManager.getApkFilePath(context, update);
        File file = new File(string);
        String string2 = AppUpdateManager.a(update);
        if (StringUtils.isNullOrEmpty((String)string2)) {
            return false;
        }
        BaseDownloadTask baseDownloadTask = OnyxDownloadManager.getInstance().downloadWithNotify(string2, string, string, AppUpdateManager.a(context, config, update, file), downloadCallback);
        baseDownloadTask.setForceReDownload(true);
        return OnyxDownloadManager.getInstance().startDownload(baseDownloadTask) != 0;
    }

    public static boolean checkUpdatedFileDownload(Context context, AppUpdateConfig config, List<ApplicationUpdate> updatingList, RxCallback downloadCallback) {
        if (CollectionUtils.isNullOrEmpty(updatingList)) {
            return false;
        }
        boolean bl = true;
        for (ApplicationUpdate applicationUpdate : updatingList) {
            bl &= AppUpdateManager.checkUpdatedFileDownload(context, config, applicationUpdate, downloadCallback);
        }
        return bl;
    }

    public static class AppUpdateConfig {
        public int notificationSmallIcon;
        public Bitmap notificationLargeIcon;
        public boolean autoDownload;
        public String model;

        public static AppUpdateConfig create(int smallIcon, boolean autoDownload) {
            AppUpdateConfig appUpdateConfig = new AppUpdateConfig();
            appUpdateConfig.notificationSmallIcon = smallIcon;
            appUpdateConfig.autoDownload = autoDownload;
            return appUpdateConfig;
        }
    }
}

