/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.utils;

import com.onyx.android.sdk.data.BookFilter;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.MetadataCollection;
import com.onyx.android.sdk.data.model.MetadataCollection_Table;
import com.onyx.android.sdk.data.model.Metadata_Table;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.language.BaseModelQueriable;
import com.raizlabs.android.dbflow.sql.language.Operator;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.Where;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.language.property.Property;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class QueryBuilder {
    public static QueryArgs libraryAllBookQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = QueryBuilder.allBooksQuery(sortBy, sortOrder);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return QueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryAllBookQuery(String libraryUniqueId, Set<String> fileTypes, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = QueryBuilder.allBooksQuery(fileTypes, sortBy, sortOrder);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return QueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryAllBookQuery(String libraryUniqueId, Set<String> fileTypes, OrderBy orderBy) {
        QueryArgs queryArgs = QueryArgs.queryBy(QueryBuilder.orTypeCondition(fileTypes), orderBy);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return QueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryBookListNewQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = QueryBuilder.newBookListQuery(sortBy, sortOrder);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return QueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryFinishReadQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = QueryBuilder.finishReadQuery(sortBy, sortOrder);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return QueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryRecentReadingQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = QueryBuilder.recentReadingQuery(sortBy, sortOrder);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return QueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryRecentAddQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder);
        queryArgs.libraryUniqueId = libraryUniqueId;
        queryArgs.conditionGroup = QueryBuilder.recentAddCondition();
        return QueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryTagsFilterQuery(String libraryUniqueId, Set<String> tags, SortBy sortBy, SortOrder order) {
        QueryArgs queryArgs = QueryBuilder.tagsFilterQuery(tags, sortBy, order);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return QueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs librarySearchQuery(String libraryUniqueId, String search, SortBy sortBy, SortOrder order) {
        QueryArgs queryArgs = QueryBuilder.searchQuery(search, sortBy, order);
        queryArgs.libraryUniqueId = libraryUniqueId;
        return QueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs libraryBooksQuery(String libraryUniqueId, SortBy sortBy, SortOrder sortOrder, BookFilter filter) {
        QueryArgs queryArgs = QueryBuilder.booksQuery(sortBy, sortOrder, filter).setLibraryUniqueId(libraryUniqueId);
        return QueryBuilder.generateMetadataInQueryArgs(queryArgs);
    }

    public static QueryArgs allBooksQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.ALL);
        return QueryBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs allBooksQuery(Set<String> fileTypes, SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.ALL);
        queryArgs.fileType = fileTypes;
        return QueryBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs allBooksQuery(Set<String> fileTypes, OrderBy orderBy) {
        return QueryArgs.queryBy(QueryBuilder.orTypeCondition(fileTypes), orderBy);
    }

    public static QueryArgs booksQuery(SortBy sortBy, SortOrder sortOrder, BookFilter filter) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder).appendFilter(filter);
        return QueryBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs newBookListQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.NEW);
        return QueryBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs finishReadQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.FINISHED);
        return QueryBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs recentReadingQuery(SortBy sortBy, SortOrder sortOrder) {
        QueryArgs queryArgs = new QueryArgs(sortBy, sortOrder).appendFilter(BookFilter.READING);
        return QueryBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs tagsFilterQuery(Set<String> tags, SortBy sortBy, SortOrder order) {
        QueryArgs queryArgs = new QueryArgs(sortBy, order).appendFilter(BookFilter.TAG);
        queryArgs.tags = tags;
        return QueryBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs searchQuery(String search, SortBy sortBy, SortOrder order) {
        QueryArgs queryArgs = new QueryArgs(sortBy, order).appendFilter(BookFilter.SEARCH);
        queryArgs.query = search;
        return QueryBuilder.generateQueryArgs(queryArgs);
    }

    public static QueryArgs recentAddQuery() {
        QueryArgs queryArgs = QueryArgs.queryBy(QueryBuilder.recentAddCondition(), QueryBuilder.getOrderByUpdateAt().descending());
        return queryArgs;
    }

    public static Property<Integer> getMetadataReadingStatusProperty() {
        return Metadata_Table.readingStatus;
    }

    public static Property<String> getMetadataTypeProperty() {
        return Metadata_Table.type;
    }

    public static Property<String> getMetadataTitleProperty() {
        return Metadata_Table.title;
    }

    public static Property<Integer> getMetadataFetchSourceProperty() {
        return Metadata_Table.fetchSource;
    }

    public static Property<String> getMetadataCloudIdProperty() {
        return Metadata_Table.cloudId;
    }

    public static Property<String> getMetadataNameProperty() {
        return Metadata_Table.name;
    }

    public static Property<String> getMetadataAuthorsProperty() {
        return Metadata_Table.authors;
    }

    public static Property<String> getMetadataPublisherProperty() {
        return Metadata_Table.publisher;
    }

    public static Property<String> getMetadataTagsProperty() {
        return Metadata_Table.tags;
    }

    public static Property<String> getMetadataSeriesProperty() {
        return Metadata_Table.series;
    }

    public static Property<String> getMetadataIdStringProperty() {
        return Metadata_Table.idString;
    }

    public static Property<Long> getMetadataSizeProperty() {
        return Metadata_Table.size;
    }

    public static Property<Date> getMetadataCreatedAtProperty() {
        return Metadata_Table.createdAt;
    }

    public static Property<Date> getMetadataLastAccessProperty() {
        return Metadata_Table.lastAccess;
    }

    public static Property<Integer> getMetadataOrdinalProperty() {
        return Metadata_Table.ordinal;
    }

    public static Property<String> getMetadataCollectionDocIdProperty() {
        return MetadataCollection_Table.documentUniqueId;
    }

    public static Property<String> getMetadataCollectionLibraryIdProperty() {
        return MetadataCollection_Table.libraryUniqueId;
    }

    public static OperatorGroup newBookListCondition() {
        return OperatorGroup.clause().and((SQLOperator)QueryBuilder.getMetadataReadingStatusProperty().eq((Object)Metadata.ReadingStatus.NEW));
    }

    public static OperatorGroup finishReadCondition() {
        return OperatorGroup.clause().and((SQLOperator)QueryBuilder.getMetadataReadingStatusProperty().eq((Object)Metadata.ReadingStatus.FINISHED));
    }

    public static OperatorGroup recentReadingCondition() {
        return OperatorGroup.clause().and((SQLOperator)QueryBuilder.getMetadataReadingStatusProperty().eq((Object)Metadata.ReadingStatus.READING));
    }

    public static OperatorGroup recentAddCondition() {
        return OperatorGroup.clause().and((SQLOperator)QueryBuilder.getMetadataReadingStatusProperty().eq((Object)Metadata.ReadingStatus.NEW));
    }

    public static OperatorGroup orTypeCondition(Set<String> fileTypes) {
        if (CollectionUtils.isNullOrEmpty(fileTypes)) {
            return OperatorGroup.clause();
        }
        OperatorGroup operatorGroup = OperatorGroup.clause();
        ArrayList<Operator> arrayList = new ArrayList<Operator>();
        for (String string2 : fileTypes) {
            arrayList.add(QueryBuilder.getMetadataTypeProperty().eq((Object)string2));
        }
        return operatorGroup.orAll(arrayList);
    }

    public static OperatorGroup orTagsCondition(Set<String> tags) {
        if (CollectionUtils.isNullOrEmpty(tags)) {
            return OperatorGroup.clause();
        }
        ArrayList<Operator> arrayList = new ArrayList<Operator>();
        for (String string2 : tags) {
            arrayList.add(QueryBuilder.matchLike(QueryBuilder.getMetadataTagsProperty(), string2));
        }
        return OperatorGroup.clause().orAll(arrayList);
    }

    public static OperatorGroup orSearchCondition(String search) {
        if (StringUtils.isNullOrEmpty((String)search)) {
            return OperatorGroup.clause();
        }
        return OperatorGroup.clause().or((SQLOperator)QueryBuilder.matchLike(QueryBuilder.getMetadataTitleProperty(), search)).or((SQLOperator)QueryBuilder.matchLike(QueryBuilder.getMetadataNameProperty(), search)).or((SQLOperator)QueryBuilder.matchLike(QueryBuilder.getMetadataAuthorsProperty(), search));
    }

    public static OperatorGroup localSourceCondition() {
        return OperatorGroup.clause().or((SQLOperator)QueryBuilder.getMetadataFetchSourceProperty().eq((Object)Metadata.FetchSource.LOCAL)).and((SQLOperator)QueryBuilder.getMetadataCloudIdProperty().isNull());
    }

    public static OperatorGroup cloudSourceCondition() {
        return OperatorGroup.clause().or((SQLOperator)QueryBuilder.getMetadataFetchSourceProperty().notEq((Object)Metadata.FetchSource.LOCAL)).or((SQLOperator)QueryBuilder.getMetadataCloudIdProperty().isNotNull());
    }

    public static List<OrderBy> getOrderByList() {
        ArrayList<OrderBy> arrayList = new ArrayList<OrderBy>();
        arrayList.add(OrderBy.fromProperty(QueryBuilder.getMetadataNameProperty()).ascending());
        return arrayList;
    }

    public static OrderBy getOrderByUpdateAt() {
        return QueryBuilder.getOrderBy(QueryBuilder.getMetadataCreatedAtProperty());
    }

    public static OrderBy getOrderByCreateAt() {
        return QueryBuilder.getOrderBy(QueryBuilder.getMetadataCreatedAtProperty());
    }

    public static OrderBy getOrderByName() {
        return QueryBuilder.getOrderBy(QueryBuilder.getMetadataNameProperty()).ascending();
    }

    public static OrderBy getOrderBy(IProperty property) {
        return OrderBy.fromProperty((IProperty)property);
    }

    public static void andWith(OperatorGroup parent, OperatorGroup child) {
        if (parent != null && child != null) {
            parent.and((SQLOperator)child);
        }
    }

    public static void andWith(OperatorGroup parent, Operator child) {
        if (parent != null && child != null) {
            parent.and((SQLOperator)child);
        }
    }

    public static SQLOperator matchNotLike(final Property<String> property, final String value) {
        if (property == null || StringUtils.isNullOrEmpty((String)value)) {
            return null;
        }
        return new SQLOperator(){
            private String c;

            public void appendConditionToQuery(com.raizlabs.android.dbflow.sql.QueryBuilder queryBuilder) {
                queryBuilder.append((Object)this.columnName()).append((Object)this.operation());
                queryBuilder.append((Object)Operator.convertValueToString((Object)this.value(), (boolean)true));
            }

            public String columnName() {
                return property.getNameAlias().name();
            }

            public String separator() {
                return this.c;
            }

            public SQLOperator separator(String separator) {
                this.c = separator;
                return this;
            }

            public boolean hasSeparator() {
                return StringUtils.isNotBlank((String)this.c);
            }

            public String operation() {
                return String.format(" %1s ", "NOT LIKE");
            }

            public Object value() {
                return "%" + value + "%";
            }
        };
    }

    public static Operator matchLike(Property<String> property, String match) {
        if (StringUtils.isNullOrEmpty((String)match)) {
            return null;
        }
        return property.like("%" + match + "%");
    }

    public static OperatorGroup matchLikeSet(Property<String> property, Set<String> set) {
        if (set == null || set.size() <= 0) {
            return null;
        }
        OperatorGroup operatorGroup = OperatorGroup.clause();
        for (String string2 : set) {
            Operator operator = QueryBuilder.matchLike(property, string2);
            if (operator == null) continue;
            operatorGroup.or((SQLOperator)operator);
        }
        return operatorGroup;
    }

    public static OperatorGroup matchEqualSet(Property<String> property, Set<String> set) {
        if (set == null || set.size() <= 0) {
            return null;
        }
        OperatorGroup operatorGroup = OperatorGroup.clause();
        for (String string2 : set) {
            operatorGroup.or((SQLOperator)property.eq((Object)string2));
        }
        return operatorGroup;
    }

    public static OperatorGroup getNullWithEqualCondition(Property<String> property, String compare) {
        OperatorGroup operatorGroup = OperatorGroup.clause().or((SQLOperator)property.isNull());
        if (StringUtils.isNotBlank((String)compare)) {
            operatorGroup.or((SQLOperator)property.is((Object)compare));
        }
        return operatorGroup;
    }

    public static Operator getNullOrEqualCondition(Property<String> property, String compare) {
        return compare == null ? property.isNull() : property.eq((Object)compare);
    }

    public static Operator getNotNullOrEqualCondition(Property<String> property, String value) {
        return value == null ? property.isNotNull() : property.eq((Object)value);
    }

    public static Operator.In inCondition(Property property, Where in, boolean isIn) {
        return isIn ? property.in((BaseModelQueriable)in, new BaseModelQueriable[0]) : property.notIn((BaseModelQueriable)in, new BaseModelQueriable[0]);
    }

    public static QueryArgs generateQueryArgs(QueryArgs args) {
        switch (args.filter) {
            case ALL: {
                args.conditionGroup = QueryBuilder.orTypeCondition(args.fileType);
                break;
            }
            case NEW: {
                args.conditionGroup = QueryBuilder.newBookListCondition();
                break;
            }
            case READING: {
                args.conditionGroup = QueryBuilder.recentReadingCondition();
                break;
            }
            case FINISHED: {
                args.conditionGroup = QueryBuilder.finishReadCondition();
                break;
            }
            case TAG: {
                args.conditionGroup = QueryBuilder.orTagsCondition(args.tags);
                break;
            }
            case SEARCH: {
                args.conditionGroup = QueryBuilder.orSearchCondition(args.query);
                break;
            }
            case LOCAL_SOURCE: {
                args.conditionGroup = QueryBuilder.localSourceCondition();
                break;
            }
            case CLOUD_SOURCE: {
                args.conditionGroup = QueryBuilder.cloudSourceCondition();
            }
        }
        QueryBuilder.generateQueryArgsSortBy(args);
        QueryBuilder.generateCriteriaCondition(args);
        return args;
    }

    public static OrderBy ascDescOrder(OrderBy orderBy, boolean asc) {
        if (asc) {
            orderBy.ascending();
        } else {
            orderBy.descending();
        }
        return orderBy;
    }

    public static Property getPropertyFromSortBy(SortBy sortBy) {
        Object object = QueryBuilder.getMetadataNameProperty();
        switch (sortBy) {
            case None: 
            case Name: {
                break;
            }
            case FileType: {
                object = QueryBuilder.getMetadataTypeProperty();
                break;
            }
            case Size: {
                object = QueryBuilder.getMetadataSizeProperty();
                break;
            }
            case CreationTime: {
                object = QueryBuilder.getMetadataCreatedAtProperty();
                break;
            }
            case BookTitle: {
                object = QueryBuilder.getMetadataTitleProperty();
                break;
            }
            case Author: {
                object = QueryBuilder.getMetadataAuthorsProperty();
                break;
            }
            case Publisher: {
                object = QueryBuilder.getMetadataPublisherProperty();
                break;
            }
            case LastOpenTime: {
                object = QueryBuilder.getMetadataLastAccessProperty();
                break;
            }
            case RecentlyRead: {
                object = QueryBuilder.getMetadataLastAccessProperty();
                break;
            }
            case Total: {
                object = QueryBuilder.getMetadataLastAccessProperty();
                break;
            }
            case StartTime: {
                object = QueryBuilder.getMetadataLastAccessProperty();
                break;
            }
            case InstallTime: {
                object = QueryBuilder.getMetadataLastAccessProperty();
                break;
            }
            case Ordinal: {
                object = QueryBuilder.getMetadataOrdinalProperty();
            }
        }
        return object;
    }

    public static OrderBy generateOrderBy(SortBy sortBy, SortOrder order) {
        return QueryBuilder.generateOrderBy(QueryBuilder.getPropertyFromSortBy(sortBy), order);
    }

    public static OrderBy generateOrderBy(Property property, SortOrder order) {
        boolean bl = order == SortOrder.Asc;
        return QueryBuilder.ascDescOrder(OrderBy.fromProperty((IProperty)property), bl);
    }

    public static void generateQueryArgsSortBy(QueryArgs args) {
        args.orderByList.clear();
        args.orderByList.add(QueryBuilder.generateOrderBy(args.sortBy, args.order));
    }

    public static void generateCriteriaCondition(QueryArgs args) {
        QueryBuilder.andWith(args.conditionGroup, QueryBuilder.matchLikeSet(QueryBuilder.getMetadataAuthorsProperty(), args.author));
        QueryBuilder.andWith(args.conditionGroup, QueryBuilder.matchLikeSet(QueryBuilder.getMetadataTagsProperty(), args.tags));
        QueryBuilder.andWith(args.conditionGroup, QueryBuilder.matchLikeSet(QueryBuilder.getMetadataSeriesProperty(), args.series));
        QueryBuilder.andWith(args.conditionGroup, QueryBuilder.matchLikeSet(QueryBuilder.getMetadataTitleProperty(), args.title));
        QueryBuilder.andWith(args.conditionGroup, QueryBuilder.matchLikeSet(QueryBuilder.getMetadataTypeProperty(), args.fileType));
    }

    public static QueryArgs generateMetadataInQueryArgs(QueryArgs queryArgs) {
        Where where = new Select(new IProperty[]{QueryBuilder.getMetadataCollectionDocIdProperty().withTable()}).from(MetadataCollection.class).where(new SQLOperator[]{QueryBuilder.getNotNullOrEqualCondition((Property<String>)QueryBuilder.getMetadataCollectionLibraryIdProperty().withTable(), queryArgs.libraryUniqueId)});
        Operator.In in = QueryBuilder.inCondition(QueryBuilder.getMetadataIdStringProperty().withTable(), where, StringUtils.isNotBlank((String)queryArgs.libraryUniqueId));
        OperatorGroup operatorGroup = OperatorGroup.clause().and((SQLOperator)in);
        queryArgs.conditionGroup = queryArgs.conditionGroup.size() > 0 ? operatorGroup.and((SQLOperator)queryArgs.conditionGroup) : operatorGroup;
        return queryArgs;
    }
}

