/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.data.fs;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.util.Log;
import com.onyx.android.sdk.data.AppDataInfo;
import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.SortBy;
import com.onyx.android.sdk.data.SortOrder;
import com.onyx.android.sdk.data.request.data.fs.BaseFSRequest;
import com.onyx.android.sdk.utils.ApplicationUtil;
import com.onyx.android.sdk.utils.Benchmark;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.ComparatorUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class ApplicationListLoadRequest
extends BaseFSRequest {
    private static final String a = "AppLoadRequest";
    private List<String> b;
    private List<String> c;
    private Map<String, String> d;
    private List<AppDataInfo> e = new ArrayList<AppDataInfo>();
    private SortBy f;
    private SortOrder g;
    private boolean h = false;

    public ApplicationListLoadRequest(DataManager dataManager, List<String> ignoreAppList, List<String> testAppList, Map<String, String> customizedIconAppsMap) {
        super(dataManager);
        this.b = ignoreAppList;
        this.c = testAppList;
        this.d = customizedIconAppsMap;
    }

    public List<AppDataInfo> getAppInfoList() {
        return this.e;
    }

    public boolean isTestAppExist() {
        return this.h;
    }

    public void setSort(SortBy sortBy, SortOrder sortOrder) {
        this.f = sortBy;
        this.g = sortOrder;
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        this.a();
        if (this.b()) {
            this.a(this.e, this.f, this.g);
        }
    }

    private void a() throws Exception {
        Intent intent = new Intent("android.intent.action.MAIN", null);
        intent.addCategory("android.intent.category.LAUNCHER");
        List list = this.getContext().getPackageManager().getInstalledPackages(0);
        List list2 = this.getContext().getPackageManager().queryIntentActivities(intent, 0);
        for (PackageInfo packageInfo : list) {
            AppDataInfo appDataInfo;
            String string2 = packageInfo.applicationInfo.packageName;
            if (CollectionUtils.safelyContains(this.b, (String)string2)) continue;
            if (CollectionUtils.safelyContains(this.c, (String)string2)) {
                if (ApplicationUtil.testAppRecordExist((Context)this.getContext(), (String)string2)) continue;
                this.h = true;
                appDataInfo = ApplicationUtil.appDataFromPackageInfo((Context)this.getContext(), (PackageInfo)packageInfo);
            } else {
                appDataInfo = ApplicationUtil.appDataFromPackageInfo((Context)this.getContext(), (List)list2, (PackageInfo)packageInfo);
            }
            ApplicationUtil.checkCustomIcon((Context)this.getContext(), this.d, (AppDataInfo)appDataInfo);
            if (appDataInfo == null) continue;
            this.e.add(appDataInfo);
        }
    }

    private boolean b() {
        return this.f != null && this.g != null;
    }

    private void a(List<AppDataInfo> list, SortBy sortBy, SortOrder sortOrder) {
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        Benchmark benchmark = new Benchmark();
        switch (sortBy) {
            case Name: {
                ApplicationListLoadRequest.sortListByName(list, sortOrder);
                break;
            }
            case InstallTime: {
                ApplicationListLoadRequest.sortListByInstallTime(list, sortOrder);
            }
        }
        Log.w((String)a, (String)("Sort duration:" + benchmark.duration() + "ms"));
    }

    public static void sortListByName(List<AppDataInfo> fileList, final SortOrder sortOrder) {
        Collections.sort(fileList, new Comparator<AppDataInfo>(){

            public int a(AppDataInfo appDataInfo, AppDataInfo appDataInfo2) {
                return ComparatorUtils.stringComparator((String)appDataInfo.labelName, (String)appDataInfo2.labelName, (SortOrder)sortOrder);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((AppDataInfo)object, (AppDataInfo)object2);
            }
        });
    }

    public static void sortListByInstallTime(List<AppDataInfo> fileList, final SortOrder sortOrder) {
        Collections.sort(fileList, new Comparator<AppDataInfo>(){

            public int a(AppDataInfo appDataInfo, AppDataInfo appDataInfo2) {
                return ComparatorUtils.longComparator((long)appDataInfo.lastUpdatedTime, (long)appDataInfo2.lastUpdatedTime, (SortOrder)sortOrder);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((AppDataInfo)object, (AppDataInfo)object2);
            }
        });
    }
}

