/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.common;

import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.data.model.common.ScreenSaverConfig;
import com.onyx.android.sdk.data.request.data.BaseDataRequest;
import com.onyx.android.sdk.utils.BitmapUtils;

public class ScreenSaverRequest
extends BaseDataRequest {
    private ScreenSaverConfig a;

    public ScreenSaverRequest(DataManager dataManager, ScreenSaverConfig saverConfig) {
        super(dataManager);
        this.a = saverConfig;
    }

    @Override
    public void execute(DataManager dataManager) throws Exception {
        this.a(this.a);
    }

    private void a(ScreenSaverConfig screenSaverConfig) throws Exception {
        int n = screenSaverConfig.fullScreenPhysicalHeight;
        int n2 = screenSaverConfig.fullScreenPhysicalWidth;
        Bitmap bitmap = BitmapFactory.decodeFile((String)screenSaverConfig.sourcePicPathString).copy(Bitmap.Config.RGB_565, true);
        if (bitmap.getHeight() > bitmap.getWidth()) {
            bitmap = BitmapUtils.rotateBmp((Bitmap)bitmap, (int)screenSaverConfig.picRotateDegrees);
        }
        if (bitmap.getWidth() != n || bitmap.getHeight() != n2) {
            bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n, (int)n2, (boolean)true);
        }
        if (screenSaverConfig.convertToGrayScale) {
            bitmap = BitmapUtils.convertToBlackWhite((Bitmap)bitmap);
        }
        boolean bl = false;
        if (screenSaverConfig.targetFormat.contains("bmp")) {
            bl = BitmapUtils.saveBitmapToFile((Bitmap)bitmap, (String)screenSaverConfig.targetDir, (String)screenSaverConfig.targetPicPathString, (boolean)true);
        } else if (screenSaverConfig.targetFormat.contains("png")) {
            bl = BitmapUtils.savePngToFile((Bitmap)bitmap, (String)screenSaverConfig.targetDir, (String)screenSaverConfig.targetPicPathString, (boolean)true);
        }
        if (bl) {
            Log.i((String)"screenSaver", (String)"success");
            Intent intent = new Intent("update_standby_pic");
            this.getContext().sendBroadcast(intent);
        }
    }
}

