/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.model;

import com.onyx.android.sdk.data.model.HomeworkSubmitAnswer;
import com.onyx.android.sdk.data.model.QuestionOption;
import com.onyx.android.sdk.data.model.QuestionType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Question
implements Serializable {
    public String _id;
    public String content;
    public String answers;
    public int QuesType;
    public int difficulty;
    public List<QuestionOption> options;
    public boolean doneAnswer;

    public QuestionType getType() {
        int n = this.QuesType - 1;
        if (n >= QuestionType.values().length) {
            return QuestionType.SINGLE;
        }
        return QuestionType.values()[n];
    }

    public boolean isChoiceQuestion() {
        return this.getType() == QuestionType.SINGLE || this.getType() == QuestionType.MULTIPLE || this.getType() == QuestionType.JUDGMENT;
    }

    public boolean isSingleChoiceQuestion() {
        return this.getType() == QuestionType.SINGLE || this.getType() == QuestionType.JUDGMENT;
    }

    public boolean isMultipleChoiceQuestion() {
        return this.getType() == QuestionType.MULTIPLE;
    }

    public void setDoneAnswer(boolean doneAnswer) {
        this.doneAnswer = doneAnswer;
    }

    public List<HomeworkSubmitAnswer> createAnswer() {
        if (this.isSingleChoiceQuestion()) {
            return this.createSingleAnswer();
        }
        if (this.isMultipleChoiceQuestion()) {
            return this.createMultipleAnswers();
        }
        return this.createFillAnswer();
    }

    public List<HomeworkSubmitAnswer> createSingleAnswer() {
        ArrayList<HomeworkSubmitAnswer> arrayList = new ArrayList<HomeworkSubmitAnswer>();
        for (QuestionOption questionOption : this.options) {
            if (!questionOption.checked) continue;
            HomeworkSubmitAnswer homeworkSubmitAnswer = new HomeworkSubmitAnswer();
            homeworkSubmitAnswer.setQuestion(this._id);
            homeworkSubmitAnswer.setValue(questionOption._id);
            arrayList.add(homeworkSubmitAnswer);
        }
        return arrayList;
    }

    public List<HomeworkSubmitAnswer> createMultipleAnswers() {
        ArrayList<HomeworkSubmitAnswer> arrayList = new ArrayList<HomeworkSubmitAnswer>();
        int n = 0;
        for (QuestionOption questionOption : this.options) {
            if (!questionOption.checked) continue;
            HomeworkSubmitAnswer homeworkSubmitAnswer = new HomeworkSubmitAnswer();
            homeworkSubmitAnswer.setQuestion(this._id);
            homeworkSubmitAnswer.setValue(questionOption._id);
            arrayList.add(n, homeworkSubmitAnswer);
            ++n;
        }
        return arrayList;
    }

    public List<HomeworkSubmitAnswer> createFillAnswer() {
        ArrayList<HomeworkSubmitAnswer> arrayList = new ArrayList<HomeworkSubmitAnswer>();
        HomeworkSubmitAnswer homeworkSubmitAnswer = new HomeworkSubmitAnswer();
        homeworkSubmitAnswer.setQuestion(this._id);
        arrayList.add(homeworkSubmitAnswer);
        return arrayList;
    }
}

