/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud.v2;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import com.facebook.common.references.CloseableReference;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.DataManagerHelper;
import com.onyx.android.sdk.data.QueryArgs;
import com.onyx.android.sdk.data.QueryResult;
import com.onyx.android.sdk.data.manager.CacheManager;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.common.FetchPolicy;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CloudLibraryContentListRequest
extends BaseCloudRequest {
    private static final String a = CloudLibraryContentListRequest.class.getSimpleName();
    private boolean b = true;
    private boolean c = true;
    private QueryResult<Metadata> d;
    private QueryResult<Library> e;
    private QueryArgs f;
    private Map<String, CloseableReference<Bitmap>> g = new HashMap<String, CloseableReference<Bitmap>>();

    public CloudLibraryContentListRequest(CloudManager cloudManager, QueryArgs queryArgs) {
        super(cloudManager);
        this.f = queryArgs;
    }

    public CloudLibraryContentListRequest(CloudManager cloudManager, QueryArgs queryArgs, boolean bl) {
        this(cloudManager, queryArgs);
        this.c = bl;
    }

    public Map<String, CloseableReference<Bitmap>> getThumbnailMap() {
        return this.g;
    }

    public QueryResult<Metadata> getMetadataQueryResult() {
        return this.d;
    }

    public QueryResult<Library> getLibraryQueryResult() {
        return this.e;
    }

    @Override
    public void execute(CloudManager cloudManager) throws Exception {
        this.e = this.a(cloudManager);
        this.d = this.a(this.getContext(), cloudManager, this.f);
        if (this.b && QueryResult.isValidQueryResult(this.d)) {
            this.g = DataManagerHelper.loadCloudThumbnailBitmapsWithCache(this.getContext(), cloudManager, this.d.list);
        }
    }

    private QueryResult<Library> a(CloudManager cloudManager) {
        QueryResult<Library> queryResult = new QueryResult<Library>();
        queryResult.list = DataManagerHelper.fetchLibraryLibraryList(this.getContext(), cloudManager.getCloudDataProvider(), this.f);
        queryResult.count = CollectionUtils.getSize(queryResult.list);
        return queryResult;
    }

    private QueryResult<Metadata> a(Context context, CloudManager cloudManager, QueryArgs queryArgs) {
        QueryResult<Metadata> queryResult = new QueryResult<Metadata>();
        if (FetchPolicy.isMemPartPolicy(queryArgs.fetchPolicy) && this.a(cloudManager.getCacheManager(), queryArgs, queryResult)) {
            return queryResult;
        }
        queryResult = DataManagerHelper.cloudMetadataFromDataProvider(context, cloudManager.getCloudDataProvider(), queryArgs);
        this.b(cloudManager.getCacheManager(), queryArgs, queryResult);
        this.a(cloudManager.getCloudDataProvider(), queryArgs, queryResult);
        return this.a(queryResult, queryArgs);
    }

    private QueryResult<Metadata> a(QueryResult<Metadata> queryResult, QueryArgs queryArgs) {
        QueryResult<Metadata> queryResult2 = new QueryResult<Metadata>();
        if (!QueryResult.isValidQueryResult(queryResult)) {
            return queryResult2;
        }
        queryResult2 = queryResult.copy(this.f.limit);
        return queryResult2;
    }

    private boolean a(CacheManager cacheManager, QueryArgs queryArgs, QueryResult<Metadata> queryResult) {
        List<Metadata> list = cacheManager.getMetadataLruCache(this.a(queryArgs));
        if (list == null) {
            return false;
        }
        return DataManagerHelper.cloudMetadataFromCache(queryResult, queryArgs, list);
    }

    private void b(CacheManager cacheManager, QueryArgs queryArgs, QueryResult<Metadata> queryResult) {
        List<Metadata> list = this.a(cacheManager, this.a(queryArgs), (int)queryResult.count);
        DataManagerHelper.updateCloudCacheList(list, queryResult, queryArgs);
    }

    private List<Metadata> a(CacheManager cacheManager, String string2, int n) {
        List<Metadata> list = cacheManager.getMetadataLruCache(string2);
        if (n > CollectionUtils.getSize(list)) {
            Metadata[] metadataArray = new Metadata[n];
            list = Arrays.asList(metadataArray);
            cacheManager.addToMetadataCache(string2, list);
        }
        return list;
    }

    private String a(QueryArgs queryArgs) {
        return CacheManager.generateCloudKey(queryArgs);
    }

    private void a(DataProviderBase dataProviderBase, QueryArgs queryArgs, QueryResult<Metadata> queryResult) {
        if (!(this.c && QueryResult.isValidQueryResult(queryResult) && queryResult.isFetchFromCloud())) {
            return;
        }
        if (StringUtils.isNullOrEmpty((String)queryArgs.libraryUniqueId)) {
            Log.w((String)a, (String)"detect libraryId is NULL");
            Log.w((String)a, (String)"saveCollection method may delete collection associated with NULL libraryId");
        }
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"ContentDatabase").getWritableDatabase();
        databaseWrapper.beginTransaction();
        for (Metadata metadata : queryResult.list) {
            dataProviderBase.saveMetadata(this.getContext(), metadata);
            DataManagerHelper.saveCloudCollection(this.getContext(), dataProviderBase, queryArgs.libraryUniqueId, metadata.getAssociationId());
        }
        databaseWrapper.setTransactionSuccessful();
        databaseWrapper.endTransaction();
    }

    public void setLoadThumbnail(boolean bl) {
        this.b = bl;
    }
}

