/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud;

import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.support.annotation.NonNull;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.manager.OssManager;
import com.onyx.android.sdk.data.model.Device;
import com.onyx.android.sdk.data.model.Firmware;
import com.onyx.android.sdk.data.model.LogCollection;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.v1.ServiceFactory;
import com.onyx.android.sdk.utils.DeviceInfoUtil;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.LogUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Locale;
import retrofit2.Response;

public class LogCollectionRequest
extends BaseCloudRequest {
    private String a;
    private OssManager b;
    private String c;

    public LogCollectionRequest(CloudManager cloudManager, @NonNull OssManager ossManager, String string2) {
        super(cloudManager);
        this.b = ossManager;
        this.c = string2;
    }

    public String getUploadFileUrl() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CloudManager cloudManager) throws Exception {
        File file = LogUtils.generateFeedBackFile((Context)this.getContext());
        if (file == null || !file.exists()) {
            throw new FileNotFoundException();
        }
        try {
            String string2 = this.b.syncUploadFile(this.getContext(), file.getAbsolutePath());
            if (StringUtils.isNullOrEmpty((String)string2)) {
                return;
            }
            this.a(cloudManager, string2);
        }
        catch (Exception exception) {
            this.setException(exception);
        }
        finally {
            FileUtils.deleteFile((File)file);
        }
    }

    private void a(CloudManager cloudManager, String string2) throws Exception {
        String string3 = this.b.getOssEndPoint() + File.separator + string2;
        Firmware firmware = this.a();
        LogCollection logCollection = new LogCollection();
        logCollection.firmware = firmware;
        logCollection.desc = this.c;
        logCollection.zipFile = string3;
        Response response = ServiceFactory.getLogService(cloudManager.getCloudConf().getApiBase()).reportLogCollection(logCollection).execute();
        if (response.isSuccessful()) {
            this.a = string3;
        }
    }

    private Firmware a() {
        Point point = DeviceInfoUtil.getScreenResolution((Context)this.getContext());
        Firmware firmware = Firmware.currentFirmware();
        firmware.buildDisplayId = Build.DISPLAY;
        firmware.lang = Locale.getDefault().toString();
        firmware.widthPixels = point.x;
        firmware.heightPixels = point.y;
        Device device = Device.updateCurrentDeviceInfo(this.getContext());
        if (device != null) {
            firmware.deviceMAC = device.macAddress;
        }
        return firmware;
    }
}

