/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.model;

import android.os.Build;
import com.alibaba.fastjson.annotation.JSONField;
import com.onyx.android.sdk.data.model.BaseData;
import com.onyx.android.sdk.data.utils.FirmwareUtils;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.StringUtils;
import java.util.List;

public class Firmware
extends BaseData {
    public static final String BUILD_NUMBER_TAG = "buildNumber";
    public static final String RELEASE_TAG = "release";
    public static final String TESTING_TAG = "test";
    public int buildNumber;
    public String buildType;
    public String fingerprint;
    public String buildDisplayId;
    public String lang;
    public String model;
    public String brand;
    public String fwType;
    public String deviceMAC;
    public String md5;
    public int widthPixels;
    public int heightPixels;
    public List<String> changeList;
    public List<String> downloadUrlList;

    public static Firmware currentFirmware() {
        Firmware firmware = new Firmware();
        firmware.model = Build.MODEL;
        firmware.fingerprint = Build.FINGERPRINT;
        firmware.updateReleaseBuildParameters();
        return firmware;
    }

    public void updateReleaseBuildParameters() {
        this.buildNumber = FirmwareUtils.getBuildIdFromFingerprint(this.fingerprint);
        this.buildType = FirmwareUtils.getBuildTypeFromFingerprint(this.fingerprint);
        this.fwType = RELEASE_TAG;
    }

    public void updateTestingBuildParameters() {
        this.buildNumber = FirmwareUtils.getBuildIdFromFingerprint(this.fingerprint);
        this.buildType = FirmwareUtils.getBuildTypeFromFingerprint(this.fingerprint);
        this.fwType = TESTING_TAG;
    }

    @JSONField(serialize=false)
    public String getChangeLog() {
        if (!CollectionUtils.isNullOrEmpty(this.changeList)) {
            return StringUtils.join(this.changeList, (String)"\n");
        }
        return "";
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    @JSONField(serialize=false)
    public String getUrl() {
        if (this.downloadUrlList.size() > 0) {
            return this.downloadUrlList.get(0);
        }
        return null;
    }
}

