/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.common;

import com.onyx.android.sdk.data.utils.ResultCode;
import java.io.File;

public class ContentException
extends Exception {
    private int code;
    public static final int URL_INVALID_EXCEPTION = 1;
    public static final int FILE_PATH_EXCEPTION = 2;
    public static final int NETWORK_EXCEPTION = 3;
    public static final int TOKEN_EXCEPTION = 4;
    public static final int IO_EXCEPTION = 5;
    public static final int UNKNOWN_EXCEPTION = 65535;
    public static final int CLOUD_TOKEN_EXCEPTION = 401;
    public static final int CLOUD_NO_FOUND = 404;
    public static final int CLOUD_INTERNAL_SERVER_ERROR = 500;
    public static final String URL_INVALID_EXCEPTION_MESSAGE = "Url is invalid.";
    public static final String FILE_PATH_EXCEPTION_MESSAGE = "File path is invalid.";
    public static final String NETWORK_EXCEPTION_MESSAGE = "Network is exception.";
    public static final String UNKNOWN_EXCEPTION_MESSAGE = "Unknown exception.";
    public static final String TOKEN_EXCEPTION_MESSAGE = "Token exception.";

    public int getCode() {
        return this.code;
    }

    public void setCode(int n) {
        this.code = n;
    }

    public ContentException(int n, String string) {
        super(string);
        this.code = n;
    }

    public ContentException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public ContentException(Throwable throwable) {
        super(throwable);
    }

    public static ContentException createException(Exception exception) {
        return ContentException.exceptionFromCode(65535, exception.toString());
    }

    public static ContentException exceptionFromCode(int n, String string) {
        return new ContentException(n, string);
    }

    public static ContentException exceptionFromResultCode(ResultCode resultCode) {
        if (resultCode == null) {
            return ContentException.UnKnowException();
        }
        String string = resultCode.message;
        int n = resultCode.code;
        if (string == null) {
            string = n + "," + NETWORK_EXCEPTION_MESSAGE;
        }
        return ContentException.exceptionFromCode(n, string);
    }

    public static ContentException UrlInvalidException() {
        return ContentException.exceptionFromCode(1, URL_INVALID_EXCEPTION_MESSAGE);
    }

    public static ContentException FilePathInvalidException() {
        return ContentException.exceptionFromCode(2, FILE_PATH_EXCEPTION_MESSAGE);
    }

    public static ContentException UnKnowException() {
        return ContentException.exceptionFromCode(65535, UNKNOWN_EXCEPTION_MESSAGE);
    }

    public static ContentException TokenException() {
        return ContentException.exceptionFromCode(4, TOKEN_EXCEPTION_MESSAGE);
    }

    public static boolean isNetworkException(Throwable throwable) {
        return throwable instanceof NetworkException;
    }

    public static boolean isCloudException(Throwable throwable) {
        return throwable instanceof CloudException;
    }

    public boolean isCloudNotFound() {
        return this.getCode() == 404;
    }

    public boolean isCloudServerError() {
        return this.getCode() == 500;
    }

    public boolean isCloudTokenException() {
        return this.getCode() == 401;
    }

    public static class FileCreateException
    extends FileException {
        public File file;

        public FileCreateException(File file) {
            super(5, "FileCreateException");
            this.file = file;
        }
    }

    public static class FileDeleteException
    extends FileException {
        public File file;

        public FileDeleteException(File file) {
            super(5, "FileDeleteException");
            this.file = file;
        }
    }

    public static class FileCopyException
    extends FileException {
        public File from;
        public File to;

        public FileCopyException(File file, File file2) {
            super(5, "FileCopyException");
            this.from = file;
            this.to = file2;
        }
    }

    public static class FileAskForReplaceException
    extends FileException {
        public File from;
        public File to;

        public FileAskForReplaceException(File file, File file2) {
            super(5, "FileAskForReplaceException");
            this.from = file;
            this.to = file2;
        }
    }

    public static class FileException
    extends ContentException {
        public FileException(int n, String string) {
            super(n, string);
        }
    }

    public static class CloudException
    extends ContentException {
        public CloudException(ResultCode resultCode) {
            super(CloudException.exceptionFromResultCode(resultCode));
            this.setCode(resultCode == null ? 65535 : resultCode.code);
        }
    }

    public static class NetworkException
    extends ContentException {
        public NetworkException(Exception exception) {
            super(exception);
        }
    }
}

