/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data;

import android.content.Context;
import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.FileDownloader;
import com.liulishuo.filedownloader.notification.FileDownloadNotificationHelper;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import com.onyx.android.sdk.common.request.BaseCallback;
import com.onyx.android.sdk.data.request.cloud.CloudFileDownloadRequest;
import com.onyx.android.sdk.data.utils.DownloadListener;
import com.onyx.android.sdk.data.utils.NotificationItem;
import com.onyx.android.sdk.rx.RxCallback;
import java.util.LinkedHashMap;
import org.greenrobot.eventbus.EventBus;

public class OnyxDownloadManager {
    private static int a = 1200;
    private static OnyxDownloadManager b;
    private static Context c;
    private FileDownloadNotificationHelper<NotificationItem> d = new FileDownloadNotificationHelper();
    private EventBus e;
    private LinkedHashMap<Object, BaseDownloadTask> f = new LinkedHashMap();

    private OnyxDownloadManager() {
    }

    public static void init(Context context) {
        c = context;
        FileDownloader.init((Context)c);
        FileDownloader.getImpl().setMaxNetworkThreadCount(5);
    }

    public static synchronized OnyxDownloadManager getInstance() {
        if (b == null) {
            b = new OnyxDownloadManager();
        }
        return b;
    }

    public static synchronized Context getContext() {
        return FileDownloadHelper.getAppContext();
    }

    public CloudFileDownloadRequest createDownloadRequest(String url, String path, Object tag) {
        CloudFileDownloadRequest cloudFileDownloadRequest = new CloudFileDownloadRequest(null, url, path, tag);
        cloudFileDownloadRequest.setTaskId(FileDownloadUtils.generateId((String)url, (String)path));
        return cloudFileDownloadRequest;
    }

    public DownloadListener createDownloadListener(CloudFileDownloadRequest request, BaseCallback baseCallback) {
        return new DownloadListener(request, baseCallback, this.d);
    }

    public DownloadListener createDownloadListener(CloudFileDownloadRequest request, RxCallback baseCallback) {
        return new DownloadListener(request, baseCallback, this.d);
    }

    public DownloadListener createDownloadListener(NotificationItem.NotificationBean bean, CloudFileDownloadRequest request, RxCallback baseCallback) {
        DownloadListener downloadListener = this.createDownloadListener(request, baseCallback);
        downloadListener.setNotificationBean(bean);
        return downloadListener;
    }

    public BaseDownloadTask download(Context context, String url, String path, Object tag, BaseCallback baseCallback) {
        CloudFileDownloadRequest cloudFileDownloadRequest = this.createDownloadRequest(url, path, tag);
        cloudFileDownloadRequest.setContext(context);
        return this.download(cloudFileDownloadRequest, baseCallback);
    }

    public BaseDownloadTask download(CloudFileDownloadRequest request, BaseCallback baseCallback) {
        request.setTaskId(FileDownloadUtils.generateId((String)request.getUrl(), (String)request.getPath()));
        BaseDownloadTask baseDownloadTask = FileDownloader.getImpl().create(request.getUrl()).setPath(request.getPath()).setTag(request.getTag());
        baseDownloadTask.setListener((FileDownloadListener)this.createDownloadListener(request, baseCallback));
        return baseDownloadTask;
    }

    public BaseDownloadTask download(Context context, String url, String path, Object tag, RxCallback baseCallback) {
        CloudFileDownloadRequest cloudFileDownloadRequest = this.createDownloadRequest(url, path, tag);
        cloudFileDownloadRequest.setContext(context);
        return this.download(cloudFileDownloadRequest, baseCallback);
    }

    public BaseDownloadTask download(CloudFileDownloadRequest request, RxCallback baseCallback) {
        request.setTaskId(FileDownloadUtils.generateId((String)request.getUrl(), (String)request.getPath()));
        BaseDownloadTask baseDownloadTask = FileDownloader.getImpl().create(request.getUrl()).setPath(request.getPath()).setTag(request.getTag());
        baseDownloadTask.setListener((FileDownloadListener)this.createDownloadListener(request, baseCallback));
        return baseDownloadTask;
    }

    public BaseDownloadTask downloadWithNotify(String url, String path, Object tag, NotificationItem.NotificationBean bean, RxCallback callback) {
        CloudFileDownloadRequest cloudFileDownloadRequest = this.createDownloadRequest(url, path, tag);
        DownloadListener downloadListener = this.createDownloadListener(bean, cloudFileDownloadRequest, callback);
        BaseDownloadTask baseDownloadTask = FileDownloader.getImpl().create(cloudFileDownloadRequest.getUrl()).setPath(cloudFileDownloadRequest.getPath()).setTag(cloudFileDownloadRequest.getTag());
        baseDownloadTask.setListener((FileDownloadListener)downloadListener);
        return baseDownloadTask;
    }

    public BaseDownloadTask downloadWithNotify(CloudFileDownloadRequest request, NotificationItem.NotificationBean bean, RxCallback callback) {
        BaseDownloadTask baseDownloadTask = FileDownloader.getImpl().create(request.getUrl()).setPath(request.getPath()).setTag(request.getTag());
        request.setTaskId(FileDownloadUtils.generateId((String)request.getUrl(), (String)request.getPath()));
        DownloadListener downloadListener = this.createDownloadListener(bean, request, callback);
        baseDownloadTask.setListener((FileDownloadListener)downloadListener);
        return baseDownloadTask;
    }

    public int downloadDirectly(Context context, String url, String path, Object tag, RxCallback baseCallback) {
        return this.startDownload(this.download(context, url, path, tag, baseCallback));
    }

    public int downloadDirectly(CloudFileDownloadRequest request, RxCallback baseCallback) {
        return this.startDownload(this.download(request, baseCallback));
    }

    public int startDownload(BaseDownloadTask task) {
        task.setCallbackProgressMinInterval(a);
        return task.start();
    }

    public int startDownload(BaseDownloadTask task, int progressMinInterval) {
        task.setCallbackProgressMinInterval(progressMinInterval);
        return task.start();
    }

    public void removeTask(Object key) {
        this.f.remove(key);
    }

    public void addTask(Object key, BaseDownloadTask task) {
        this.f.put(key, task);
    }

    public BaseDownloadTask getTask(Object key) {
        return this.f.get(key);
    }

    public void clearTaskQueue() {
        this.f.clear();
    }

    public int getTaskProgress(int taskId) {
        return (int)((float)FileDownloader.getImpl().getSoFar(taskId) * 1.0f / (float)FileDownloader.getImpl().getTotal(taskId) * 100.0f);
    }

    public int getTaskStatus(int taskId, String path) {
        return FileDownloader.getImpl().getStatus(taskId, path);
    }

    public void pauseTask(Object key, boolean removeFromQueue) {
        BaseDownloadTask baseDownloadTask = this.getTask(key);
        if (baseDownloadTask == null) {
            return;
        }
        baseDownloadTask.pause();
        if (removeFromQueue) {
            this.removeTask(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EventBus getEventBus() {
        if (this.e != null) return this.e;
        Class<EventBus> clazz = EventBus.class;
        synchronized (EventBus.class) {
            if (this.e != null) return this.e;
            this.e = new EventBus();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.e;
        }
    }

    public LinkedHashMap<Object, BaseDownloadTask> getTaskQueue() {
        return this.f;
    }
}

