/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.manager;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.DataManager;
import com.onyx.android.sdk.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PushActionManager {
    public static List<String> PUSH_DATA = new ArrayList<String>();
    public static List<String> PUSH_CHANNEL = new ArrayList<String>();
    private DataManager a = new DataManager();
    private CloudManager b = new CloudManager();
    private Map<String, Class<? extends PushAction>> c = new HashMap<String, Class<? extends PushAction>>();

    public void addAction(String action, Class<? extends PushAction> clazz) {
        if (StringUtils.isNullOrEmpty((String)action) || clazz == null) {
            return;
        }
        this.c.put(action, clazz);
    }

    public void processPushAction(Context context, Intent intent) {
        String string = intent.getAction();
        if (StringUtils.isNotBlank((String)string) && this.c.containsKey(string)) {
            PushAction pushAction = this.a(this.c.get(string));
            if (pushAction == null) {
                return;
            }
            pushAction.execute(PushActionContext.create(context, this.getCloudManager(), this.getDataManager(), intent));
        }
    }

    private PushAction a(Class<? extends PushAction> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String getPushData(Intent intent) {
        for (int i = 0; i < PUSH_DATA.size(); ++i) {
            String string = intent.getExtras().getString(PUSH_DATA.get(i));
            if (!StringUtils.isNotBlank((String)string)) continue;
            return string;
        }
        return null;
    }

    public CloudManager getCloudManager() {
        return this.b;
    }

    public void setCloudManager(CloudManager cloudManager) {
        this.b = cloudManager;
    }

    public DataManager getDataManager() {
        return this.a;
    }

    public void setDataManager(DataManager dataManager) {
        this.a = dataManager;
    }

    public static class PushActionContext {
        public Context context;
        public CloudManager cloudManager;
        public DataManager dataManager;
        public Intent intent;

        private PushActionContext() {
        }

        public static PushActionContext create(@NonNull Context context, @NonNull CloudManager cloudManager, @NonNull DataManager dataManager, @NonNull Intent intent) {
            PushActionContext pushActionContext = new PushActionContext();
            pushActionContext.context = context;
            pushActionContext.cloudManager = cloudManager;
            pushActionContext.dataManager = dataManager;
            pushActionContext.intent = intent;
            return pushActionContext;
        }
    }

    public static abstract class PushAction {
        public abstract void execute(PushActionContext var1);
    }
}

