/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.request.cloud.v2;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.util.Log;
import com.alibaba.fastjson.parser.Feature;
import com.onyx.android.sdk.data.CloudManager;
import com.onyx.android.sdk.data.DataManagerHelper;
import com.onyx.android.sdk.data.db.table.OnyxMetadataProvider;
import com.onyx.android.sdk.data.model.Library;
import com.onyx.android.sdk.data.model.Metadata;
import com.onyx.android.sdk.data.model.v2.CloudContentImportConfig;
import com.onyx.android.sdk.data.model.v2.CloudContentImportList;
import com.onyx.android.sdk.data.model.v2.CloudGroup;
import com.onyx.android.sdk.data.model.v2.CloudGroup_Table;
import com.onyx.android.sdk.data.model.v2.CloudMetadata;
import com.onyx.android.sdk.data.provider.DataProviderBase;
import com.onyx.android.sdk.data.request.cloud.BaseCloudRequest;
import com.onyx.android.sdk.data.utils.CloudUtils;
import com.onyx.android.sdk.data.utils.JSONObjectParseUtils;
import com.onyx.android.sdk.data.utils.StoreUtils;
import com.onyx.android.sdk.data.utils.ThumbnailUtils;
import com.onyx.android.sdk.utils.BitmapUtils;
import com.onyx.android.sdk.utils.CollectionUtils;
import com.onyx.android.sdk.utils.FileUtils;
import com.onyx.android.sdk.utils.StringUtils;
import com.onyx.android.sdk.utils.TestUtils;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.raizlabs.android.dbflow.structure.provider.ContentUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CloudContentImportFromJsonRequest
extends BaseCloudRequest {
    private static final String a = CloudContentImportFromJsonRequest.class.getSimpleName();
    private List<String> b = new ArrayList<String>();
    private boolean c = true;

    public CloudContentImportFromJsonRequest(CloudManager cloudManager, List<String> filePathList) {
        super(cloudManager);
        this.b = filePathList;
    }

    public void setCopyToCloudDir(boolean set) {
        this.c = set;
    }

    @Override
    public void execute(CloudManager cloudManager) throws Exception {
        if (CollectionUtils.isNullOrEmpty(this.b)) {
            return;
        }
        for (String string2 : this.b) {
            if (StringUtils.isNullOrEmpty((String)string2) || !FileUtils.fileExist((String)string2)) continue;
            CloudContentImportConfig cloudContentImportConfig = JSONObjectParseUtils.parseObject(StringUtils.safelyGetStr((String)FileUtils.readContentOfFile((String)string2)), CloudContentImportConfig.class, new Feature[0]);
            List<CloudContentImportList> list = null;
            if (cloudContentImportConfig != null) {
                list = cloudContentImportConfig.contentImportList;
            }
            if (cloudContentImportConfig == null || list == null || CollectionUtils.isNullOrEmpty(list)) {
                Log.w((String)a, (String)"detect contentImportList is empty");
                continue;
            }
            this.a();
            if (cloudContentImportConfig.clearDatabase) {
                this.a(cloudManager);
            }
            for (CloudContentImportList cloudContentImportList : list) {
                if (cloudContentImportList == null) continue;
                this.a(this.getContext(), cloudManager, FileUtils.getParent((String)string2), cloudContentImportList);
            }
        }
    }

    private void a() {
        for (int i = 0; i < 3; ++i) {
            try {
                ContentUtils.querySingle((Uri)OnyxMetadataProvider.CONTENT_URI, Metadata.class, (OperatorGroup)OperatorGroup.clause(), null, (String[])new String[0]);
                StoreUtils.queryDataList(CloudGroup.class);
                break;
            }
            catch (Exception exception) {
                TestUtils.sleep((long)300L);
                continue;
            }
        }
    }

    private void a(CloudManager cloudManager) {
        StoreUtils.clearTable(CloudGroup.class);
        DataProviderBase dataProviderBase = cloudManager.getCloudDataProvider();
        dataProviderBase.clearLibrary();
        dataProviderBase.clearMetadataCollection();
        dataProviderBase.clearMetadata();
        dataProviderBase.clearThumbnails();
    }

    private void a(Context context, CloudManager cloudManager, String string2, CloudContentImportList cloudContentImportList) {
        DataProviderBase dataProviderBase = cloudManager.getCloudDataProvider();
        DatabaseWrapper databaseWrapper = FlowManager.getDatabase((String)"ContentDatabase").getWritableDatabase();
        databaseWrapper.beginTransaction();
        this.a(databaseWrapper, cloudContentImportList.group);
        Library library = this.a(context, dataProviderBase, cloudContentImportList.library);
        this.a(this.getContext(), dataProviderBase, string2, library, cloudContentImportList.metadataList);
        databaseWrapper.setTransactionSuccessful();
        databaseWrapper.endTransaction();
    }

    private String a(String string2, String string3, String string4) {
        String string5 = string3 + File.separator + string4;
        if (!this.c || StringUtils.isNullOrEmpty((String)string2)) {
            return string5;
        }
        File file = new File(CloudUtils.dataCacheDirectory(this.getContext(), string2), string4);
        boolean bl = FileUtils.copyFile((File)new File(string5), (File)file);
        if (bl) {
            return file.getAbsolutePath();
        }
        return string5;
    }

    private void a(Context context, DataProviderBase dataProviderBase, String string2, Library library, List<CloudMetadata> list) {
        if (!CollectionUtils.isNullOrEmpty(list)) {
            for (Metadata metadata : list) {
                boolean bl = this.a(context, dataProviderBase, string2, metadata);
                if (!bl) continue;
                this.a(context, dataProviderBase, library, metadata.getAssociationId());
                this.b(context, dataProviderBase, string2, metadata);
            }
        }
    }

    private boolean a(Context context, DataProviderBase dataProviderBase, String string2, Metadata metadata) {
        String string3 = FileUtils.getFileNameFromUrl((String)metadata.getLocation());
        if (StringUtils.isNotBlank((String)string3)) {
            String string4 = this.a(metadata.getGuid(), string2, string3);
            metadata.setNativeAbsolutePath(string4);
        }
        if (StringUtils.isNullOrEmpty((String)metadata.getNativeAbsolutePath())) {
            return false;
        }
        if (!FileUtils.fileExist((String)metadata.getNativeAbsolutePath())) {
            return false;
        }
        if ((metadata = CloudMetadata.createFromMetadataPath(metadata, true)) == null) {
            return false;
        }
        dataProviderBase.saveMetadata(context, metadata);
        return true;
    }

    private Library a(Context context, DataProviderBase dataProviderBase, Library library) {
        if (library == null || StringUtils.isNullOrEmpty((String)library.getIdString()) || StringUtils.isNullOrEmpty((String)library.getName())) {
            return null;
        }
        dataProviderBase.addLibrary(library);
        return library;
    }

    private void b(Context context, DataProviderBase dataProviderBase, String string2, Metadata metadata) {
        String string3 = null;
        String string4 = FileUtils.getFileNameFromUrl((String)metadata.getCoverUrl());
        if (StringUtils.isNotBlank((String)string4)) {
            string3 = this.a(metadata.getGuid(), string2, string4);
        }
        if (StringUtils.isNullOrEmpty(string3) || StringUtils.isNullOrEmpty((String)metadata.getAssociationId())) {
            return;
        }
        if (!FileUtils.fileExist((String)string3)) {
            return;
        }
        Bitmap bitmap = BitmapUtils.loadBitmapFromFile((String)string3);
        if (bitmap == null) {
            return;
        }
        ThumbnailUtils.insertThumbnail(context, dataProviderBase, metadata.getNativeAbsolutePath(), metadata.getAssociationId(), bitmap);
    }

    private void a(Context context, DataProviderBase dataProviderBase, Library library, String string2) {
        if (library == null || StringUtils.isNullOrEmpty((String)library.getIdString())) {
            return;
        }
        DataManagerHelper.saveCloudCollection(context, dataProviderBase, library.getIdString(), string2);
    }

    private void a(DatabaseWrapper databaseWrapper, CloudGroup cloudGroup) {
        if (cloudGroup == null || StringUtils.isNullOrEmpty((String)cloudGroup._id)) {
            return;
        }
        CloudGroup cloudGroup2 = StoreUtils.queryDataSingle(CloudGroup.class, new SQLOperator[]{CloudGroup_Table._id.eq((Object)cloudGroup._id)});
        if (cloudGroup2 != null && cloudGroup2.hasValidId()) {
            return;
        }
        cloudGroup.save(databaseWrapper);
    }
}

