/*
 * Decompiled with CFR 0.152.
 */
package com.onyx.android.sdk.data.compatability;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import com.onyx.android.sdk.data.OnyxDictionaryInfo;
import com.onyx.android.sdk.data.compatability.OnyxKeyValueItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;

public class OnyxSysCenter {
    private static final String b = "OnyxSysCenter";
    public static final String PROVIDER_AUTHORITY = "com.onyx.android.sdk.OnyxSysProvider";
    private static final String c = "sys.defaut_font_family";
    private static final String d = "sys.screen_update_gc_interval";
    private static final String e = "sys.suspend_interval";
    private static final String f = "sys.shutdown_interval";
    private static final String g = "sys.timezone";
    private static final String h = "sys.dict";
    private static final String i = "sys.dict_resources_path";
    private static final String j = "sys.open_last_reading";
    private static final String k = "sys.book_scan_internal_directories";
    private static final String l = "sys.book_scan_extsd_directories";
    private static final String m = "sys.startup_configuraton_flag";
    private static final String n = "sys.scribble_thickness";
    private static final String o = "sys.user_manual_deployed_flag";

    public static String getDefaultFontFamily(Context context) {
        return OnyxSysCenter.getStringValue(context, c);
    }

    public static boolean setDefaultFontFamily(Context context, String fontFamily) {
        return OnyxSysCenter.setStringValue(context, c, fontFamily);
    }

    public static int getScreenUpdateGCInterval(Context context) {
        return OnyxSysCenter.a(context, d);
    }

    public static int getScreenUpdateGCInterval(Context context, int defaultValue) {
        int n = OnyxSysCenter.getScreenUpdateGCInterval(context);
        if (n == -1) {
            n = defaultValue;
        }
        return n;
    }

    public static boolean setScreenUpdateGCInterval(Context context, int interval) {
        return OnyxSysCenter.a(context, d, interval);
    }

    public static int getSuspendInterval(Context context) {
        return OnyxSysCenter.a(context, e);
    }

    public static boolean setSuspendInterval(Context context, int interval) {
        return OnyxSysCenter.a(context, e, interval);
    }

    public static int getShutdownInterval(Context context) {
        return OnyxSysCenter.a(context, f);
    }

    public static boolean setShutdownInterval(Context context, int interval) {
        return OnyxSysCenter.a(context, f, interval);
    }

    public static String getTimezone(Context context) {
        return OnyxSysCenter.getStringValue(context, g);
    }

    public static boolean setTimezone(Context context, String timezone) {
        return OnyxSysCenter.setStringValue(context, g, timezone);
    }

    public static OnyxDictionaryInfo[] getAvailableDictionaryList(Context context) {
        OnyxDictionaryInfo[] onyxDictionaryInfoArray = OnyxDictionaryInfo.getDictionaryList();
        ArrayList<OnyxDictionaryInfo> arrayList = new ArrayList<OnyxDictionaryInfo>();
        for (OnyxDictionaryInfo onyxDictionaryInfo : onyxDictionaryInfoArray) {
            if (!OnyxDictionaryInfo.isDictionaryAvailable((Context)context, (OnyxDictionaryInfo)onyxDictionaryInfo)) continue;
            arrayList.add(onyxDictionaryInfo);
        }
        OnyxDictionaryInfo[] onyxDictionaryInfoArray2 = new OnyxDictionaryInfo[arrayList.size()];
        return arrayList.toArray(onyxDictionaryInfoArray2);
    }

    public static OnyxDictionaryInfo getDictionary(Context context) {
        String string = OnyxSysCenter.getStringValue(context, h);
        if (string == null) {
            return OnyxSysCenter.firstAvailableDictionary(context);
        }
        OnyxDictionaryInfo onyxDictionaryInfo = OnyxDictionaryInfo.findDict((String)string);
        if (onyxDictionaryInfo == null) {
            return OnyxSysCenter.firstAvailableDictionary(context);
        }
        return onyxDictionaryInfo;
    }

    public static OnyxDictionaryInfo firstAvailableDictionary(Context context) {
        for (OnyxDictionaryInfo onyxDictionaryInfo : OnyxDictionaryInfo.getDictionaryList()) {
            if (!OnyxDictionaryInfo.isDictionaryAvailable((Context)context, (OnyxDictionaryInfo)onyxDictionaryInfo)) continue;
            return onyxDictionaryInfo;
        }
        return null;
    }

    public static boolean setDictionary(Context context, OnyxDictionaryInfo dict) {
        return OnyxSysCenter.setStringValue(context, h, dict.id);
    }

    public static OnyxKeyValueItem getDictionaryResourcesPath(Context context) {
        OnyxKeyValueItem onyxKeyValueItem = OnyxSysCenter.b(context, i);
        if (onyxKeyValueItem == null) {
            return null;
        }
        return onyxKeyValueItem;
    }

    public static boolean setDictionaryResourcesPath(Context context, String path) {
        return OnyxSysCenter.setStringValue(context, i, path);
    }

    public static boolean setFileType(Context context, String key, String value) {
        key = key.toLowerCase(Locale.getDefault());
        return OnyxSysCenter.setStringValue(context, key, value);
    }

    public static String getFileType(Context context, String key) {
        key = key.toLowerCase(Locale.getDefault());
        return OnyxSysCenter.getStringValue(context, key);
    }

    public static boolean setOpenLastReadDocument(Context context, boolean b2) {
        return OnyxSysCenter.setStringValue(context, j, "" + b2);
    }

    public static boolean getOpenLastReadDocument(Context context) {
        return Boolean.valueOf(OnyxSysCenter.getStringValue(context, j));
    }

    public static boolean setBookScanInternalDirectories(Context context, Collection<String> dirs) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : dirs) {
            if (bl) {
                bl = false;
            } else {
                String string2 = "|";
                stringBuilder.append("|");
            }
            stringBuilder.append(string);
        }
        return OnyxSysCenter.setStringValue(context, k, stringBuilder.toString());
    }

    public static ArrayList<String> getBookScanInternalDirectories(Context context) {
        String string = OnyxSysCenter.getStringValue(context, k);
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            return new ArrayList<String>();
        }
        String string2 = "\\|";
        String[] stringArray = string.split("\\|");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(stringArray));
        return arrayList;
    }

    public static boolean setBookScanExtSDDirectories(Context context, Collection<String> dirs) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : dirs) {
            if (bl) {
                bl = false;
            } else {
                String string2 = "|";
                stringBuilder.append("|");
            }
            stringBuilder.append(string);
        }
        return OnyxSysCenter.setStringValue(context, l, stringBuilder.toString());
    }

    public static ArrayList<String> getBookScanExtSDDirectories(Context context) {
        String string = OnyxSysCenter.getStringValue(context, l);
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            return new ArrayList<String>();
        }
        String string2 = "\\|";
        String[] stringArray = string.split("\\|");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(stringArray));
        return arrayList;
    }

    public static boolean setStartupConfigurationFlag(Context context, int flag) {
        return OnyxSysCenter.a(context, m, flag);
    }

    public static int getStartupConfigurationFlag(Context context) {
        return OnyxSysCenter.a(context, m);
    }

    public static boolean setUserManualDeployed(Context context, boolean deployed) {
        return OnyxSysCenter.a(context, o, deployed ? 1 : 0);
    }

    public static int getUserManualDeployedFlag(Context context) {
        return OnyxSysCenter.a(context, o);
    }

    public static boolean setScribbleThickness(Context context, int thickness) {
        return OnyxSysCenter.a(context, n, thickness);
    }

    public static int getScribbleThickness(Context context, int defaultValue) {
        int n = OnyxSysCenter.a(context, n);
        if (n == -1) {
            n = defaultValue;
        }
        return n;
    }

    public static String getStringValue(Context context, String key) {
        OnyxKeyValueItem onyxKeyValueItem = OnyxSysCenter.b(context, key);
        if (onyxKeyValueItem == null) {
            return null;
        }
        return onyxKeyValueItem.getValue();
    }

    public static boolean setStringValue(Context context, String key, String value) {
        OnyxKeyValueItem onyxKeyValueItem = OnyxSysCenter.b(context, key);
        if (onyxKeyValueItem == null) {
            onyxKeyValueItem = new OnyxKeyValueItem();
            onyxKeyValueItem.setKey(key);
            onyxKeyValueItem.setValue(value);
            return OnyxSysCenter.a(context, onyxKeyValueItem);
        }
        String string = onyxKeyValueItem.getValue();
        onyxKeyValueItem.setValue(value);
        if (!OnyxSysCenter.b(context, onyxKeyValueItem)) {
            onyxKeyValueItem.setValue(string);
            return false;
        }
        return true;
    }

    private static int a(Context context, String string) {
        String string2 = OnyxSysCenter.getStringValue(context, string);
        if (string2 == null) {
            return -1;
        }
        return Integer.parseInt(string2);
    }

    private static boolean a(Context context, String string, int n) {
        return OnyxSysCenter.setStringValue(context, string, String.valueOf(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OnyxKeyValueItem b(Context context, String string) {
        try (Cursor cursor = null;){
            cursor = context.getContentResolver().query(OnyxKeyValueItem.CONTENT_URI, null, "key=?", new String[]{string}, null);
            if (cursor == null) {
                OnyxKeyValueItem onyxKeyValueItem = null;
                return onyxKeyValueItem;
            }
            if (cursor.moveToFirst()) {
                OnyxKeyValueItem onyxKeyValueItem = OnyxKeyValueItem.Columns.readColumnData(cursor);
                return onyxKeyValueItem;
            }
            OnyxKeyValueItem onyxKeyValueItem = null;
            return onyxKeyValueItem;
        }
    }

    private static boolean a(Context context, OnyxKeyValueItem onyxKeyValueItem) {
        Uri uri = context.getContentResolver().insert(OnyxKeyValueItem.CONTENT_URI, OnyxKeyValueItem.Columns.createColumnData(onyxKeyValueItem));
        if (uri == null) {
            return false;
        }
        String string = uri.getLastPathSegment();
        if (string == null) {
            return false;
        }
        onyxKeyValueItem.setId(Long.parseLong(string));
        return true;
    }

    private static boolean b(Context context, OnyxKeyValueItem onyxKeyValueItem) {
        Uri uri = Uri.withAppendedPath((Uri)OnyxKeyValueItem.CONTENT_URI, (String)String.valueOf(onyxKeyValueItem.getId()));
        int n = context.getContentResolver().update(uri, OnyxKeyValueItem.Columns.createColumnData(onyxKeyValueItem), null, null);
        if (n <= 0) {
            return false;
        }
        assert (n == 1);
        return true;
    }

    private static boolean c(Context context, OnyxKeyValueItem onyxKeyValueItem) {
        Uri uri = Uri.withAppendedPath((Uri)OnyxKeyValueItem.CONTENT_URI, (String)String.valueOf(onyxKeyValueItem.getId()));
        int n = context.getContentResolver().delete(uri, null, null);
        if (n <= 0) {
            return false;
        }
        assert (n == 1);
        return true;
    }

    public static String getStringValueFromDB(Context context, OnyxKeyValueItem item) {
        Uri uri = Uri.withAppendedPath((Uri)OnyxKeyValueItem.CONTENT_URI, (String)String.valueOf(item.getId()));
        Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
        cursor.moveToFirst();
        String string = cursor.getString(0);
        cursor.close();
        return string;
    }
}

